/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.security.permissions.expressions;

import com.yahoo.elide.security.permissions.ExpressionResult;
import com.yahoo.elide.security.permissions.PermissionCondition;
import com.yahoo.elide.security.permissions.expressions.Expression;
import java.util.Optional;

public class SpecificFieldExpression
implements Expression {
    private final Expression entityExpression;
    private final Optional<Expression> fieldExpression;
    private final PermissionCondition condition;

    public SpecificFieldExpression(PermissionCondition condition, Expression entityExpression, Expression fieldExpression) {
        this.condition = condition;
        this.entityExpression = entityExpression;
        this.fieldExpression = Optional.ofNullable(fieldExpression);
    }

    @Override
    public ExpressionResult evaluate(Expression.EvaluationMode mode) {
        if (!this.fieldExpression.isPresent()) {
            ExpressionResult entityResult = this.entityExpression == null ? ExpressionResult.PASS : this.entityExpression.evaluate(mode);
            return entityResult;
        }
        ExpressionResult fieldResult = this.fieldExpression.get().evaluate(mode);
        return fieldResult;
    }

    public String toString() {
        if (this.entityExpression == null && !this.fieldExpression.isPresent()) {
            return String.format("%s FOR EXPRESSION []", this.condition);
        }
        if (!this.fieldExpression.isPresent()) {
            return String.format("%s FOR EXPRESSION [ENTITY(%s)]", this.condition, this.entityExpression);
        }
        return String.format("%s FOR EXPRESSION [FIELD(%s)]", this.condition, this.fieldExpression.get());
    }

    public PermissionCondition getCondition() {
        return this.condition;
    }
}

