/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.utils.coerce.converters;

import com.yahoo.elide.utils.coerce.converters.Serde;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class ISO8601DateSerde
implements Serde<String, Date> {
    protected FastDateFormat df;
    protected Class<? extends Date> targetType;

    public ISO8601DateSerde(SimpleDateFormat df) {
        this(df, Date.class);
    }

    public ISO8601DateSerde(SimpleDateFormat df, Class<? extends Date> targetType) {
        this(df.toPattern(), df.getTimeZone(), targetType);
    }

    public ISO8601DateSerde(String formatString, TimeZone tz) {
        this(formatString, tz, Date.class);
    }

    public ISO8601DateSerde(String formatString, TimeZone tz, Class<? extends Date> targetType) {
        this.df = FastDateFormat.getInstance((String)formatString, (TimeZone)tz);
        this.targetType = targetType;
    }

    public ISO8601DateSerde() {
        this("yyyy-MM-dd'T'HH:mm'Z'", TimeZone.getTimeZone("UTC"));
    }

    @Override
    public Date deserialize(String val) {
        Date date;
        try {
            date = this.df.parse(val);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Date strings must be formated as " + this.df.getPattern());
        }
        if (ClassUtils.isAssignable(this.targetType, java.sql.Date.class)) {
            return new java.sql.Date(date.getTime());
        }
        if (ClassUtils.isAssignable(this.targetType, Timestamp.class)) {
            return new Timestamp(date.getTime());
        }
        if (ClassUtils.isAssignable(this.targetType, Time.class)) {
            return new Time(date.getTime());
        }
        return date;
    }

    @Override
    public String serialize(Date val) {
        return this.df.format(val);
    }
}

