/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class Path {
    private static final String PERIOD = ".";
    protected List<PathElement> pathElements;

    protected Path() {
    }

    public Path(Path copy) {
        this(copy.pathElements);
    }

    public Path(List<PathElement> pathElements) {
        this.pathElements = ImmutableList.copyOf(pathElements);
    }

    public Path(Class<?> entityClass, EntityDictionary dictionary, String dotSeparatedPath) {
        this(ClassType.of(entityClass), dictionary, dotSeparatedPath);
    }

    public Path(Type<?> entityClass, EntityDictionary dictionary, String dotSeparatedPath) {
        this.pathElements = this.resolvePathElements(entityClass, dictionary, dotSeparatedPath);
    }

    public Path(Class<?> entityClass, EntityDictionary dictionary, String fieldName, String alias, Set<Argument> arguments) {
        this(ClassType.of(entityClass), dictionary, fieldName, alias, arguments);
    }

    public Path(Type<?> entityClass, EntityDictionary dictionary, String fieldName, String alias, Set<Argument> arguments) {
        this.pathElements = Lists.newArrayList((Object[])new PathElement[]{this.resolvePathAttribute(entityClass, fieldName, alias, arguments, dictionary)});
    }

    protected List<PathElement> resolvePathElements(Type<?> entityClass, EntityDictionary dictionary, String dotSeparatedPath) {
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        String[] fieldNames = dotSeparatedPath.split("\\.");
        Type<?> currentClass = entityClass;
        for (String fieldName : fieldNames) {
            if (this.needNavigation(currentClass, fieldName, dictionary)) {
                Type<?> joinClass = dictionary.getParameterizedType(currentClass, fieldName);
                elements.add(new PathElement(currentClass, joinClass, fieldName));
                currentClass = joinClass;
                continue;
            }
            elements.add(this.resolvePathAttribute(currentClass, fieldName, fieldName, Collections.emptySet(), dictionary));
        }
        return ImmutableList.copyOf(elements);
    }

    protected PathElement resolvePathAttribute(Type<?> entityClass, String fieldName, String alias, Set<Argument> arguments, EntityDictionary dictionary) {
        if (dictionary.isAttribute(entityClass, fieldName) || fieldName.equals(dictionary.getIdFieldName(entityClass))) {
            Type<?> attributeClass = dictionary.getType(entityClass, fieldName);
            return new PathElement(entityClass, attributeClass, fieldName, alias, arguments);
        }
        if ("this".equals(fieldName)) {
            return new PathElement(entityClass, null, fieldName);
        }
        String entityAlias = dictionary.getJsonAliasFor(entityClass);
        throw new InvalidValueException((Object)(entityAlias + " does not contain the field " + fieldName));
    }

    protected boolean needNavigation(Type<?> entityClass, String fieldName, EntityDictionary dictionary) {
        return dictionary.isRelation(entityClass, fieldName) || dictionary.isComplexAttribute(entityClass, fieldName);
    }

    public Optional<PathElement> lastElement() {
        return this.pathElements.isEmpty() ? Optional.empty() : Optional.of(this.pathElements.get(this.pathElements.size() - 1));
    }

    public String getFieldPath() {
        return this.pathElements.stream().map(PathElement::getFieldName).collect(Collectors.joining(PERIOD));
    }

    public String getAlias() {
        if (this.pathElements.size() < 2) {
            return this.lastElement().map(e -> TypeHelper.getTypeAlias(e.getType())).orElse(null);
        }
        PathElement previous = this.pathElements.get(this.pathElements.size() - 2);
        return TypeHelper.appendAlias(TypeHelper.getTypeAlias(previous.getType()), previous.getFieldName());
    }

    public String toString() {
        return CollectionUtils.isEmpty(this.pathElements) ? "EMPTY" : this.pathElements.stream().map(e -> "[" + EntityDictionary.getSimpleName(e.getType()) + "]." + e.getFieldName()).collect(Collectors.joining("/"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path other = (Path)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PathElement> this$pathElements = this.getPathElements();
        List<PathElement> other$pathElements = other.getPathElements();
        return !(this$pathElements == null ? other$pathElements != null : !((Object)this$pathElements).equals(other$pathElements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Path;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PathElement> $pathElements = this.getPathElements();
        result = result * 59 + ($pathElements == null ? 43 : ((Object)$pathElements).hashCode());
        return result;
    }

    public List<PathElement> getPathElements() {
        return this.pathElements;
    }

    public static class PathElement {
        private Type type;
        private Type fieldType;
        private String fieldName;
        private String alias;
        private Set<Argument> arguments;

        public PathElement(Class<?> type, Class<?> fieldType, String fieldName) {
            this(ClassType.of(type), ClassType.of(fieldType), fieldName);
        }

        public PathElement(Type type, Type fieldType, String fieldName) {
            this.type = type;
            this.fieldType = fieldType;
            this.fieldName = fieldName;
            this.alias = fieldName;
            this.arguments = Collections.emptySet();
        }

        public PathElement(Type type, Type fieldType, String fieldName, String alias, Set<Argument> arguments) {
            this.type = type;
            this.fieldType = fieldType;
            this.fieldName = fieldName;
            this.alias = alias;
            this.arguments = arguments;
        }

        public String toString() {
            return "Path.PathElement(type=" + this.getType() + ", fieldType=" + this.getFieldType() + ", fieldName=" + this.getFieldName() + ", alias=" + this.getAlias() + ", arguments=" + this.getArguments() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathElement)) {
                return false;
            }
            PathElement other = (PathElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Type this$fieldType = this.getFieldType();
            Type other$fieldType = other.getFieldType();
            if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            Set<Argument> this$arguments = this.getArguments();
            Set<Argument> other$arguments = other.getArguments();
            return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PathElement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Type $fieldType = this.getFieldType();
            result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            Set<Argument> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            return result;
        }

        public Type getType() {
            return this.type;
        }

        public Type getFieldType() {
            return this.fieldType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getAlias() {
            return this.alias;
        }

        public Set<Argument> getArguments() {
            return this.arguments;
        }
    }
}

