/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.datastore;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreIterableBuilder;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.Injector;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.InPredicate;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.type.ParameterizedModel;
import com.yahoo.elide.core.type.Type;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

public interface DataStoreTransaction
extends Closeable {
    public <T> void save(T var1, RequestScope var2);

    public <T> void delete(T var1, RequestScope var2);

    public void flush(RequestScope var1);

    public void commit(RequestScope var1);

    default public void preCommit(RequestScope scope) {
    }

    public <T> void createObject(T var1, RequestScope var2);

    default public <T> T createNewObject(Type<T> entityClass, RequestScope scope) {
        T obj;
        Injector injector = scope.getDictionary().getInjector();
        if (entityClass.getUnderlyingClass().isPresent()) {
            obj = injector.instantiate(entityClass.getUnderlyingClass().get());
        } else {
            try {
                obj = entityClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                obj = null;
            }
        }
        return obj;
    }

    default public <T> T loadObject(EntityProjection entityProjection, Serializable id, RequestScope scope) {
        Iterator it;
        Type<?> entityClass = entityProjection.getType();
        FilterExpression filterExpression = entityProjection.getFilterExpression();
        EntityDictionary dictionary = scope.getDictionary();
        Type<?> idType = dictionary.getIdType(entityClass);
        String idField = dictionary.getIdFieldName(entityClass);
        InPredicate idFilter = new InPredicate(new Path.PathElement(entityClass, idType, idField), id);
        FilterExpression joinedFilterExpression = filterExpression != null ? new AndFilterExpression(idFilter, filterExpression) : idFilter;
        DataStoreIterable<T> results = this.loadObjects(entityProjection.copyOf().filterExpression(joinedFilterExpression).build(), scope);
        Iterator iterator = it = results == null ? null : results.iterator();
        if (it != null && it.hasNext()) {
            Object obj = it.next();
            if (!it.hasNext()) {
                return obj;
            }
            throw new InvalidObjectIdentifierException(id.toString(), dictionary.getJsonAliasFor(entityClass));
        }
        return null;
    }

    public <T> DataStoreIterable<T> loadObjects(EntityProjection var1, RequestScope var2);

    default public <T, R> DataStoreIterable<R> getToManyRelation(DataStoreTransaction relationTx, T entity, Relationship relationship, RequestScope scope) {
        return new DataStoreIterableBuilder((Iterable)PersistentResource.getValue(entity, relationship.getName(), scope)).allInMemory().build();
    }

    default public <T, R> R getToOneRelation(DataStoreTransaction relationTx, T entity, Relationship relationship, RequestScope scope) {
        return (R)PersistentResource.getValue(entity, relationship.getName(), scope);
    }

    default public <T, R> void updateToManyRelation(DataStoreTransaction relationTx, T entity, String relationName, Set<R> newRelationships, Set<R> deletedRelationships, RequestScope scope) {
    }

    default public <T, R> void updateToOneRelation(DataStoreTransaction relationTx, T entity, String relationName, R relationshipValue, RequestScope scope) {
    }

    default public <T, R> R getAttribute(T entity, Attribute attribute, RequestScope scope) {
        if (entity instanceof ParameterizedModel) {
            return (R)((ParameterizedModel)entity).invoke(attribute);
        }
        return (R)PersistentResource.getValue(entity, attribute.getName(), scope);
    }

    default public <T> void setAttribute(T entity, Attribute attribute, RequestScope scope) {
    }

    public void cancel(RequestScope var1);

    default public <T> T getProperty(String propertyName) {
        return null;
    }
}

