/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.dictionary;

import com.yahoo.elide.core.type.Type;

public final class ArgumentType {
    private final String name;
    private final Type<?> type;
    private final Object defaultValue;

    public ArgumentType(String name, Type<?> type) {
        this(name, type, null);
    }

    public ArgumentType(String name, Type<?> type, Object defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public static ArgumentTypeBuilder builder() {
        return new ArgumentTypeBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Type<?> getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArgumentType)) {
            return false;
        }
        ArgumentType other = (ArgumentType)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Type<?> this$type = this.getType();
        Type<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Type<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    public String toString() {
        return "ArgumentType(name=" + this.getName() + ", type=" + this.getType() + ", defaultValue=" + this.getDefaultValue() + ")";
    }

    public static class ArgumentTypeBuilder {
        private String name;
        private Type<?> type;
        private Object defaultValue;

        ArgumentTypeBuilder() {
        }

        public ArgumentTypeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ArgumentTypeBuilder type(Type<?> type) {
            this.type = type;
            return this;
        }

        public ArgumentTypeBuilder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ArgumentType build() {
            return new ArgumentType(this.name, this.type, this.defaultValue);
        }

        public String toString() {
            return "ArgumentType.ArgumentTypeBuilder(name=" + this.name + ", type=" + this.type + ", defaultValue=" + this.defaultValue + ")";
        }
    }
}

