/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.dictionary;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yahoo.elide.annotation.ApiVersion;
import com.yahoo.elide.annotation.ComputedAttribute;
import com.yahoo.elide.annotation.ComputedRelationship;
import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.annotation.NonTransferable;
import com.yahoo.elide.annotation.OnCreatePostCommit;
import com.yahoo.elide.annotation.OnCreatePreCommit;
import com.yahoo.elide.annotation.OnCreatePreSecurity;
import com.yahoo.elide.annotation.OnDeletePostCommit;
import com.yahoo.elide.annotation.OnDeletePreCommit;
import com.yahoo.elide.annotation.OnDeletePreSecurity;
import com.yahoo.elide.annotation.OnReadPostCommit;
import com.yahoo.elide.annotation.OnReadPreCommit;
import com.yahoo.elide.annotation.OnReadPreSecurity;
import com.yahoo.elide.annotation.OnUpdatePostCommit;
import com.yahoo.elide.annotation.OnUpdatePreCommit;
import com.yahoo.elide.annotation.OnUpdatePreSecurity;
import com.yahoo.elide.annotation.SecurityCheck;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.dictionary.ArgumentType;
import com.yahoo.elide.core.dictionary.EntityBinding;
import com.yahoo.elide.core.dictionary.Injector;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.lifecycle.LifeCycleHook;
import com.yahoo.elide.core.security.PermissionExecutor;
import com.yahoo.elide.core.security.checks.Check;
import com.yahoo.elide.core.security.checks.UserCheck;
import com.yahoo.elide.core.security.checks.prefab.Collections;
import com.yahoo.elide.core.security.checks.prefab.Role;
import com.yahoo.elide.core.type.AccessibleObject;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Dynamic;
import com.yahoo.elide.core.type.Field;
import com.yahoo.elide.core.type.Method;
import com.yahoo.elide.core.type.Package;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.DefaultClassScanner;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Transient;
import javax.ws.rs.WebApplicationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDictionary {
    private static final Logger log = LoggerFactory.getLogger(EntityDictionary.class);
    public static final String ELIDE_PACKAGE_PREFIX = "com.yahoo.elide";
    public static final String NO_VERSION = "";
    public static final Injector DEFAULT_INJECTOR = noop -> {};
    private static final Map<Class<?>, Type<?>> TYPE_MAP = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Pair<String, String>, Type<?>> bindJsonApiToEntity = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Type<?>, EntityBinding> entityBindings = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Type<?>, Function<RequestScope, PermissionExecutor>> entityPermissionExecutor = new ConcurrentHashMap();
    protected final CopyOnWriteArrayList<Type<?>> bindEntityRoots = new CopyOnWriteArrayList();
    protected final ConcurrentHashMap<Type<?>, List<Type<?>>> subclassingEntities = new ConcurrentHashMap();
    protected final BiMap<String, Class<? extends Check>> checkNames;
    protected final Map<Class<? extends Check>, Check> checkInstances;
    protected final Map<String, UserCheck> roleChecks;
    protected final Set<String> apiVersions;
    protected final Injector injector;
    protected final ClassScanner scanner;
    protected final Function<Class, Serde> serdeLookup;
    private final Set<Type<?>> entitiesToExclude;
    public static final String REGULAR_ID_NAME = "id";
    private static final ConcurrentHashMap<Type, String> SIMPLE_NAMES = new ConcurrentHashMap();
    private static final String ALL_FIELDS = "*";

    public EntityDictionary(Map<String, Class<? extends Check>> checks, Map<String, UserCheck> roleChecks, Injector injector, Function<Class, Serde> serdeLookup, Set<Type<?>> entitiesToExclude, ClassScanner scanner) {
        this.scanner = scanner;
        this.serdeLookup = serdeLookup;
        this.checkNames = Maps.synchronizedBiMap((BiMap)HashBiMap.create(checks));
        this.checkInstances = new ConcurrentHashMap<Class<? extends Check>, Check>();
        this.roleChecks = roleChecks == null ? new HashMap<String, UserCheck>() : new HashMap<String, UserCheck>(roleChecks);
        this.apiVersions = new HashSet<String>();
        this.initializeChecks();
        this.injector = injector;
        this.entitiesToExclude = new HashSet(entitiesToExclude);
        this.checkNames.keySet().forEach(checkName -> this.getCheckInstance((String)checkName));
    }

    private void initializeChecks() {
        Role.ALL all = new Role.ALL();
        Role.NONE none = new Role.NONE();
        this.addRoleCheck("Prefab.Role.All", all);
        this.addRoleCheck("ALL", all);
        this.addRoleCheck("Prefab.Role.None", none);
        this.addRoleCheck("NONE", none);
        this.addPrefabCheck("Prefab.Collections.AppendOnly", Collections.AppendOnly.class);
        this.addPrefabCheck("Prefab.Collections.RemoveOnly", Collections.RemoveOnly.class);
    }

    private void addPrefabCheck(String alias, Class<? extends Check> checkClass) {
        if (this.checkNames.containsKey((Object)alias) || this.checkNames.inverse().containsKey(checkClass)) {
            return;
        }
        this.checkNames.put((Object)alias, checkClass);
    }

    private static Package getParentPackage(Package pkg) {
        return pkg.getParentPackage();
    }

    public void addRoleCheck(String role, UserCheck check) {
        this.roleChecks.put(role, check);
    }

    public UserCheck getRoleCheck(String role) {
        return this.roleChecks.get(role);
    }

    public Map<String, UserCheck> getRoleChecks() {
        return this.roleChecks;
    }

    public Set<String> getCheckIdentifiers() {
        return Sets.union(this.roleChecks.keySet(), (Set)this.checkNames.keySet());
    }

    public static String getSimpleName(Type<?> cls) {
        return SIMPLE_NAMES.computeIfAbsent(cls, key -> cls.getSimpleName());
    }

    public static Method findMethod(Type<?> entityClass, String name, Type<?> ... paramClass) throws NoSuchMethodException {
        Method m = entityClass.getMethod(name, paramClass);
        int modifiers = m.getModifiers();
        if (Modifier.isAbstract(modifiers) || m.isAnnotationPresent(Transient.class) && !m.isAnnotationPresent(ComputedAttribute.class) && !m.isAnnotationPresent(ComputedRelationship.class)) {
            throw new NoSuchMethodException(name);
        }
        return m;
    }

    public EntityBinding getEntityBinding(Type<?> entityClass) {
        EntityBinding binding = this.entityBindings.get(entityClass);
        if (binding != null) {
            return binding;
        }
        Type<?> declaredClass = this.lookupBoundClass(entityClass);
        if (declaredClass != null) {
            return this.entityBindings.get(declaredClass);
        }
        this.lookupEntityClass(entityClass);
        return EntityBinding.EMPTY_BINDING;
    }

    public boolean isIdGenerated(Type<?> entityClass) {
        return this.getEntityBinding(entityClass).isIdGenerated();
    }

    public Type<?> getEntityClass(String entityName, String version) {
        Type lookup = this.bindJsonApiToEntity.getOrDefault(Pair.of((Object)entityName, (Object)version), null);
        if (lookup == null) {
            return this.entityBindings.values().stream().filter(binding -> binding.entityClass.getName().startsWith(ELIDE_PACKAGE_PREFIX)).filter(binding -> binding.jsonApiType.equals(entityName)).map(EntityBinding::getEntityClass).findFirst().orElse(null);
        }
        return lookup;
    }

    public String getJsonAliasFor(Type<?> entityClass) {
        return this.getEntityBinding(entityClass).jsonApiType;
    }

    public boolean entityHasChecksForPermission(Type<?> resourceClass, Class<? extends Annotation> annotationClass) {
        EntityBinding binding = this.getEntityBinding(resourceClass);
        return binding.entityPermissions.hasChecksForPermission(annotationClass);
    }

    public ParseTree getPermissionsForClass(Type<?> resourceClass, Class<? extends Annotation> annotationClass) {
        EntityBinding binding = this.getEntityBinding(resourceClass);
        return binding.entityPermissions.getClassChecksForPermission(annotationClass);
    }

    public ParseTree getPermissionsForField(Type<?> resourceClass, String field, Class<? extends Annotation> annotationClass) {
        EntityBinding binding = this.getEntityBinding(resourceClass);
        return binding.entityPermissions.getFieldChecksForPermission(field, annotationClass);
    }

    public Class<? extends Check> getCheck(String checkIdentifier) {
        return (Class)this.checkNames.computeIfAbsent((Object)checkIdentifier, cls -> {
            try {
                return Class.forName(checkIdentifier).asSubclass(Check.class);
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not instantiate specified check '" + checkIdentifier + "'.", e);
            }
        });
    }

    public Check getCheckInstance(String checkIdentifier) {
        Check check;
        if (this.roleChecks.containsKey(checkIdentifier)) {
            return this.roleChecks.get(checkIdentifier);
        }
        Class<? extends Check> checkClass = this.getCheck(checkIdentifier);
        if (this.checkInstances.containsKey(checkClass)) {
            check = this.checkInstances.get(checkClass);
        } else {
            check = this.injector.instantiate(checkClass);
            this.injector.inject(check);
            this.checkInstances.put(checkClass, check);
        }
        return check;
    }

    public List<Type<?>> getSuperClassEntities(Type<?> entityClass) {
        return this.getEntityBinding(entityClass).inheritedTypes.stream().filter(this.entityBindings::containsKey).collect(Collectors.toList());
    }

    public List<Type<?>> getSubclassingEntities(Type entityClass) {
        return this.subclassingEntities.computeIfAbsent(entityClass, unused -> this.entityBindings.keySet().stream().filter(c -> c != entityClass && entityClass.isAssignableFrom((Type<?>)c)).collect(Collectors.toList()));
    }

    public String getCheckIdentifier(Class<? extends Check> checkClass) {
        String identifier = (String)this.checkNames.inverse().get(checkClass);
        if (identifier != null) {
            return identifier;
        }
        if (UserCheck.class.isAssignableFrom(checkClass)) {
            for (Map.Entry<String, UserCheck> entry : this.roleChecks.entrySet()) {
                UserCheck check = entry.getValue();
                String name = entry.getKey();
                if (!check.getClass().equals(checkClass)) continue;
                return name;
            }
        }
        return checkClass.getName();
    }

    public String getIdFieldName(Type<?> entityClass) {
        return this.getEntityBinding(entityClass).getIdFieldName();
    }

    public AccessType getAccessType(Type<?> entityClass) {
        return this.getEntityBinding(entityClass).getAccessType();
    }

    public Set<Type<?>> getBoundClasses() {
        return this.getBoundClasses(true);
    }

    public Set<Type<?>> getBoundClasses(boolean elideModelsOnly) {
        return this.entityBindings.values().stream().filter(binding -> elideModelsOnly ? binding.isElideModel() : true).map(EntityBinding::getEntityClass).collect(Collectors.toSet());
    }

    public Set<Type<?>> getBoundClassesByVersion(String apiVersion, boolean elideModelsOnly) {
        return this.entityBindings.values().stream().filter(binding -> elideModelsOnly ? binding.isElideModel() : true).filter(binding -> binding.getApiVersion().equals(apiVersion) || binding.entityClass.getName().startsWith(ELIDE_PACKAGE_PREFIX)).map(EntityBinding::getEntityClass).collect(Collectors.toSet());
    }

    public Set<Type<?>> getBoundClassesByVersion(String apiVersion) {
        return this.getBoundClassesByVersion(apiVersion, true);
    }

    public Set<EntityBinding> getBindings() {
        return this.getBindings(true);
    }

    public Set<EntityBinding> getBindings(boolean elideModelsOnly) {
        return this.entityBindings.values().stream().filter(binding -> elideModelsOnly ? binding.isElideModel() : true).collect(Collectors.toSet());
    }

    public Map<String, Class<? extends Check>> getCheckMappings() {
        return this.checkNames;
    }

    public List<String> getAttributes(Type<?> entityClass) {
        return this.getEntityBinding(entityClass).apiAttributes;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public List<String> getAttributes(Object entity) {
        return this.getAttributes(EntityDictionary.getType(entity));
    }

    public List<String> getRelationships(Type<?> entityClass) {
        return this.getEntityBinding(entityClass).apiRelationships;
    }

    public List<String> getRelationships(Object entity) {
        return this.getRelationships(EntityDictionary.getType(entity));
    }

    public List<String> getElideBoundRelationships(Type<?> entityClass) {
        return this.getRelationships(entityClass).stream().filter(relationName -> this.getBoundClasses().contains(this.getParameterizedType(entityClass, (String)relationName))).collect(Collectors.toList());
    }

    public List<String> getElideBoundRelationships(Object entity) {
        return this.getElideBoundRelationships(EntityDictionary.getType(entity));
    }

    public boolean isMethodRequestScopeable(Object entity, Method method) {
        return this.isMethodRequestScopeable(EntityDictionary.getType(entity), method);
    }

    public boolean isMethodRequestScopeable(Type<?> entityClass, Method method) {
        return this.getEntityBinding(entityClass).requestScopeableMethods.getOrDefault(method, false);
    }

    public List<String> getAllExposedFields(Type<?> entityClass) {
        ArrayList<String> fields = new ArrayList<String>();
        List<String> attrs = this.getAttributes(entityClass);
        List<String> rels = this.getRelationships(entityClass);
        if (attrs != null) {
            fields.addAll(attrs);
        }
        if (rels != null) {
            fields.addAll(rels);
        }
        return fields;
    }

    public List<String> getAllExposedFields(Object entity) {
        return this.getAllExposedFields(EntityDictionary.getType(entity));
    }

    public RelationshipType getRelationshipType(Type<?> cls, String relation) {
        ConcurrentHashMap<String, RelationshipType> types = this.getEntityBinding(cls).relationshipTypes;
        if (types == null) {
            return RelationshipType.NONE;
        }
        RelationshipType type = types.get(relation);
        return type == null ? RelationshipType.NONE : type;
    }

    public String getRelationInverse(Type<?> cls, String relation) {
        String mapping;
        EntityBinding clsBinding = this.getEntityBinding(cls);
        ConcurrentHashMap<String, String> mappings = clsBinding.relationshipToInverse;
        if (mappings != null && (mapping = mappings.get(relation)) != null && !NO_VERSION.equals(mapping)) {
            return mapping;
        }
        Type<?> inverseType = this.getParameterizedType(cls, relation);
        ConcurrentHashMap<String, String> inverseMappings = this.getEntityBinding(inverseType).relationshipToInverse;
        for (Map.Entry<String, String> inverseMapping : inverseMappings.entrySet()) {
            String inverseRelationName = inverseMapping.getKey();
            String inverseMappedBy = inverseMapping.getValue();
            if (!relation.equals(inverseMappedBy) || !this.getParameterizedType(inverseType, inverseRelationName).equals(clsBinding.entityClass)) continue;
            return inverseRelationName;
        }
        return NO_VERSION;
    }

    public RelationshipType getRelationshipType(Object entity, String relation) {
        return this.getRelationshipType(EntityDictionary.getType(entity), relation);
    }

    public Type<?> getType(Type<?> entityClass, String identifier) {
        if (identifier.equals(REGULAR_ID_NAME)) {
            return this.getEntityBinding(entityClass).getIdType();
        }
        ConcurrentHashMap<String, Type<?>> fieldTypes = this.getEntityBinding(entityClass).fieldsToTypes;
        return fieldTypes == null ? null : fieldTypes.get(identifier);
    }

    public Type<?> getType(Object entity, String identifier) {
        return this.getType(EntityDictionary.getType(entity), identifier);
    }

    public Type<?> getParameterizedType(Type<?> entityClass, String identifier) {
        return this.getParameterizedType(entityClass, identifier, 0);
    }

    public Type<?> getParameterizedType(Type<?> entityClass, String identifier, int paramIndex) {
        ConcurrentHashMap<String, AccessibleObject> fieldOrMethods = this.getEntityBinding(entityClass).fieldsToValues;
        if (fieldOrMethods == null) {
            return null;
        }
        AccessibleObject fieldOrMethod = fieldOrMethods.get(identifier);
        if (fieldOrMethod == null) {
            return null;
        }
        return EntityBinding.getFieldType(entityClass, fieldOrMethod, Optional.of(paramIndex));
    }

    public Type<?> getParameterizedType(Object entity, String identifier) {
        return this.getParameterizedType(EntityDictionary.getType(entity), identifier);
    }

    public Type<?> getParameterizedType(Object entity, String identifier, int paramIndex) {
        return this.getParameterizedType(EntityDictionary.getType(entity), identifier, paramIndex);
    }

    public String getNameFromAlias(Type<?> entityClass, String alias) {
        ConcurrentHashMap<String, String> map = this.getEntityBinding(entityClass).aliasesToFields;
        if (map != null) {
            return map.get(alias);
        }
        return null;
    }

    public String getNameFromAlias(Object entity, String alias) {
        return this.getNameFromAlias(EntityDictionary.getType(entity), alias);
    }

    public <T> void initializeEntity(T entity) {
        EntityBinding binding;
        Type<T> type = EntityDictionary.getType(entity);
        if (entity != null && (binding = this.getEntityBinding(type)).isInjected()) {
            this.injector.inject(entity);
        }
    }

    public boolean isTransferable(Type<?> entityClass) {
        NonTransferable nonTransferable = this.getAnnotation(entityClass, NonTransferable.class);
        return nonTransferable == null || !nonTransferable.enabled();
    }

    public boolean isStrictNonTransferable(Type<?> entityClass) {
        NonTransferable nonTransferable = this.getAnnotation(entityClass, NonTransferable.class);
        return nonTransferable != null && nonTransferable.enabled() && nonTransferable.strict();
    }

    public void bindEntity(Class<?> cls) {
        this.bindEntity(ClassType.of(cls));
    }

    public void bindEntity(Type<?> cls) {
        this.bindEntity(cls, (AccessibleObject unused) -> false);
    }

    public void bindEntity(Class<?> cls, Predicate<AccessibleObject> isFieldHidden) {
        this.bindEntity(ClassType.of(cls), isFieldHidden);
    }

    public void bindEntity(Type<?> cls, Predicate<AccessibleObject> isFieldHidden) {
        Type<?> declaredClass = this.lookupIncludeClass(cls);
        if (this.entitiesToExclude.contains(declaredClass)) {
            return;
        }
        if (declaredClass == null) {
            log.trace("Missing include or excluded class {}", (Object)cls.getName());
            return;
        }
        if (this.isClassBound(declaredClass)) {
            return;
        }
        String type = EntityDictionary.getEntityName(declaredClass);
        String version = EntityDictionary.getModelVersion(declaredClass);
        this.bindJsonApiToEntity.put((Pair<String, String>)Pair.of((Object)type, (Object)version), declaredClass);
        this.apiVersions.add(version);
        EntityBinding binding = new EntityBinding(this.injector, declaredClass, type, version, isFieldHidden);
        this.entityBindings.put(declaredClass, binding);
        Include include = (Include)EntityDictionary.getFirstAnnotation(declaredClass, Arrays.asList(Include.class));
        if (include != null && include.rootLevel()) {
            this.bindEntityRoots.add(declaredClass);
        }
        this.bindLegacyHooks(binding);
        this.discoverEmbeddedTypeBindings(declaredClass);
    }

    public void bindEntity(EntityBinding entityBinding) {
        Type<?> declaredClass = entityBinding.entityClass;
        if (this.entitiesToExclude.contains(declaredClass)) {
            return;
        }
        if (this.isClassBound(declaredClass)) {
            return;
        }
        Include include = (Include)EntityDictionary.getFirstAnnotation(declaredClass, Collections.singletonList(Include.class));
        String version = EntityDictionary.getModelVersion(declaredClass);
        this.bindJsonApiToEntity.put((Pair<String, String>)Pair.of((Object)entityBinding.jsonApiType, (Object)version), declaredClass);
        this.entityBindings.put(declaredClass, entityBinding);
        this.apiVersions.add(version);
        if (include != null && include.rootLevel()) {
            this.bindEntityRoots.add(declaredClass);
        }
    }

    public void bindPermissionExecutor(Class<?> clz, Function<RequestScope, PermissionExecutor> permissionExecutorFunction) {
        this.bindPermissionExecutor(ClassType.of(clz), permissionExecutorFunction);
    }

    public void bindPermissionExecutor(Type<?> clz, Function<RequestScope, PermissionExecutor> permissionExecutorFunction) {
        this.entityPermissionExecutor.put(this.lookupBoundClass(clz), permissionExecutorFunction);
    }

    public Map<Type<?>, PermissionExecutor> buildPermissionExecutors(RequestScope scope) {
        return this.entityPermissionExecutor.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (PermissionExecutor)((Function)e.getValue()).apply(scope)));
    }

    public <A extends Annotation> A getAnnotation(PersistentResource record, Class<A> annotationClass) {
        return this.getAnnotation(record.getResourceType(), annotationClass);
    }

    public <A extends Annotation> A getAnnotation(Type<?> recordClass, Class<A> annotationClass) {
        return this.getEntityBinding(recordClass).getAnnotation(annotationClass);
    }

    public <A extends Annotation> boolean hasAnnotation(Type<?> recordClass, Class<A> annotationClass) {
        if (this.getAnnotation(recordClass, annotationClass) != null) {
            return true;
        }
        for (String fieldName : this.getEntityBinding(recordClass).fieldsToValues.keySet()) {
            if (this.getAttributeOrRelationAnnotation(recordClass, annotationClass, fieldName) == null) continue;
            return true;
        }
        return false;
    }

    public <A extends Annotation> A getMethodAnnotation(Type<?> recordClass, String method, Class<A> annotationClass) {
        return this.getEntityBinding(recordClass).getMethodAnnotation(annotationClass, method);
    }

    public Collection<LifeCycleHook> getTriggers(Type<?> cls, LifeCycleHookBinding.Operation op, LifeCycleHookBinding.TransactionPhase phase, String fieldName) {
        return this.getEntityBinding(cls).getTriggers(op, phase, fieldName);
    }

    public Collection<LifeCycleHook> getTriggers(Type<?> cls, LifeCycleHookBinding.Operation op, LifeCycleHookBinding.TransactionPhase phase) {
        return this.getEntityBinding(cls).getTriggers(op, phase);
    }

    public <A extends Annotation> A getAttributeOrRelationAnnotation(Type<?> entityClass, Class<A> annotationClass, String identifier) {
        AccessibleObject fieldOrMethod = this.getEntityBinding(entityClass).fieldsToValues.get(identifier);
        if (fieldOrMethod == null) {
            return null;
        }
        return fieldOrMethod.getAnnotation(annotationClass);
    }

    public <A extends Annotation> A[] getAttributeOrRelationAnnotations(Type<?> entityClass, Class<A> annotationClass, String identifier) {
        AccessibleObject fieldOrMethod = this.getEntityBinding(entityClass).fieldsToValues.get(identifier);
        if (fieldOrMethod == null) {
            return null;
        }
        return fieldOrMethod.getAnnotationsByType(annotationClass);
    }

    public static Annotation getFirstAnnotation(Type<?> entityClass, List<Class<? extends Annotation>> annotationClassList) {
        Annotation annotation = null;
        for (Type<?> cls = entityClass; annotation == null && cls != null; cls = cls.getSuperclass()) {
            for (Class<? extends Annotation> annotationClass : annotationClassList) {
                annotation = cls.getDeclaredAnnotation(annotationClass);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return EntityDictionary.getFirstPackageAnnotation(entityClass, annotationClassList);
    }

    public static Annotation getFirstPackageAnnotation(Type<?> entityClass, List<Class<? extends Annotation>> annotationClassList) {
        Annotation annotation = null;
        Package pkg = entityClass.getPackage();
        while (annotation == null && pkg != null) {
            Class<? extends Annotation> annotationClass;
            Iterator<Class<? extends Annotation>> iterator = annotationClassList.iterator();
            while (iterator.hasNext() && (annotation = pkg.getDeclaredAnnotation(annotationClass = iterator.next())) == null) {
            }
            pkg = EntityDictionary.getParentPackage(pkg);
        }
        return annotation;
    }

    public boolean isRoot(Type<?> entityClass) {
        return this.bindEntityRoots.contains(entityClass);
    }

    public String getId(Object value) {
        if (value == null) {
            return null;
        }
        try {
            Type<?> idClass;
            Object idValue;
            AccessibleObject idField = null;
            for (Type<Object> valueClass = EntityDictionary.getType(value); idField == null && valueClass != null; valueClass = valueClass.getSuperclass()) {
                try {
                    idField = this.getEntityBinding(valueClass).getIdField();
                    continue;
                }
                catch (NullPointerException e) {
                    log.warn("Class: {} ID Field: {}", (Object)valueClass.getSimpleName(), (Object)idField);
                }
            }
            if (idField instanceof Field) {
                idValue = ((Field)idField).get(value);
                idClass = ((Field)idField).getType();
            } else if (idField instanceof Method) {
                idValue = ((Method)idField).invoke(value, null);
                idClass = ((Method)idField).getReturnType();
            } else {
                return null;
            }
            Serde serde = this.serdeLookup.apply(((ClassType)idClass).getCls());
            if (serde != null) {
                return String.valueOf(serde.serialize(idValue));
            }
            return String.valueOf(idValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    public Type<?> getIdType(Type<?> entityClass) {
        return this.getEntityBinding(entityClass).getIdType();
    }

    public Collection<Annotation> getIdAnnotations(Object value) {
        if (value == null) {
            return null;
        }
        AccessibleObject idField = this.getEntityBinding(EntityDictionary.getType(value)).getIdField();
        if (idField != null) {
            return Arrays.asList(idField.getDeclaredAnnotations());
        }
        return Collections.emptyList();
    }

    public Type<?> lookupEntityClass(Type<?> objClass) {
        Type<?> declaringClass = EntityDictionary.lookupAnnotationDeclarationClass(objClass, Entity.class);
        if (declaringClass != null) {
            return declaringClass;
        }
        throw new IllegalArgumentException("Unbound Entity " + objClass);
    }

    public Type<?> lookupIncludeClass(Type<?> objClass) {
        Annotation first = EntityDictionary.getFirstAnnotation(objClass, Arrays.asList(Exclude.class, Include.class));
        if (first instanceof Include) {
            Type<?> declaringClass = EntityDictionary.lookupAnnotationDeclarationClass(objClass, Include.class);
            if (declaringClass != null) {
                return declaringClass;
            }
            return objClass;
        }
        return null;
    }

    public static Type<?> lookupAnnotationDeclarationClass(Type<?> objClass, Class<? extends Annotation> annotationClass) {
        for (Type<?> cls = objClass; cls != null; cls = cls.getSuperclass()) {
            if (cls.getDeclaredAnnotation(annotationClass) == null) continue;
            return cls;
        }
        return null;
    }

    public Type<?> lookupBoundClass(Type<?> objClass) {
        EntityBinding binding = this.entityBindings.getOrDefault(objClass, EntityBinding.EMPTY_BINDING);
        if (binding != EntityBinding.EMPTY_BINDING) {
            return binding.entityClass;
        }
        Type<?> declaredClass = this.lookupIncludeClass(objClass);
        if (declaredClass == null) {
            return null;
        }
        binding = this.entityBindings.getOrDefault(declaredClass, EntityBinding.EMPTY_BINDING);
        if (binding != EntityBinding.EMPTY_BINDING) {
            return binding.entityClass;
        }
        try {
            return this.lookupEntityClass(declaredClass.getSuperclass());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean isClassBound(Type<?> objClass) {
        return this.entityBindings.getOrDefault(objClass, EntityBinding.EMPTY_BINDING) != EntityBinding.EMPTY_BINDING;
    }

    public final boolean isJPAEntity(Type<?> objClass) {
        try {
            this.lookupEntityClass(objClass);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public AccessibleObject getAccessibleObject(Object target, String fieldName) {
        return this.getAccessibleObject(EntityDictionary.getType(target), fieldName);
    }

    public boolean isComputed(Type<?> entityClass, String fieldName) {
        AccessibleObject fieldOrMethod = this.getAccessibleObject(entityClass, fieldName);
        return fieldOrMethod != null && (fieldOrMethod.isAnnotationPresent(ComputedAttribute.class) || fieldOrMethod.isAnnotationPresent(ComputedRelationship.class));
    }

    public AccessibleObject getAccessibleObject(Type<?> targetClass, String fieldName) {
        return this.getEntityBinding(targetClass).fieldsToValues.get(fieldName);
    }

    public Set<String> getFieldsOfType(Type<?> targetClass, Type<?> targetType) {
        HashSet<String> fields = new HashSet<String>();
        for (String field : this.getAllExposedFields(targetClass)) {
            if (!this.getParameterizedType(targetClass, field).equals(targetType)) continue;
            fields.add(field);
        }
        return fields;
    }

    public boolean isRelation(Type<?> entityClass, String relationName) {
        return this.getEntityBinding(entityClass).apiRelationships.contains(relationName);
    }

    public boolean isAttribute(Type<?> entityClass, String attributeName) {
        return this.getEntityBinding(entityClass).apiAttributes.contains(attributeName);
    }

    public void scanForSecurityChecks() {
        Set<Class<?>> classes = this.scanner.getAnnotatedClasses(SecurityCheck.class);
        this.addSecurityChecks(classes);
    }

    public void addSecurityChecks(Set<Class<?>> classes) {
        if (CollectionUtils.isEmpty(classes)) {
            return;
        }
        classes.forEach(this::addSecurityCheck);
    }

    public void addSecurityCheck(Class<?> cls) {
        if (!Check.class.isAssignableFrom(cls)) {
            throw new IllegalStateException("Class annotated with SecurityCheck is not a Check");
        }
        SecurityCheck securityCheckMeta = cls.getAnnotation(SecurityCheck.class);
        log.debug("Register Elide Check [{}] with expression [{}]", (Object)cls.getCanonicalName(), (Object)securityCheckMeta.value());
        this.checkNames.put((Object)securityCheckMeta.value(), cls.asSubclass(Check.class));
        this.getCheckInstance(securityCheckMeta.value());
    }

    public void bindTrigger(Class<?> entityClass, String fieldOrMethodName, LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, LifeCycleHook hook) {
        this.bindTrigger(ClassType.of(entityClass), fieldOrMethodName, operation, phase, hook);
    }

    public void bindTrigger(Type<?> entityClass, String fieldOrMethodName, LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, LifeCycleHook hook) {
        this.bindIfUnbound(entityClass);
        this.getEntityBinding(entityClass).bindTrigger(operation, phase, fieldOrMethodName, hook);
    }

    public void bindTrigger(Class<?> entityClass, LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, LifeCycleHook hook, boolean allowMultipleInvocations) {
        this.bindTrigger(ClassType.of(entityClass), operation, phase, hook, allowMultipleInvocations);
    }

    public void bindTrigger(Type<?> entityClass, LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, LifeCycleHook hook, boolean allowMultipleInvocations) {
        this.bindIfUnbound(entityClass);
        if (allowMultipleInvocations) {
            this.getEntityBinding(entityClass).bindTrigger(operation, phase, hook);
        } else {
            this.getEntityBinding(entityClass).bindTrigger(operation, phase, NO_VERSION, hook);
        }
    }

    public boolean cascadeDeletes(Type<?> targetClass, String fieldName) {
        CascadeType[] cascadeTypes;
        for (CascadeType cascadeType : cascadeTypes = this.getEntityBinding(targetClass).relationshipToCascadeTypes.getOrDefault(fieldName, new CascadeType[0])) {
            if (cascadeType != CascadeType.ALL && cascadeType != CascadeType.REMOVE) continue;
            return true;
        }
        return false;
    }

    public <T> List<T> walkEntityGraph(Set<Type<?>> entities, Function<Type<?>, T> transform) {
        ArrayList<T> results = new ArrayList<T>();
        ArrayDeque toVisit = new ArrayDeque(entities);
        HashSet<Type> visited = new HashSet<Type>();
        while (!toVisit.isEmpty()) {
            Type clazz = (Type)toVisit.remove();
            results.add(transform.apply(clazz));
            visited.add(clazz);
            for (String relationship : this.getElideBoundRelationships(clazz)) {
                Type<?> relationshipClass = this.getParameterizedType(clazz, relationship);
                if (this.lookupBoundClass(relationshipClass) == null || visited.contains(relationshipClass)) continue;
                toVisit.add(relationshipClass);
            }
        }
        return results;
    }

    public boolean hasBinding(Type<?> cls) {
        return this.entityBindings.values().stream().anyMatch(binding -> binding.entityClass.equals(cls));
    }

    public Object getValue(Object target, String fieldName, RequestScope scope) {
        AccessibleObject accessor = this.getAccessibleObject(target, fieldName);
        try {
            if (accessor instanceof Method) {
                if (this.isMethodRequestScopeable(target, (Method)accessor)) {
                    return ((Method)accessor).invoke(target, scope);
                }
                return ((Method)accessor).invoke(target, new Object[0]);
            }
            if (accessor instanceof Field) {
                return ((Field)accessor).get(target);
            }
        }
        catch (IllegalAccessException e) {
            throw new InvalidAttributeException(fieldName, this.getJsonAliasFor(EntityDictionary.getType(target)), e);
        }
        catch (InvocationTargetException e) {
            throw EntityDictionary.handleInvocationTargetException(e);
        }
        throw new InvalidAttributeException(fieldName, this.getJsonAliasFor(EntityDictionary.getType(target)));
    }

    public void setId(Object target, String id) {
        this.setValue(target, this.getIdFieldName(this.lookupBoundClass(EntityDictionary.getType(target))), id);
    }

    public void setValue(Object target, String fieldName, Object value) {
        Type<Object> targetClass = EntityDictionary.getType(target);
        String targetType = this.getJsonAliasFor(targetClass);
        String fieldAlias = fieldName;
        try {
            Type<?> fieldClass = this.getType(targetClass, fieldName);
            String realName = this.getNameFromAlias(target, fieldName);
            fieldAlias = realName != null ? realName : fieldName;
            String setMethod = "set" + StringUtils.capitalize((String)fieldAlias);
            Method method = EntityDictionary.findMethod(targetClass, setMethod, fieldClass);
            method.invoke(target, this.coerce(target, value, fieldAlias, fieldClass));
        }
        catch (IllegalAccessException e) {
            throw new InvalidAttributeException(fieldAlias, targetType, e);
        }
        catch (InvocationTargetException e) {
            throw EntityDictionary.handleInvocationTargetException(e);
        }
        catch (IllegalArgumentException | NoSuchMethodException noMethod) {
            AccessibleObject accessor = this.getAccessibleObject(target, fieldAlias);
            if (accessor != null && accessor instanceof Field) {
                Field field = (Field)accessor;
                try {
                    field.set(target, this.coerce(target, value, fieldAlias, field.getType()));
                }
                catch (IllegalAccessException noField) {
                    throw new InvalidAttributeException(fieldAlias, targetType, noField);
                }
            }
            throw new InvalidAttributeException(fieldAlias, targetType);
        }
    }

    private static RuntimeException handleInvocationTargetException(InvocationTargetException e) {
        Throwable exception = e.getTargetException();
        if (exception instanceof HttpStatusException || exception instanceof WebApplicationException) {
            return (RuntimeException)exception;
        }
        log.error("Caught an unexpected exception (rethrowing as internal server error)", (Throwable)e);
        return new InternalServerErrorException("Unexpected exception caught", e);
    }

    public Object coerce(Object target, Object value, String fieldName, Type<?> fieldType) {
        Class fieldClass = null;
        if (fieldType != null) {
            Preconditions.checkState((boolean)(fieldType instanceof ClassType));
            fieldClass = ((ClassType)fieldType).getCls();
            if (ClassType.COLLECTION_TYPE.isAssignableFrom((Type)fieldType) && value instanceof Collection) {
                return this.coerceCollection(target, (Collection)value, fieldName, fieldClass);
            }
            if (ClassType.MAP_TYPE.isAssignableFrom((Type)fieldType) && value instanceof Map) {
                return this.coerceMap(target, (Map)value, fieldName);
            }
        }
        return CoerceUtil.coerce(value, fieldClass);
    }

    private Collection coerceCollection(Object target, Collection<?> values, String fieldName, Class<?> fieldClass) {
        ClassType providedType = (ClassType)this.getParameterizedType(target, fieldName);
        if (fieldClass.isAssignableFrom(values.getClass())) {
            boolean valid = true;
            for (Object member : values) {
                if (member == null || providedType.isAssignableFrom((Type)EntityDictionary.getType(member))) continue;
                valid = false;
                break;
            }
            if (valid) {
                return values;
            }
        }
        ArrayList list = new ArrayList(values.size());
        for (Object member : values) {
            list.add(CoerceUtil.coerce(member, providedType.getCls()));
        }
        if (Set.class.isAssignableFrom(fieldClass)) {
            return new LinkedHashSet(list);
        }
        return list;
    }

    private Map coerceMap(Object target, Map<?, ?> values, String fieldName) {
        Class valueType;
        Class keyType = ((ClassType)this.getParameterizedType(target, fieldName, 0)).getCls();
        if (this.isValidParameterizedMap(values, keyType, valueType = ((ClassType)this.getParameterizedType(target, fieldName, 1)).getCls())) {
            return values;
        }
        LinkedHashMap result = new LinkedHashMap(values.size());
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            result.put(CoerceUtil.coerce(entry.getKey(), keyType), CoerceUtil.coerce(entry.getValue(), valueType));
        }
        return result;
    }

    public <A extends Annotation> boolean attributeOrRelationAnnotationExists(Type<?> cls, String fieldName, Class<A> annotationClass) {
        return this.getAttributeOrRelationAnnotation(cls, annotationClass, fieldName) != null;
    }

    public boolean isValidField(Type<?> cls, String fieldName) {
        return this.getAllExposedFields(cls).contains(fieldName);
    }

    private boolean isValidParameterizedMap(Map<?, ?> values, Class<?> keyType, Class<?> valueType) {
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if ((key == null || keyType.isAssignableFrom(key.getClass())) && (value == null || valueType.isAssignableFrom(value.getClass()))) continue;
            return false;
        }
        return true;
    }

    private void bindIfUnbound(Type<?> entityClass) {
        if (!this.isClassBound(entityClass)) {
            this.bindEntity(entityClass);
        }
    }

    public void addArgumentsToAttribute(Type<?> cls, String attributeName, Set<ArgumentType> arguments) {
        this.getEntityBinding(cls).addArgumentsToAttribute(attributeName, arguments);
    }

    public void addArgumentToAttribute(Type<?> cls, String attributeName, ArgumentType argument) {
        this.addArgumentsToAttribute(cls, attributeName, Sets.newHashSet((Object[])new ArgumentType[]{argument}));
    }

    public void addArgumentToEntity(Type<?> cls, ArgumentType argument) {
        this.getEntityBinding(cls).addArgumentToEntity(argument);
    }

    public Set<ArgumentType> getAttributeArguments(Type<?> cls, String attributeName) {
        return this.entityBindings.getOrDefault(cls, EntityBinding.EMPTY_BINDING).getAttributeArguments(attributeName);
    }

    public Set<ArgumentType> getEntityArguments(Type<?> cls) {
        return this.entityBindings.getOrDefault(cls, EntityBinding.EMPTY_BINDING).getEntityArguments();
    }

    public String getAnnotatedColumnName(Type<?> cls, String fieldName) {
        Column[] column = (Column[])this.getAttributeOrRelationAnnotations(cls, Column.class, fieldName);
        JoinColumn[] joinColumn = (JoinColumn[])this.getAttributeOrRelationAnnotations(cls, JoinColumn.class, fieldName);
        if (column == null || column.length == 0) {
            if (joinColumn == null || joinColumn.length == 0) {
                return fieldName;
            }
            return joinColumn[0].name();
        }
        return column[0].name();
    }

    protected void discoverEmbeddedTypeBindings(Type<?> elideModel) {
        ArrayDeque toVisit = new ArrayDeque();
        HashSet<Type> visited = new HashSet<Type>();
        EntityBinding binding = this.getEntityBinding(elideModel);
        toVisit.addAll(binding.getAttributes().stream().filter(this::canBind).collect(Collectors.toSet()));
        while (!toVisit.isEmpty()) {
            Type next = (Type)toVisit.remove();
            if (visited.contains(next) || this.entityBindings.containsKey(next)) continue;
            visited.add(next);
            EntityBinding nextBinding = new EntityBinding(this.injector, next, next.getSimpleName(), binding.getApiVersion(), false, unused -> false);
            this.entityBindings.put(next, nextBinding);
            toVisit.addAll(nextBinding.getAttributes().stream().filter(this::canBind).collect(Collectors.toSet()));
        }
    }

    public static String getModelVersion(Type<?> modelClass) {
        ApiVersion apiVersionAnnotation = (ApiVersion)EntityDictionary.getFirstPackageAnnotation(modelClass, Arrays.asList(ApiVersion.class));
        return apiVersionAnnotation == null ? NO_VERSION : apiVersionAnnotation.version();
    }

    private static String getEntityPrefix(Type<?> modelClass) {
        Include include = (Include)EntityDictionary.getFirstPackageAnnotation(modelClass, Arrays.asList(Include.class));
        if (include == null || include.name() == null || include.name().isEmpty()) {
            return NO_VERSION;
        }
        return include.name() + "_";
    }

    public static String getEntityName(Type<?> modelClass) {
        Type<?> declaringClass = EntityDictionary.lookupAnnotationDeclarationClass(modelClass, Include.class);
        if (declaringClass == null) {
            declaringClass = EntityDictionary.lookupAnnotationDeclarationClass(modelClass, Entity.class);
        }
        String entityPrefix = EntityDictionary.getEntityPrefix(modelClass);
        Preconditions.checkNotNull(declaringClass);
        Include include = declaringClass.getAnnotation(Include.class);
        if (include != null && !NO_VERSION.equals(include.name())) {
            return entityPrefix + include.name();
        }
        Entity entity = (Entity)EntityDictionary.getFirstAnnotation(declaringClass, Arrays.asList(Entity.class));
        if (entity == null || NO_VERSION.equals(entity.name())) {
            return entityPrefix + StringUtils.uncapitalize((String)declaringClass.getSimpleName());
        }
        return entityPrefix + entity.name();
    }

    public static String getEntityDescription(Type<?> modelClass) {
        Include include = (Include)EntityDictionary.getFirstAnnotation(modelClass, Arrays.asList(Include.class));
        if (include == null || include.description().isEmpty()) {
            return null;
        }
        return include.description();
    }

    public static <T> Type<T> getType(T object) {
        if (object instanceof Dynamic) {
            return ((Dynamic)object).getType();
        }
        ClassType classType = (ClassType)TYPE_MAP.computeIfAbsent(object.getClass(), ClassType::new);
        return classType;
    }

    public void bindLegacyHooks(EntityBinding binding) {
        binding.getAllMethods().stream().map(Method.class::cast).forEach(method -> {
            if (method.isAnnotationPresent(OnCreatePostCommit.class)) {
                this.bindHookMethod(binding, (Method)method, method.getAnnotation(OnCreatePostCommit.class).value(), LifeCycleHookBinding.TransactionPhase.POSTCOMMIT, LifeCycleHookBinding.Operation.CREATE);
            }
            if (method.isAnnotationPresent(OnCreatePreCommit.class)) {
                this.bindHookMethod(binding, (Method)method, method.getAnnotation(OnCreatePreCommit.class).value(), LifeCycleHookBinding.TransactionPhase.PRECOMMIT, LifeCycleHookBinding.Operation.CREATE);
            }
            if (method.isAnnotationPresent(OnCreatePreSecurity.class)) {
                this.bindHookMethod(binding, (Method)method, method.getAnnotation(OnCreatePreSecurity.class).value(), LifeCycleHookBinding.TransactionPhase.PRESECURITY, LifeCycleHookBinding.Operation.CREATE);
            }
            if (method.isAnnotationPresent(OnUpdatePostCommit.class)) {
                this.bindHookMethod(binding, (Method)method, method.getAnnotation(OnUpdatePostCommit.class).value(), LifeCycleHookBinding.TransactionPhase.POSTCOMMIT, LifeCycleHookBinding.Operation.UPDATE);
            }
            if (method.isAnnotationPresent(OnUpdatePreCommit.class)) {
                this.bindHookMethod(binding, (Method)method, method.getAnnotation(OnUpdatePreCommit.class).value(), LifeCycleHookBinding.TransactionPhase.PRECOMMIT, LifeCycleHookBinding.Operation.UPDATE);
            }
            if (method.isAnnotationPresent(OnUpdatePreSecurity.class)) {
                this.bindHookMethod(binding, (Method)method, method.getAnnotation(OnUpdatePreSecurity.class).value(), LifeCycleHookBinding.TransactionPhase.PRESECURITY, LifeCycleHookBinding.Operation.UPDATE);
            }
            if (method.isAnnotationPresent(OnReadPostCommit.class)) {
                this.bindHookMethod(binding, (Method)method, method.getAnnotation(OnReadPostCommit.class).value(), LifeCycleHookBinding.TransactionPhase.POSTCOMMIT, LifeCycleHookBinding.Operation.READ);
            }
            if (method.isAnnotationPresent(OnReadPreCommit.class)) {
                this.bindHookMethod(binding, (Method)method, method.getAnnotation(OnReadPreCommit.class).value(), LifeCycleHookBinding.TransactionPhase.PRECOMMIT, LifeCycleHookBinding.Operation.READ);
            }
            if (method.isAnnotationPresent(OnReadPreSecurity.class)) {
                this.bindHookMethod(binding, (Method)method, method.getAnnotation(OnReadPreSecurity.class).value(), LifeCycleHookBinding.TransactionPhase.PRESECURITY, LifeCycleHookBinding.Operation.READ);
            }
            if (method.isAnnotationPresent(OnDeletePostCommit.class)) {
                this.bindHookMethod(binding, (Method)method, null, LifeCycleHookBinding.TransactionPhase.POSTCOMMIT, LifeCycleHookBinding.Operation.DELETE);
            }
            if (method.isAnnotationPresent(OnDeletePreCommit.class)) {
                this.bindHookMethod(binding, (Method)method, null, LifeCycleHookBinding.TransactionPhase.PRECOMMIT, LifeCycleHookBinding.Operation.DELETE);
            }
            if (method.isAnnotationPresent(OnDeletePreSecurity.class)) {
                this.bindHookMethod(binding, (Method)method, null, LifeCycleHookBinding.TransactionPhase.PRESECURITY, LifeCycleHookBinding.Operation.DELETE);
            }
        });
    }

    public boolean isComplexAttribute(Type<?> clazz, String fieldName) {
        EntityBinding binding = this.getEntityBinding(clazz);
        if (!binding.apiAttributes.contains(fieldName)) {
            return false;
        }
        Type<?> attributeType = this.getType(clazz, fieldName);
        return this.canBind(attributeType);
    }

    private void bindHookMethod(EntityBinding binding, Method method, String annotationField, LifeCycleHookBinding.TransactionPhase phase, LifeCycleHookBinding.Operation operation) {
        if (StringUtils.isEmpty((CharSequence)annotationField)) {
            this.bindTrigger(binding.entityClass, operation, phase, EntityDictionary.generateHook(method), false);
        } else if (annotationField.equals(ALL_FIELDS)) {
            this.bindTrigger(binding.entityClass, operation, phase, EntityDictionary.generateHook(method), true);
        } else {
            this.bindTrigger(binding.entityClass, annotationField, operation, phase, EntityDictionary.generateHook(method));
        }
    }

    private static LifeCycleHook generateHook(Method method) {
        return (operation, phase, model, scope, changes) -> {
            block5: {
                try {
                    int paramCount = method.getParameterCount();
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (changes.isPresent() && paramCount == 2 && paramTypes[0].isInstance(scope) && paramTypes[1].isInstance(changes.get())) {
                        method.invoke(model, scope, changes.get());
                        break block5;
                    }
                    if (paramCount == 1 && paramTypes[0].isInstance(scope)) {
                        method.invoke(model, scope);
                        break block5;
                    }
                    if (paramCount == 0) {
                        method.invoke(model, new Object[0]);
                        break block5;
                    }
                    throw new IllegalArgumentException();
                }
                catch (ReflectiveOperationException e) {
                    Throwables.propagateIfPossible((Throwable)e.getCause());
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }

    private boolean canBind(Type<?> type) {
        if (!type.getUnderlyingClass().isPresent()) {
            return false;
        }
        Class<?> clazz = type.getUnderlyingClass().get();
        return !ClassUtils.isPrimitiveOrWrapper(clazz) && !clazz.equals(String.class) && !clazz.isEnum() && !Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz) && this.serdeLookup.apply(clazz) == null;
    }

    public static EntityDictionaryBuilder builder() {
        return new EntityDictionaryBuilder();
    }

    public ConcurrentHashMap<Type<?>, Function<RequestScope, PermissionExecutor>> getEntityPermissionExecutor() {
        return this.entityPermissionExecutor;
    }

    public Set<String> getApiVersions() {
        return this.apiVersions;
    }

    public ClassScanner getScanner() {
        return this.scanner;
    }

    public Function<Class, Serde> getSerdeLookup() {
        return this.serdeLookup;
    }

    public Set<Type<?>> getEntitiesToExclude() {
        return this.entitiesToExclude;
    }

    public static class EntityDictionaryBuilder {
        private Map<String, Class<? extends Check>> checks;
        private Map<String, UserCheck> roleChecks;
        private Injector injector;
        private Function<Class, Serde> serdeLookup;
        private Set<Type<?>> entitiesToExclude;
        private ClassScanner scanner;

        public EntityDictionary build() {
            if (this.scanner == null) {
                this.scanner = DefaultClassScanner.getInstance();
            }
            if (this.roleChecks == null) {
                this.roleChecks = Collections.emptyMap();
            }
            if (this.checks == null) {
                this.checks = Collections.emptyMap();
            }
            if (this.serdeLookup == null) {
                this.serdeLookup = CoerceUtil::lookup;
            }
            if (this.injector == null) {
                this.injector = DEFAULT_INJECTOR;
            }
            if (this.entitiesToExclude == null) {
                this.entitiesToExclude = Collections.emptySet();
            }
            return new EntityDictionary(this.checks, this.roleChecks, this.injector, this.serdeLookup, this.entitiesToExclude, this.scanner);
        }

        EntityDictionaryBuilder() {
        }

        public EntityDictionaryBuilder checks(Map<String, Class<? extends Check>> checks) {
            this.checks = checks;
            return this;
        }

        public EntityDictionaryBuilder roleChecks(Map<String, UserCheck> roleChecks) {
            this.roleChecks = roleChecks;
            return this;
        }

        public EntityDictionaryBuilder injector(Injector injector) {
            this.injector = injector;
            return this;
        }

        public EntityDictionaryBuilder serdeLookup(Function<Class, Serde> serdeLookup) {
            this.serdeLookup = serdeLookup;
            return this;
        }

        public EntityDictionaryBuilder entitiesToExclude(Set<Type<?>> entitiesToExclude) {
            this.entitiesToExclude = entitiesToExclude;
            return this;
        }

        public EntityDictionaryBuilder scanner(ClassScanner scanner) {
            this.scanner = scanner;
            return this;
        }

        public String toString() {
            return "EntityDictionary.EntityDictionaryBuilder(checks=" + this.checks + ", roleChecks=" + this.roleChecks + ", injector=" + this.injector + ", serdeLookup=" + this.serdeLookup + ", entitiesToExclude=" + this.entitiesToExclude + ", scanner=" + this.scanner + ")";
        }
    }
}

