/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ErrorObjects {
    private final List<Map<String, Object>> errors;

    public ErrorObjects(List<Map<String, Object>> errors) {
        this.errors = Objects.requireNonNull(errors, "errors must not be null");
    }

    public static ErrorObjectsBuilder builder() {
        return new ErrorObjectsBuilder();
    }

    public List<Map<String, Object>> getErrors() {
        return this.errors;
    }

    public static class ErrorObjectsBuilder {
        private final List<Map<String, Object>> errors = new ArrayList<Map<String, Object>>();
        private Map<String, Object> currentError;

        ErrorObjectsBuilder() {
        }

        public ErrorObjectsBuilder withId(String id) {
            return this.with("id", id);
        }

        public ErrorObjectsBuilder withStatus(String status) {
            return this.with("status", status);
        }

        public ErrorObjectsBuilder withCode(String code) {
            return this.with("code", code);
        }

        public ErrorObjectsBuilder withTitle(String title) {
            return this.with("title", title);
        }

        public ErrorObjectsBuilder withDetail(String detail) {
            return this.with("detail", detail);
        }

        public ErrorObjectsBuilder with(String key, Object value) {
            this.currentError.put(key, value);
            return this;
        }

        public ErrorObjectsBuilder addError() {
            this.validateCurrentError();
            HashMap<String, Object> error = new HashMap<String, Object>();
            this.errors.add(error);
            this.currentError = error;
            return this;
        }

        public ErrorObjects build() {
            if (this.errors.isEmpty()) {
                throw new IllegalArgumentException("At least one error is required");
            }
            this.validateCurrentError();
            return new ErrorObjects(this.errors);
        }

        private void validateCurrentError() throws IllegalArgumentException {
            if (this.currentError != null && this.currentError.isEmpty()) {
                throw new IllegalArgumentException("Error must contain at least one key-value pair");
            }
        }
    }
}

