/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.security.permissions.expressions.Expression;
import com.yahoo.elide.core.type.ClassType;
import java.lang.annotation.Annotation;
import java.util.Optional;

public class ForbiddenAccessException
extends HttpStatusException {
    private static final long serialVersionUID = 1L;
    private final Optional<Expression> expression;
    private final Optional<Expression.EvaluationMode> evaluationMode;

    public ForbiddenAccessException(Class<? extends Annotation> permission) {
        this(permission, null, null);
    }

    public ForbiddenAccessException(Class<? extends Annotation> permission, Expression expression, Expression.EvaluationMode mode) {
        super(403, ForbiddenAccessException.getMessage(permission), null, () -> ForbiddenAccessException.getMessage(permission) + ": " + expression);
        this.expression = Optional.ofNullable(expression);
        this.evaluationMode = Optional.ofNullable(mode);
    }

    public String getLoggedMessage() {
        return String.format("ForbiddenAccessException: Message=%s\tMode=%s\tExpression=[%s]", this.getVerboseMessage(), this.getEvaluationMode(), this.getExpression());
    }

    private static String getMessage(Class<? extends Annotation> permission) {
        return EntityDictionary.getSimpleName(ClassType.of(permission)) + " Denied";
    }

    public Optional<Expression> getExpression() {
        return this.expression;
    }

    public Optional<Expression.EvaluationMode> getEvaluationMode() {
        return this.evaluationMode;
    }
}

