/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.lifecycle;

import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.lifecycle.CRUDEvent;
import com.yahoo.elide.core.lifecycle.LifeCycleHook;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Optional;

public class LifecycleHookInvoker
implements Observer<CRUDEvent> {
    private EntityDictionary dictionary;
    private LifeCycleHookBinding.Operation op;
    private LifeCycleHookBinding.TransactionPhase phase;
    private Optional<RuntimeException> exception;
    private boolean throwsExceptions;

    public LifecycleHookInvoker(EntityDictionary dictionary, LifeCycleHookBinding.Operation op, LifeCycleHookBinding.TransactionPhase phase, boolean throwExceptions) {
        this.dictionary = dictionary;
        this.op = op;
        this.phase = phase;
        this.exception = Optional.empty();
        this.throwsExceptions = throwExceptions;
    }

    public void onSubscribe(Disposable disposable) {
    }

    public void onNext(CRUDEvent event) {
        block3: {
            ArrayList<LifeCycleHook> hooks = new ArrayList<LifeCycleHook>();
            hooks.addAll(this.dictionary.getTriggers(event.getResource().getResourceType(), this.op, this.phase, event.getFieldName()));
            if (!event.getFieldName().isEmpty()) {
                hooks.addAll(this.dictionary.getTriggers(event.getResource().getResourceType(), this.op, this.phase));
            }
            try {
                hooks.forEach(hook -> hook.execute(this.op, this.phase, event));
            }
            catch (RuntimeException e) {
                this.exception = Optional.of(e);
                if (!this.throwsExceptions) break block3;
                throw e;
            }
        }
    }

    public void onError(Throwable throwable) {
    }

    public void onComplete() {
    }

    public void throwOnError() {
        this.exception.ifPresent(e -> {
            throw e;
        });
    }
}

