/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.checks.prefab;

import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.RequestScope;
import com.yahoo.elide.core.security.checks.OperationCheck;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Collections {
    private static Predicate<? super ChangeSpec> changeSpecIsCollection = c -> c.getModified() instanceof Collection;

    private Collections() {
        throw new UnsupportedOperationException();
    }

    private static boolean collectionIsSuperset(Supplier<?> base, Supplier<?> potential) {
        Collection baseCollection = (Collection)base.get();
        Collection potentialSuperset = (Collection)potential.get();
        return potentialSuperset.size() >= baseCollection.size() && potentialSuperset.containsAll(baseCollection);
    }

    public static class RemoveOnly<T>
    extends OperationCheck<T> {
        @Override
        public boolean ok(T record, RequestScope requestScope, Optional<ChangeSpec> changeSpec) {
            return changeSpec.filter(changeSpecIsCollection).filter(c -> Collections.collectionIsSuperset(c::getModified, c::getOriginal)).isPresent();
        }
    }

    public static class AppendOnly<T>
    extends OperationCheck<T> {
        @Override
        public boolean ok(T record, RequestScope requestScope, Optional<ChangeSpec> changeSpec) {
            return changeSpec.filter(changeSpecIsCollection).filter(c -> Collections.collectionIsSuperset(c::getOriginal, c::getModified)).isPresent();
        }
    }
}

