/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.sort;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;

public class SortingImpl
implements Sorting {
    private final Map<String, Sorting.SortOrder> sortRules = new LinkedHashMap<String, Sorting.SortOrder>();
    private static final SortingImpl DEFAULT_EMPTY_INSTANCE = null;
    private static final String JSONAPI_ID_KEYWORD = "id";
    private Type<?> type;
    private Map<Path, Sorting.SortOrder> sortingPaths;
    private Set<Attribute> attributes;

    public SortingImpl(Map<String, Sorting.SortOrder> sortingRules, Type<?> type, EntityDictionary dictionary) {
        this(sortingRules, type, Collections.emptySet(), dictionary);
    }

    public SortingImpl(Map<String, Sorting.SortOrder> sortingRules, Class<?> type, EntityDictionary dictionary) {
        this(sortingRules, ClassType.of(type), dictionary);
    }

    public SortingImpl(Map<String, Sorting.SortOrder> sortingRules, Type<?> type, Set<Attribute> attributes, EntityDictionary dictionary) {
        if (sortingRules != null) {
            this.sortRules.putAll(sortingRules);
        }
        this.attributes = attributes;
        this.type = type;
        this.sortingPaths = this.getValidSortingRules(type, attributes, dictionary);
    }

    private <T> Map<Path, Sorting.SortOrder> getValidSortingRules(Type<T> entityClass, Set<Attribute> attributes, EntityDictionary dictionary) throws InvalidValueException {
        LinkedHashMap<Path, Sorting.SortOrder> returnMap = new LinkedHashMap<Path, Sorting.SortOrder>();
        for (Map.Entry<String, Sorting.SortOrder> entry : this.replaceIdRule(dictionary.getIdFieldName(entityClass)).entrySet()) {
            Attribute attribute;
            String dotSeparatedPath = entry.getKey();
            Sorting.SortOrder order = entry.getValue();
            Path path = dotSeparatedPath.contains(".") ? new Path(entityClass, dictionary, dotSeparatedPath) : ((attribute = (Attribute)attributes.stream().filter(attr -> attr.getName().equals(dotSeparatedPath) || attr.getAlias().equals(dotSeparatedPath)).findFirst().orElse(null)) == null ? new Path(entityClass, dictionary, dotSeparatedPath) : new Path(entityClass, dictionary, attribute.getName(), attribute.getAlias(), attribute.getArguments()));
            if (!SortingImpl.isValidSortRulePath(path, dictionary)) {
                throw new InvalidValueException((Object)("Cannot sort across a to-many relationship: " + path.getFieldPath()));
            }
            returnMap.put(path, order);
        }
        return returnMap;
    }

    protected static boolean isValidSortRulePath(Path path, EntityDictionary dictionary) {
        for (Path.PathElement pathElement : path.getPathElements()) {
            if (!dictionary.isRelation(pathElement.getType(), pathElement.getFieldName()) || !dictionary.getRelationshipType(pathElement.getType(), pathElement.getFieldName()).isToMany()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDefaultInstance() {
        return this.sortRules.isEmpty();
    }

    public static Sorting parseQueryParams(MultivaluedMap<String, String> queryParams, Type<?> type, EntityDictionary dictionary) {
        if (queryParams.isEmpty()) {
            return DEFAULT_EMPTY_INSTANCE;
        }
        List<String> sortRules = queryParams.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("sort")).map(entry -> (String)((List)entry.getValue()).get(0)).collect(Collectors.toList());
        return SortingImpl.parseSortRules(sortRules, type, Collections.emptySet(), dictionary);
    }

    public static Sorting parseSortRule(String sortRule, Type<?> type, EntityDictionary dictionary) {
        return SortingImpl.parseSortRules(Arrays.asList(sortRule), type, Collections.emptySet(), dictionary);
    }

    public static Sorting parseSortRule(String sortRule, Type<?> type, Set<Attribute> attributes, EntityDictionary dictionary) {
        return SortingImpl.parseSortRules(Arrays.asList(sortRule), type, attributes, dictionary);
    }

    private static SortingImpl parseSortRules(List<String> sortRules, Type<?> type, Set<Attribute> attributes, EntityDictionary dictionary) {
        LinkedHashMap<String, Sorting.SortOrder> sortingRules = new LinkedHashMap<String, Sorting.SortOrder>();
        for (String sortRule : sortRules) {
            if (sortRule.contains(",")) {
                for (String sortRuleSplit : sortRule.split(",")) {
                    SortingImpl.parseSortRule(sortRuleSplit, sortingRules);
                }
                continue;
            }
            SortingImpl.parseSortRule(sortRule, sortingRules);
        }
        return sortingRules.isEmpty() ? DEFAULT_EMPTY_INSTANCE : new SortingImpl(sortingRules, type, attributes, dictionary);
    }

    private static void parseSortRule(String sortRule, Map<String, Sorting.SortOrder> sortingRules) {
        boolean isDesc = false;
        char firstCharacter = sortRule.charAt(0);
        if (firstCharacter == '-') {
            isDesc = true;
            sortRule = sortRule.substring(1);
        }
        if (firstCharacter == '+') {
            sortRule = sortRule.substring(1);
        }
        sortingRules.put(sortRule, isDesc ? Sorting.SortOrder.desc : Sorting.SortOrder.asc);
    }

    private LinkedHashMap<String, Sorting.SortOrder> replaceIdRule(String idFieldName) {
        LinkedHashMap<String, Sorting.SortOrder> result = new LinkedHashMap<String, Sorting.SortOrder>();
        for (Map.Entry<String, Sorting.SortOrder> entry : this.sortRules.entrySet()) {
            String key = entry.getKey();
            Sorting.SortOrder value = entry.getValue();
            if (JSONAPI_ID_KEYWORD.equals(key)) {
                result.put(idFieldName, value);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static Sorting getDefaultEmptyInstance() {
        return DEFAULT_EMPTY_INSTANCE;
    }

    public String toString() {
        return "SortingImpl(sortRules=" + this.sortRules + ", type=" + this.getType() + ", sortingPaths=" + this.getSortingPaths() + ", attributes=" + this.attributes + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortingImpl)) {
            return false;
        }
        SortingImpl other = (SortingImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Sorting.SortOrder> this$sortRules = this.sortRules;
        Map<String, Sorting.SortOrder> other$sortRules = other.sortRules;
        if (this$sortRules == null ? other$sortRules != null : !((Object)this$sortRules).equals(other$sortRules)) {
            return false;
        }
        Type<?> this$type = this.getType();
        Type<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<Path, Sorting.SortOrder> this$sortingPaths = this.getSortingPaths();
        Map<Path, Sorting.SortOrder> other$sortingPaths = other.getSortingPaths();
        if (this$sortingPaths == null ? other$sortingPaths != null : !((Object)this$sortingPaths).equals(other$sortingPaths)) {
            return false;
        }
        Set<Attribute> this$attributes = this.attributes;
        Set<Attribute> other$attributes = other.attributes;
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortingImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Sorting.SortOrder> $sortRules = this.sortRules;
        result = result * 59 + ($sortRules == null ? 43 : ((Object)$sortRules).hashCode());
        Type<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<Path, Sorting.SortOrder> $sortingPaths = this.getSortingPaths();
        result = result * 59 + ($sortingPaths == null ? 43 : ((Object)$sortingPaths).hashCode());
        Set<Attribute> $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Override
    public Type<?> getType() {
        return this.type;
    }

    @Override
    public Map<Path, Sorting.SortOrder> getSortingPaths() {
        return this.sortingPaths;
    }
}

