/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.utils;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedFunction<R>
implements Supplier<R> {
    private static final Logger log = LoggerFactory.getLogger(TimedFunction.class);
    private Supplier<R> toRun;
    private String logMessage;

    public TimedFunction(Supplier<R> toRun, String logMessage) {
        this.toRun = toRun;
        this.logMessage = logMessage;
    }

    @Override
    public R get() {
        long start = System.currentTimeMillis();
        R ret = this.toRun.get();
        long end = System.currentTimeMillis();
        log.debug(this.logMessage + "\tTime spent: {}", (Object)(end - start));
        return ret;
    }

    public Supplier<R> getToRun() {
        return this.toRun;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setToRun(Supplier<R> toRun) {
        this.toRun = toRun;
    }

    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimedFunction)) {
            return false;
        }
        TimedFunction other = (TimedFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<R> this$toRun = this.getToRun();
        Supplier<R> other$toRun = other.getToRun();
        if (this$toRun == null ? other$toRun != null : !this$toRun.equals(other$toRun)) {
            return false;
        }
        String this$logMessage = this.getLogMessage();
        String other$logMessage = other.getLogMessage();
        return !(this$logMessage == null ? other$logMessage != null : !this$logMessage.equals(other$logMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimedFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<R> $toRun = this.getToRun();
        result = result * 59 + ($toRun == null ? 43 : $toRun.hashCode());
        String $logMessage = this.getLogMessage();
        result = result * 59 + ($logMessage == null ? 43 : $logMessage.hashCode());
        return result;
    }

    public String toString() {
        return "TimedFunction(toRun=" + this.getToRun() + ", logMessage=" + this.getLogMessage() + ")";
    }
}

