/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.utils.coerce;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.core.utils.coerce.BidirectionalConvertUtilBean;
import com.yahoo.elide.core.utils.coerce.converters.FromMapConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.core.utils.coerce.converters.ToEnumConverter;
import com.yahoo.elide.core.utils.coerce.converters.ToUUIDConverter;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;

public class CoerceUtil {
    private static final ToEnumConverter TO_ENUM_CONVERTER = new ToEnumConverter();
    private static final ToUUIDConverter TO_UUID_CONVERTER = new ToUUIDConverter();
    private static final FromMapConverter FROM_MAP_CONVERTER = new FromMapConverter();
    private static final Map<Class<?>, Serde<?, ?>> SERDES = new HashMap();
    private static final BeanUtilsBean BEAN_UTILS_BEAN_INSTANCE = CoerceUtil.setup();
    private static final Set<ClassLoader> INITIALIZED_CLASSLOADERS = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());

    public static <T> T coerce(Object value, Type<T> type) {
        Preconditions.checkState((boolean)(type instanceof ClassType));
        Class cls = ((ClassType)type).getCls();
        return CoerceUtil.coerce(value, cls);
    }

    public static <T> T coerce(Object value, Class<T> cls) {
        CoerceUtil.initializeCurrentClassLoaderIfNecessary();
        if (value == null && TypeHelper.isNumberType(cls)) {
            return (T)Array.get(Array.newInstance(cls, 1), 0);
        }
        if (value == null || cls == null || cls.isInstance(value)) {
            return (T)value;
        }
        try {
            return (T)ConvertUtils.convert((Object)value, cls);
        }
        catch (InvalidAttributeException | IllegalArgumentException | ConversionException e) {
            throw new InvalidValueException(value, e.getMessage());
        }
    }

    public static <S, T> void register(Class<T> targetType, final Serde<S, T> serde) {
        CoerceUtil.initializeCurrentClassLoaderIfNecessary();
        SERDES.put(targetType, serde);
        ConvertUtils.register((Converter)new Converter(){

            public <T> T convert(Class<T> aClass, Object o) {
                return serde.deserialize(o);
            }
        }, targetType);
    }

    public static <S, T> Serde<S, T> lookup(Class<T> targetType) {
        return SERDES.getOrDefault(targetType, null);
    }

    public static Map<Class<?>, Serde<?, ?>> getSerdes() {
        return Collections.unmodifiableMap(SERDES);
    }

    private static BeanUtilsBean setup() {
        return new BeanUtilsBean((ConvertUtilsBean)new BidirectionalConvertUtilBean(){
            {
                this.register(true, false, 0);
                this.register(TO_UUID_CONVERTER, UUID.class);
            }

            @Override
            public Converter lookup(Class<?> sourceType, Class<?> targetType) {
                if (targetType.isEnum()) {
                    return TO_ENUM_CONVERTER;
                }
                if (Map.class.isAssignableFrom(sourceType)) {
                    return FROM_MAP_CONVERTER;
                }
                return super.lookup(sourceType, targetType);
            }
        });
    }

    private static void initializeCurrentClassLoaderIfNecessary() {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        if (INITIALIZED_CLASSLOADERS.contains(currentClassLoader)) {
            return;
        }
        BeanUtilsBean.setInstance((BeanUtilsBean)BEAN_UTILS_BEAN_INSTANCE);
        CoerceUtil.markClassLoaderAsInitialized(currentClassLoader);
    }

    private static void markClassLoaderAsInitialized(ClassLoader currentClassLoader) {
        INITIALIZED_CLASSLOADERS.add(currentClassLoader);
    }
}

