/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi;

import com.google.common.collect.Sets;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidCollectionException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.pagination.PaginationImpl;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.sort.SortingImpl;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.generated.parsers.CoreBaseVisitor;
import com.yahoo.elide.generated.parsers.CoreParser;
import com.yahoo.elide.jsonapi.parser.JsonApiParser;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class EntityProjectionMaker
extends CoreBaseVisitor<Function<Type<?>, NamedEntityProjection>> {
    public static final String INCLUDE = "include";
    private EntityDictionary dictionary;
    private MultivaluedMap<String, String> queryParams;
    private Map<String, Set<String>> sparseFields;
    private RequestScope scope;

    public EntityProjectionMaker(EntityDictionary dictionary, RequestScope scope) {
        this.dictionary = dictionary;
        this.queryParams = scope.getQueryParams();
        this.sparseFields = RequestScope.parseSparseFields(this.queryParams);
        this.scope = scope;
    }

    public EntityProjection parsePath(String path) {
        return ((NamedEntityProjection)((Function)this.visit((ParseTree)JsonApiParser.parse((String)path))).apply(null)).projection;
    }

    public EntityProjection parseInclude(Type<?> entityClass) {
        return EntityProjection.builder().type(entityClass).relationships(this.toRelationshipSet(this.getIncludedRelationships(entityClass))).build();
    }

    @Override
    public Function<Type<?>, NamedEntityProjection> visitRootCollectionLoadEntities(CoreParser.RootCollectionLoadEntitiesContext ctx) {
        return this.visitTerminalCollection(ctx.term(), true);
    }

    @Override
    public Function<Type<?>, NamedEntityProjection> visitSubCollectionReadCollection(CoreParser.SubCollectionReadCollectionContext ctx) {
        return this.visitTerminalCollection(ctx.term(), false);
    }

    @Override
    public Function<Type<?>, NamedEntityProjection> visitRootCollectionSubCollection(CoreParser.RootCollectionSubCollectionContext ctx) {
        return this.visitEntityWithSubCollection(ctx.entity(), ctx.subCollection());
    }

    @Override
    public Function<Type<?>, NamedEntityProjection> visitSubCollectionSubCollection(CoreParser.SubCollectionSubCollectionContext ctx) {
        return this.visitEntityWithSubCollection(ctx.entity(), ctx.subCollection());
    }

    @Override
    public Function<Type<?>, NamedEntityProjection> visitRootCollectionRelationship(CoreParser.RootCollectionRelationshipContext ctx) {
        return this.visitEntityWithRelationship(ctx.entity(), ctx.relationship());
    }

    @Override
    public Function<Type<?>, NamedEntityProjection> visitSubCollectionRelationship(CoreParser.SubCollectionRelationshipContext ctx) {
        return this.visitEntityWithRelationship(ctx.entity(), ctx.relationship());
    }

    @Override
    public Function<Type<?>, NamedEntityProjection> visitRootCollectionLoadEntity(CoreParser.RootCollectionLoadEntityContext ctx) {
        return unused -> (NamedEntityProjection)((Function)ctx.entity().accept(this)).apply(null);
    }

    @Override
    public Function<Type<?>, NamedEntityProjection> visitSubCollectionReadEntity(CoreParser.SubCollectionReadEntityContext ctx) {
        return parentClass -> (NamedEntityProjection)((Function)ctx.entity().accept(this)).apply(parentClass);
    }

    @Override
    public Function<Type<?>, NamedEntityProjection> visitRelationship(CoreParser.RelationshipContext ctx) {
        return parentClass -> {
            String entityName = ctx.term().getText();
            Type<?> entityClass = this.getEntityClass((Type<?>)parentClass, entityName);
            FilterExpression filter = this.scope.getExpressionForRelation((Type<?>)parentClass, entityName).orElse(null);
            Sorting sorting = SortingImpl.parseQueryParams(this.scope.getQueryParams(), entityClass, this.dictionary);
            PaginationImpl pagination = PaginationImpl.parseQueryParams(entityClass, this.scope.getQueryParams(), this.scope.getElideSettings());
            return NamedEntityProjection.builder().name(entityName).projection(EntityProjection.builder().filterExpression(filter).sorting(sorting).pagination(pagination).type(entityClass).build()).build();
        };
    }

    @Override
    public Function<Type<?>, NamedEntityProjection> visitEntity(CoreParser.EntityContext ctx) {
        return parentClass -> {
            String entityName = ctx.term().getText();
            Type<?> entityClass = this.getEntityClass((Type<?>)parentClass, entityName);
            return NamedEntityProjection.builder().name(entityName).projection(EntityProjection.builder().type(entityClass).attributes(this.getSparseAttributes(entityClass)).relationships(this.toRelationshipSet(this.getRequiredRelationships(entityClass))).build()).build();
        };
    }

    protected Function<Type<?>, NamedEntityProjection> aggregateResult(Function<Type<?>, NamedEntityProjection> aggregate, Function<Type<?>, NamedEntityProjection> nextResult) {
        if (aggregate == null) {
            return nextResult;
        }
        return aggregate;
    }

    public EntityProjection visitIncludePath(Path path) {
        Path.PathElement pathElement = path.getPathElements().get(0);
        int size = path.getPathElements().size();
        Type entityClass = pathElement.getFieldType();
        if (size > 1) {
            Path nextPath = new Path(path.getPathElements().subList(1, size));
            EntityProjection relationshipProjection = this.visitIncludePath(nextPath);
            return EntityProjection.builder().relationships(this.toRelationshipSet(this.getSparseRelationships(entityClass))).relationship(nextPath.getPathElements().get(0).getFieldName(), relationshipProjection).attributes(this.getSparseAttributes(entityClass)).filterExpression(this.scope.getFilterExpressionByType(entityClass).orElse(null)).type(entityClass).build();
        }
        return EntityProjection.builder().relationships(this.toRelationshipSet(this.getSparseRelationships(entityClass))).attributes(this.getSparseAttributes(entityClass)).type(entityClass).filterExpression(this.scope.getFilterExpressionByType(entityClass).orElse(null)).build();
    }

    private Function<Type<?>, NamedEntityProjection> visitEntityWithSubCollection(CoreParser.EntityContext entity, CoreParser.SubCollectionContext subCollection) {
        return parentClass -> {
            String entityName = entity.term().getText();
            Type<?> entityClass = this.getEntityClass((Type<?>)parentClass, entityName);
            NamedEntityProjection projection = (NamedEntityProjection)((Function)subCollection.accept(this)).apply(entityClass);
            return NamedEntityProjection.builder().name(entityName).projection(EntityProjection.builder().type(entityClass).relationship(projection.name, projection.projection).build()).build();
        };
    }

    private Function<Type<?>, NamedEntityProjection> visitEntityWithRelationship(CoreParser.EntityContext entity, CoreParser.RelationshipContext relationship) {
        return parentClass -> {
            String entityName = entity.term().getText();
            Type<?> entityClass = this.getEntityClass((Type<?>)parentClass, entityName);
            String relationshipName = relationship.term().getText();
            NamedEntityProjection relationshipProjection = (NamedEntityProjection)((Function)relationship.accept(this)).apply(entityClass);
            FilterExpression filter = this.scope.getFilterExpressionByType(entityClass).orElse(null);
            return NamedEntityProjection.builder().name(entityName).projection(EntityProjection.builder().type(entityClass).filterExpression(filter).relationships(this.toRelationshipSet(this.getRequiredRelationships(entityClass))).relationship(relationshipName, relationshipProjection.projection).build()).build();
        };
    }

    private Function<Type<?>, NamedEntityProjection> visitTerminalCollection(CoreParser.TermContext collectionName, boolean isRoot) {
        return parentClass -> {
            String collectionNameText = collectionName.getText();
            Type<?> entityClass = this.getEntityClass((Type<?>)parentClass, collectionNameText);
            if (isRoot && !this.dictionary.isRoot(entityClass)) {
                throw new InvalidCollectionException(collectionNameText);
            }
            FilterExpression filter = parentClass == null ? (FilterExpression)this.scope.getLoadFilterExpression(entityClass).orElse(null) : (FilterExpression)this.scope.getExpressionForRelation((Type<?>)parentClass, collectionNameText).orElse(null);
            Sorting sorting = SortingImpl.parseQueryParams(this.scope.getQueryParams(), entityClass, this.dictionary);
            PaginationImpl pagination = PaginationImpl.parseQueryParams(entityClass, this.scope.getQueryParams(), this.scope.getElideSettings());
            return NamedEntityProjection.builder().name(collectionNameText).projection(EntityProjection.builder().filterExpression(filter).sorting(sorting).pagination(pagination).relationships(this.toRelationshipSet(this.getRequiredRelationships(entityClass))).attributes(this.getSparseAttributes(entityClass)).type(entityClass).build()).build();
        };
    }

    private Type<?> getEntityClass(Type<?> parentClass, String entityLabel) {
        if (parentClass == null) {
            Type<?> entityClass = this.dictionary.getEntityClass(entityLabel, this.scope.getApiVersion());
            if (entityClass != null) {
                return entityClass;
            }
        } else if (this.dictionary.isRelation(parentClass, entityLabel)) {
            return this.dictionary.getParameterizedType(parentClass, entityLabel);
        }
        throw new InvalidCollectionException(entityLabel);
    }

    private Map<String, EntityProjection> getIncludedRelationships(Type<?> entityClass) {
        Set<Path> includePaths = this.getIncludePaths(entityClass);
        Map<String, EntityProjection> relationships = includePaths.stream().map(path -> Pair.of((Object)path.getPathElements().get(0).getFieldName(), (Object)this.visitIncludePath((Path)path))).collect(Collectors.toMap(Pair::getKey, Pair::getValue, EntityProjection::merge));
        return relationships;
    }

    private Set<Attribute> getSparseAttributes(Type<?> entityClass) {
        LinkedHashSet<String> allAttributes = new LinkedHashSet<String>(this.dictionary.getAttributes(entityClass));
        Sets.SetView sparseFieldsForEntity = this.sparseFields.get(this.dictionary.getJsonAliasFor(entityClass));
        if (CollectionUtils.isEmpty(sparseFieldsForEntity)) {
            sparseFieldsForEntity = allAttributes;
        } else {
            LinkedHashSet<String> allRelationships = new LinkedHashSet<String>(this.dictionary.getRelationships(entityClass));
            this.validateSparseFields((Set<String>)sparseFieldsForEntity, (Set<String>)allAttributes, (Set<String>)allRelationships, entityClass);
            sparseFieldsForEntity = Sets.intersection(allAttributes, sparseFieldsForEntity);
        }
        return sparseFieldsForEntity.stream().map(attributeName -> Attribute.builder().name((String)attributeName).type(this.dictionary.getType(entityClass, (String)attributeName)).build()).collect(Collectors.toSet());
    }

    private Map<String, EntityProjection> getSparseRelationships(Type<?> entityClass) {
        LinkedHashSet<String> allRelationships = new LinkedHashSet<String>(this.dictionary.getRelationships(entityClass));
        Sets.SetView sparseFieldsForEntity = this.sparseFields.get(this.dictionary.getJsonAliasFor(entityClass));
        if (CollectionUtils.isEmpty(sparseFieldsForEntity)) {
            sparseFieldsForEntity = allRelationships;
        } else {
            LinkedHashSet<String> allAttributes = new LinkedHashSet<String>(this.dictionary.getAttributes(entityClass));
            this.validateSparseFields((Set<String>)sparseFieldsForEntity, (Set<String>)allAttributes, (Set<String>)allRelationships, entityClass);
            sparseFieldsForEntity = Sets.intersection(allRelationships, sparseFieldsForEntity);
        }
        return sparseFieldsForEntity.stream().collect(Collectors.toMap(Function.identity(), relationshipName -> {
            FilterExpression filter = this.scope.getExpressionForRelation(entityClass, (String)relationshipName).orElse(null);
            return EntityProjection.builder().type(this.dictionary.getParameterizedType(entityClass, (String)relationshipName)).filterExpression(filter).build();
        }));
    }

    private void validateSparseFields(Set<String> sparseFieldsForEntity, Set<String> allAttributes, Set<String> allRelationships, Type<?> entityClass) {
        String unknownSparseFields = sparseFieldsForEntity.stream().filter(field -> !allAttributes.contains(field) && !allRelationships.contains(field)).collect(Collectors.joining(", "));
        if (!unknownSparseFields.isEmpty()) {
            throw new InvalidValueException((Object)String.format("%s does not contain the fields: [%s]", this.dictionary.getJsonAliasFor(entityClass), unknownSparseFields));
        }
    }

    private Map<String, EntityProjection> getRequiredRelationships(Type<?> entityClass) {
        return Stream.concat(this.getIncludedRelationships(entityClass).entrySet().stream(), this.getSparseRelationships(entityClass).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, EntityProjection::merge));
    }

    private Set<Path> getIncludePaths(Type<?> entityClass) {
        if (this.queryParams.get((Object)INCLUDE) != null) {
            return ((List)this.queryParams.get((Object)INCLUDE)).stream().flatMap(param -> Arrays.stream(param.split(","))).map(pathString -> new Path(entityClass, this.dictionary, (String)pathString)).collect(Collectors.toSet());
        }
        return new LinkedHashSet<Path>();
    }

    private Set<Relationship> toRelationshipSet(Map<String, EntityProjection> relationships) {
        return relationships.entrySet().stream().map(entry -> Relationship.builder().name((String)entry.getKey()).alias((String)entry.getKey()).projection((EntityProjection)entry.getValue()).build()).collect(Collectors.toSet());
    }

    public static class NamedEntityProjection {
        private String name;
        private EntityProjection projection;

        NamedEntityProjection(String name, EntityProjection projection) {
            this.name = name;
            this.projection = projection;
        }

        public static NamedEntityProjectionBuilder builder() {
            return new NamedEntityProjectionBuilder();
        }

        public String getName() {
            return this.name;
        }

        public EntityProjection getProjection() {
            return this.projection;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setProjection(EntityProjection projection) {
            this.projection = projection;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamedEntityProjection)) {
                return false;
            }
            NamedEntityProjection other = (NamedEntityProjection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            EntityProjection this$projection = this.getProjection();
            EntityProjection other$projection = other.getProjection();
            return !(this$projection == null ? other$projection != null : !((Object)this$projection).equals(other$projection));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NamedEntityProjection;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            EntityProjection $projection = this.getProjection();
            result = result * 59 + ($projection == null ? 43 : ((Object)$projection).hashCode());
            return result;
        }

        public String toString() {
            return "EntityProjectionMaker.NamedEntityProjection(name=" + this.getName() + ", projection=" + this.getProjection() + ")";
        }

        public static class NamedEntityProjectionBuilder {
            private String name;
            private EntityProjection projection;

            NamedEntityProjectionBuilder() {
            }

            public NamedEntityProjectionBuilder name(String name) {
                this.name = name;
                return this;
            }

            public NamedEntityProjectionBuilder projection(EntityProjection projection) {
                this.projection = projection;
                return this;
            }

            public NamedEntityProjection build() {
                return new NamedEntityProjection(this.name, this.projection);
            }

            public String toString() {
                return "EntityProjectionMaker.NamedEntityProjection.NamedEntityProjectionBuilder(name=" + this.name + ", projection=" + this.projection + ")";
            }
        }
    }
}

