/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.links;

import com.google.common.collect.ImmutableMap;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.ResourceLineage;
import com.yahoo.elide.jsonapi.links.JSONApiLinks;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultJSONApiLinks
implements JSONApiLinks {
    private final String baseUrl;

    public DefaultJSONApiLinks() {
        this("");
    }

    public DefaultJSONApiLinks(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public Map<String, String> getResourceLevelLinks(PersistentResource resource) {
        return ImmutableMap.of((Object)"self", (Object)this.getResourceUrl(resource));
    }

    @Override
    public Map<String, String> getRelationshipLinks(PersistentResource resource, String field) {
        String resourceUrl = this.getResourceUrl(resource);
        return ImmutableMap.of((Object)"self", (Object)String.join((CharSequence)"/", resourceUrl, "relationships", field), (Object)"related", (Object)String.join((CharSequence)"/", resourceUrl, field));
    }

    protected String getResourceUrl(PersistentResource resource) {
        List<ResourceLineage.LineagePath> path;
        StringBuilder result = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)this.baseUrl)) {
            if (resource.getRequestScope().getBaseUrlEndPoint() != null) {
                result.append(resource.getRequestScope().getBaseUrlEndPoint());
                String jsonApiPath = resource.getRequestScope().getElideSettings().getJsonApiPath();
                if (StringUtils.isNotEmpty((CharSequence)jsonApiPath)) {
                    result.append(jsonApiPath);
                }
                result.append("/");
            }
        } else {
            result.append(this.baseUrl);
        }
        if (CollectionUtils.isNotEmpty(path = resource.getLineage().getResourcePath())) {
            result.append(String.join((CharSequence)"/", this.getPathSegment(path), resource.getId()));
        } else {
            result.append(String.join((CharSequence)"/", resource.getTypeName(), resource.getId()));
        }
        return result.toString();
    }

    private String getPathSegment(List<ResourceLineage.LineagePath> path) {
        StringBuilder result = new StringBuilder();
        int pathSegmentCount = 0;
        for (ResourceLineage.LineagePath pathElement : path) {
            PersistentResource resource = pathElement.getResource();
            if (pathSegmentCount > 0) {
                result.append("/");
                result.append(String.join((CharSequence)"/", resource.getId(), pathElement.getRelationship()));
            } else {
                result.append(String.join((CharSequence)"/", resource.getTypeName(), resource.getId(), pathElement.getRelationship()));
            }
            ++pathSegmentCount;
        }
        return result.toString();
    }
}

