/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.parser.state;

import com.fasterxml.jackson.databind.JsonNode;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.generated.parsers.CoreParser;
import com.yahoo.elide.jsonapi.document.processors.IncludedProcessor;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.parser.state.StateContext;
import java.util.function.Supplier;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BaseState {
    public void handle(StateContext state, CoreParser.RootCollectionLoadEntitiesContext ctx) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public void handle(StateContext state, CoreParser.RootCollectionLoadEntityContext ctx) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public void handle(StateContext state, CoreParser.RootCollectionSubCollectionContext ctx) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public void handle(StateContext state, CoreParser.RootCollectionRelationshipContext ctx) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public void handle(StateContext state, CoreParser.SubCollectionReadCollectionContext ctx) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public void handle(StateContext state, CoreParser.SubCollectionReadEntityContext ctx) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public void handle(StateContext state, CoreParser.SubCollectionSubCollectionContext ctx) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public void handle(StateContext state, CoreParser.SubCollectionRelationshipContext ctx) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public Supplier<Pair<Integer, JsonNode>> handleGet(StateContext state) throws HttpStatusException {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public Supplier<Pair<Integer, JsonNode>> handlePatch(StateContext state) throws HttpStatusException {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public Supplier<Pair<Integer, JsonNode>> handlePost(StateContext state) throws HttpStatusException {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public Supplier<Pair<Integer, JsonNode>> handleDelete(StateContext state) throws HttpStatusException {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    protected static Supplier<Pair<Integer, JsonNode>> constructPatchResponse(PersistentResource record, StateContext stateContext) {
        RequestScope requestScope = stateContext.getRequestScope();
        int updateStatusCode = requestScope.getUpdateStatusCode();
        return () -> Pair.of((Object)updateStatusCode, updateStatusCode == 204 ? null : BaseState.getResponseBody(record, requestScope));
    }

    protected static JsonNode getResponseBody(PersistentResource resource, RequestScope requestScope) {
        MultivaluedMap<String, String> queryParams = requestScope.getQueryParams();
        JsonApiDocument jsonApiDocument = new JsonApiDocument();
        Data<Resource> data = resource == null ? null : new Data<Resource>(resource.toResource());
        jsonApiDocument.setData(data);
        IncludedProcessor includedProcessor = new IncludedProcessor();
        includedProcessor.execute(jsonApiDocument, resource, queryParams);
        return requestScope.getMapper().toJsonObject(jsonApiDocument);
    }
}

