/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

public class ElideResponse {
    private final int responseCode;
    private final String body;

    public ElideResponse(int responseCode, String body) {
        this.responseCode = responseCode;
        this.body = body;
    }

    public static ElideResponseBuilder builder() {
        return new ElideResponseBuilder();
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getBody() {
        return this.body;
    }

    public static class ElideResponseBuilder {
        private int responseCode;
        private String body;

        ElideResponseBuilder() {
        }

        public ElideResponseBuilder responseCode(int responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public ElideResponseBuilder body(String body) {
            this.body = body;
            return this;
        }

        public ElideResponse build() {
            return new ElideResponse(this.responseCode, this.body);
        }

        public String toString() {
            return "ElideResponse.ElideResponseBuilder(responseCode=" + this.responseCode + ", body=" + this.body + ")";
        }
    }
}

