/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.core.ObjectEntityCache;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.dialect.jsonapi.MultipleFilterDialect;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.lifecycle.CRUDEvent;
import com.yahoo.elide.core.lifecycle.LifecycleHookInvoker;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.PermissionExecutor;
import com.yahoo.elide.core.security.PersistentResource;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.core.security.executors.ActivePermissionExecutor;
import com.yahoo.elide.core.security.executors.MultiplexPermissionExecutor;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.collections.MapUtils;

public class RequestScope
implements com.yahoo.elide.core.security.RequestScope {
    private final JsonApiDocument jsonApiDocument;
    private final DataStoreTransaction transaction;
    private final User user;
    protected final EntityDictionary dictionary;
    private final JsonApiMapper mapper;
    private final AuditLogger auditLogger;
    private final MultivaluedMap<String, String> queryParams;
    private final Map<String, Set<String>> sparseFields;
    private final Map<String, List<String>> requestHeaders;
    private final PermissionExecutor permissionExecutor;
    private final ObjectEntityCache objectEntityCache;
    private final Set<com.yahoo.elide.core.PersistentResource> newPersistentResources;
    private final LinkedHashSet<com.yahoo.elide.core.PersistentResource> dirtyResources;
    private final LinkedHashSet<com.yahoo.elide.core.PersistentResource> deletedResources;
    private final String baseUrlEndPoint;
    private final String path;
    private final ElideSettings elideSettings;
    private final int updateStatusCode;
    private final MultipleFilterDialect filterDialect;
    private final String apiVersion;
    private EntityProjection entityProjection;
    private final UUID requestId;
    private final Map<String, FilterExpression> expressionsByType;
    private LinkedHashSet<CRUDEvent> eventQueue;
    private FilterExpression globalFilterExpression;

    public RequestScope(String baseUrlEndPoint, String path, String apiVersion, JsonApiDocument jsonApiDocument, DataStoreTransaction transaction, User user, MultivaluedMap<String, String> queryParams, Map<String, List<String>> requestHeaders, UUID requestId, ElideSettings elideSettings) {
        block9: {
            this.apiVersion = apiVersion;
            this.eventQueue = new LinkedHashSet();
            this.path = path;
            this.baseUrlEndPoint = baseUrlEndPoint;
            this.jsonApiDocument = jsonApiDocument;
            this.transaction = transaction;
            this.user = user;
            this.dictionary = elideSettings.getDictionary();
            this.mapper = elideSettings.getMapper();
            this.auditLogger = elideSettings.getAuditLogger();
            this.filterDialect = new MultipleFilterDialect(elideSettings.getJoinFilterDialects(), elideSettings.getSubqueryFilterDialects());
            this.elideSettings = elideSettings;
            this.updateStatusCode = elideSettings.getUpdateStatusCode();
            this.globalFilterExpression = null;
            this.expressionsByType = new HashMap<String, FilterExpression>();
            this.objectEntityCache = new ObjectEntityCache();
            this.newPersistentResources = new LinkedHashSet<com.yahoo.elide.core.PersistentResource>();
            this.dirtyResources = new LinkedHashSet();
            this.deletedResources = new LinkedHashSet();
            this.requestId = requestId;
            this.queryParams = queryParams == null ? new MultivaluedHashMap() : queryParams;
            this.requestHeaders = MapUtils.isEmpty(requestHeaders) ? Collections.emptyMap() : requestHeaders;
            this.sparseFields = RequestScope.parseSparseFields(this.getQueryParams());
            if (!this.queryParams.isEmpty()) {
                MultivaluedMap<String, String> filterParams = RequestScope.getFilterParams(this.queryParams);
                Object errorMessage = "";
                if (!filterParams.isEmpty()) {
                    try {
                        this.globalFilterExpression = this.filterDialect.parseGlobalExpression(path, filterParams, apiVersion);
                    }
                    catch (ParseException e) {
                        errorMessage = e.getMessage();
                    }
                    try {
                        this.expressionsByType.putAll(this.filterDialect.parseTypedExpression(path, filterParams, apiVersion));
                    }
                    catch (ParseException e) {
                        if (this.globalFilterExpression != null) break block9;
                        if (((String)errorMessage).isEmpty()) {
                            errorMessage = e.getMessage();
                        } else if (!((String)errorMessage).equals(e.getMessage())) {
                            errorMessage = (String)errorMessage + "\n" + e.getMessage();
                        }
                        throw new BadRequestException((String)errorMessage, e);
                    }
                }
            }
        }
        Function<RequestScope, PermissionExecutor> permissionExecutorGenerator = elideSettings.getPermissionExecutor();
        this.permissionExecutor = new MultiplexPermissionExecutor(this.dictionary.buildPermissionExecutors(this), permissionExecutorGenerator == null ? new ActivePermissionExecutor(this) : permissionExecutorGenerator.apply(this), this.dictionary);
    }

    protected RequestScope(String path, String apiVersion, JsonApiDocument jsonApiDocument, RequestScope outerRequestScope) {
        this.jsonApiDocument = jsonApiDocument;
        this.baseUrlEndPoint = outerRequestScope.baseUrlEndPoint;
        this.apiVersion = apiVersion;
        this.path = path;
        this.transaction = outerRequestScope.transaction;
        this.user = outerRequestScope.user;
        this.dictionary = outerRequestScope.dictionary;
        this.mapper = outerRequestScope.mapper;
        this.auditLogger = outerRequestScope.auditLogger;
        this.queryParams = new MultivaluedHashMap();
        this.requestHeaders = new MultivaluedHashMap();
        this.requestHeaders.putAll(outerRequestScope.requestHeaders);
        this.objectEntityCache = outerRequestScope.objectEntityCache;
        this.newPersistentResources = outerRequestScope.newPersistentResources;
        this.permissionExecutor = outerRequestScope.getPermissionExecutor();
        this.dirtyResources = outerRequestScope.dirtyResources;
        this.deletedResources = outerRequestScope.deletedResources;
        this.filterDialect = outerRequestScope.filterDialect;
        this.expressionsByType = outerRequestScope.expressionsByType;
        this.elideSettings = outerRequestScope.elideSettings;
        this.eventQueue = outerRequestScope.eventQueue;
        this.updateStatusCode = outerRequestScope.updateStatusCode;
        this.requestId = outerRequestScope.requestId;
        this.sparseFields = outerRequestScope.sparseFields;
    }

    public Set<PersistentResource> getNewResources() {
        return this.newPersistentResources;
    }

    public boolean isNewResource(Object entity) {
        return this.newPersistentResources.stream().anyMatch(r -> r.getObject() == entity);
    }

    public static Map<String, Set<String>> parseSparseFields(MultivaluedMap<String, String> queryParams) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry kv : queryParams.entrySet()) {
            String key = (String)kv.getKey();
            if (!key.startsWith("fields[") || !key.endsWith("]")) continue;
            String type = key.substring(7, key.length() - 1);
            LinkedHashSet filters = new LinkedHashSet();
            for (String filterParams : (List)kv.getValue()) {
                Collections.addAll(filters, filterParams.split(","));
            }
            if (filters.isEmpty()) continue;
            result.put(type, filters);
        }
        return result;
    }

    public Optional<FilterExpression> getFilterExpressionByType(String type) {
        return Optional.ofNullable(this.expressionsByType.get(type));
    }

    public Optional<FilterExpression> getFilterExpressionByType(Type<?> entityClass) {
        return Optional.ofNullable(this.expressionsByType.get(this.dictionary.getJsonAliasFor(entityClass)));
    }

    public Optional<FilterExpression> getLoadFilterExpression(Type<?> loadClass) {
        Optional<FilterExpression> filterExpression;
        if (this.globalFilterExpression == null) {
            String typeName = this.dictionary.getJsonAliasFor(loadClass);
            filterExpression = this.getFilterExpressionByType(typeName);
        } else {
            filterExpression = Optional.of(this.globalFilterExpression);
        }
        return filterExpression;
    }

    public Optional<FilterExpression> getExpressionForRelation(Type<?> parentType, String relationName) {
        Type<?> entityClass = this.dictionary.getParameterizedType(parentType, relationName);
        if (entityClass == null) {
            throw new InvalidAttributeException(relationName, this.dictionary.getJsonAliasFor(parentType));
        }
        String valType = this.dictionary.getJsonAliasFor(entityClass);
        return this.getFilterExpressionByType(valType);
    }

    private static MultivaluedMap<String, String> getFilterParams(MultivaluedMap<String, String> queryParams) {
        MultivaluedHashMap returnMap = new MultivaluedHashMap();
        queryParams.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("filter")).forEach(arg_0 -> RequestScope.lambda$getFilterParams$2((MultivaluedMap)returnMap, arg_0));
        return returnMap;
    }

    private void notifySubscribers(LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase) {
        LifecycleHookInvoker invoker = new LifecycleHookInvoker(this.dictionary, operation, phase);
        this.eventQueue.stream().filter(event -> event.getEventType().equals((Object)operation)).forEach(event -> invoker.onNext((CRUDEvent)event));
    }

    public void runQueuedPreSecurityTriggers() {
        this.notifySubscribers(LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.PRESECURITY);
    }

    public void runQueuedPreFlushTriggers() {
        this.runQueuedPreFlushTriggers(LifeCycleHookBinding.ALL_OPERATIONS);
    }

    public void runQueuedPreFlushTriggers(LifeCycleHookBinding.Operation[] operations) {
        for (LifeCycleHookBinding.Operation op : operations) {
            this.notifySubscribers(op, LifeCycleHookBinding.TransactionPhase.PREFLUSH);
        }
    }

    public void runQueuedPreCommitTriggers() {
        for (LifeCycleHookBinding.Operation op : LifeCycleHookBinding.ALL_OPERATIONS) {
            this.notifySubscribers(op, LifeCycleHookBinding.TransactionPhase.PRECOMMIT);
        }
    }

    public void runQueuedPostCommitTriggers() {
        for (LifeCycleHookBinding.Operation op : LifeCycleHookBinding.ALL_OPERATIONS) {
            this.notifySubscribers(op, LifeCycleHookBinding.TransactionPhase.POSTCOMMIT);
        }
    }

    protected void publishLifecycleEvent(com.yahoo.elide.core.PersistentResource<?> resource, LifeCycleHookBinding.Operation crudAction) {
        this.publishLifecycleEvent(new CRUDEvent(crudAction, resource, "", Optional.empty()));
    }

    protected void publishLifecycleEvent(com.yahoo.elide.core.PersistentResource<?> resource, String fieldName, LifeCycleHookBinding.Operation crudAction, Optional<ChangeSpec> changeSpec) {
        this.publishLifecycleEvent(new CRUDEvent(crudAction, resource, fieldName, changeSpec));
    }

    protected void publishLifecycleEvent(CRUDEvent event) {
        if (!this.eventQueue.contains(event)) {
            if (event.getEventType().equals((Object)LifeCycleHookBinding.Operation.DELETE) || event.getEventType().equals((Object)LifeCycleHookBinding.Operation.UPDATE)) {
                LifecycleHookInvoker invoker = new LifecycleHookInvoker(this.dictionary, event.getEventType(), LifeCycleHookBinding.TransactionPhase.PRESECURITY);
                invoker.onNext(event);
            }
            this.eventQueue.add(event);
        }
    }

    public void saveOrCreateObjects() {
        this.dirtyResources.removeAll(this.newPersistentResources);
        this.dirtyResources.removeAll(this.deletedResources);
        this.newPersistentResources.stream().map(com.yahoo.elide.core.PersistentResource::getObject).forEach(s -> this.transaction.createObject(s, this));
        this.dirtyResources.stream().map(com.yahoo.elide.core.PersistentResource::getObject).forEach(obj -> this.transaction.save(obj, this));
    }

    public String getUUIDFor(Object o) {
        return this.objectEntityCache.getUUID(o);
    }

    public Object getObjectById(Type<?> type, String id) {
        Type<?> boundType = this.dictionary.lookupBoundClass(type);
        Object result = this.objectEntityCache.get(boundType.getName(), id);
        Iterator<Type<?>> it = this.dictionary.getSubclassingEntities(boundType).iterator();
        while (result == null && it.hasNext()) {
            String newType = this.getInheritanceKey(it.next().getName(), boundType.getName());
            result = this.objectEntityCache.get(newType, id);
        }
        return result;
    }

    public void setUUIDForObject(Type<?> type, String id, Object object) {
        Type<?> boundType = this.dictionary.lookupBoundClass(type);
        this.objectEntityCache.put(boundType.getName(), id, object);
        this.dictionary.getSuperClassEntities(type).stream().map(i -> this.getInheritanceKey(boundType.getName(), i.getName())).forEach(newType -> this.objectEntityCache.put((String)newType, id, object));
    }

    private String getInheritanceKey(String subClass, String superClass) {
        return subClass + "!" + superClass;
    }

    @Override
    public String getRequestHeaderByName(String headerName) {
        if (this.requestHeaders.get(headerName) == null) {
            return null;
        }
        return this.requestHeaders.get(headerName).get(0);
    }

    public JsonApiDocument getJsonApiDocument() {
        return this.jsonApiDocument;
    }

    @Override
    public DataStoreTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    public JsonApiMapper getMapper() {
        return this.mapper;
    }

    public AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    public MultivaluedMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, Set<String>> getSparseFields() {
        return this.sparseFields;
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public PermissionExecutor getPermissionExecutor() {
        return this.permissionExecutor;
    }

    public ObjectEntityCache getObjectEntityCache() {
        return this.objectEntityCache;
    }

    public Set<com.yahoo.elide.core.PersistentResource> getNewPersistentResources() {
        return this.newPersistentResources;
    }

    public LinkedHashSet<com.yahoo.elide.core.PersistentResource> getDirtyResources() {
        return this.dirtyResources;
    }

    public LinkedHashSet<com.yahoo.elide.core.PersistentResource> getDeletedResources() {
        return this.deletedResources;
    }

    @Override
    public String getBaseUrlEndPoint() {
        return this.baseUrlEndPoint;
    }

    public String getPath() {
        return this.path;
    }

    public ElideSettings getElideSettings() {
        return this.elideSettings;
    }

    public int getUpdateStatusCode() {
        return this.updateStatusCode;
    }

    public MultipleFilterDialect getFilterDialect() {
        return this.filterDialect;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public EntityProjection getEntityProjection() {
        return this.entityProjection;
    }

    public void setEntityProjection(EntityProjection entityProjection) {
        this.entityProjection = entityProjection;
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    private static /* synthetic */ void lambda$getFilterParams$2(MultivaluedMap returnMap, Map.Entry entry) {
        returnMap.put((Object)((String)entry.getKey()), (Object)((List)entry.getValue()));
    }
}

