/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.expression;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import java.util.function.Predicate;

public class InMemoryFilterExecutor
implements FilterExpressionVisitor<Predicate> {
    private final RequestScope requestScope;

    public InMemoryFilterExecutor(RequestScope requestScope) {
        this.requestScope = requestScope;
    }

    @Override
    public Predicate visitPredicate(FilterPredicate filterPredicate) {
        return filterPredicate.apply(this.requestScope);
    }

    @Override
    public Predicate visitAndExpression(AndFilterExpression expression) {
        Predicate leftPredicate = expression.getLeft().accept(this);
        Predicate rightPredicate = expression.getRight().accept(this);
        return t -> leftPredicate.and(rightPredicate).test(t);
    }

    @Override
    public Predicate visitOrExpression(OrFilterExpression expression) {
        Predicate leftPredicate = expression.getLeft().accept(this);
        Predicate rightPredicate = expression.getRight().accept(this);
        return t -> leftPredicate.or(rightPredicate).test(t);
    }

    @Override
    public Predicate visitNotExpression(NotFilterExpression expression) {
        Predicate predicate = expression.getNegated().accept(this);
        return t -> predicate.negate().test(t);
    }
}

