/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.permissions;

import com.google.common.collect.ImmutableMap;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.NonTransferable;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.PersistentResource;
import com.yahoo.elide.core.type.Type;
import java.lang.annotation.Annotation;
import java.util.Optional;

public class PermissionCondition {
    final Class<? extends Annotation> permission;
    final Type<?> entityClass;
    final Optional<PersistentResource> resource;
    final Optional<ChangeSpec> changes;
    final Optional<String> field;
    private static final ImmutableMap<Class<? extends Annotation>, String> PERMISSION_TO_NAME = ImmutableMap.of(ReadPermission.class, (Object)"READ", UpdatePermission.class, (Object)"UPDATE", DeletePermission.class, (Object)"DELETE", CreatePermission.class, (Object)"CREATE", NonTransferable.class, (Object)"NO TRANSFER");

    public static PermissionCondition create(Class<? extends Annotation> permission, PersistentResource resource, String field, ChangeSpec changes) {
        if (resource != null) {
            if (changes != null) {
                if (field != null && changes.getFieldName() == null) {
                    return new PermissionCondition(permission, resource, field);
                }
                return new PermissionCondition(permission, resource, changes);
            }
            if (field == null) {
                return new PermissionCondition(permission, resource);
            }
            return new PermissionCondition(permission, resource, field);
        }
        throw new IllegalArgumentException("Resource cannot be null");
    }

    PermissionCondition(Class<? extends Annotation> permission, PersistentResource resource) {
        this.permission = permission;
        this.resource = Optional.of(resource);
        this.entityClass = resource.getResourceType();
        this.changes = Optional.empty();
        this.field = Optional.empty();
    }

    PermissionCondition(Class<? extends Annotation> permission, PersistentResource resource, ChangeSpec changes) {
        this.permission = permission;
        this.resource = Optional.of(resource);
        this.entityClass = resource.getResourceType();
        this.changes = Optional.of(changes);
        this.field = Optional.ofNullable(changes.getFieldName());
    }

    PermissionCondition(Class<? extends Annotation> permission, Type<?> entityClass) {
        this.permission = permission;
        this.resource = Optional.empty();
        this.entityClass = entityClass;
        this.changes = Optional.empty();
        this.field = Optional.empty();
    }

    PermissionCondition(Class<? extends Annotation> permission, Type<?> entityClass, String field) {
        this.permission = permission;
        this.resource = Optional.empty();
        this.entityClass = entityClass;
        this.changes = Optional.empty();
        this.field = Optional.of(field);
    }

    PermissionCondition(Class<? extends Annotation> permission, PersistentResource resource, String field) {
        this.permission = permission;
        this.resource = Optional.of(resource);
        this.entityClass = resource.getResourceType();
        this.changes = Optional.empty();
        this.field = Optional.of(field);
    }

    public String toString() {
        Type<?> entity = this.resource.orElse((PersistentResource)((Object)this.entityClass));
        String withClause = this.changes.map(c -> String.format("WITH CHANGES %s", c)).orElseGet(() -> this.field.map(f -> String.format("WITH FIELD %s", f)).orElse(""));
        return String.format("%s PERMISSION WAS INVOKED ON %s %s", PERMISSION_TO_NAME.get(this.permission), entity, withClause);
    }

    public Class<? extends Annotation> getPermission() {
        return this.permission;
    }

    public Type<?> getEntityClass() {
        return this.entityClass;
    }

    public Optional<PersistentResource> getResource() {
        return this.resource;
    }

    public Optional<ChangeSpec> getChanges() {
        return this.changes;
    }

    public Optional<String> getField() {
        return this.field;
    }
}

