/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.permissions.expressions;

import com.yahoo.elide.core.security.permissions.ExpressionResult;
import com.yahoo.elide.core.security.permissions.expressions.ExpressionVisitor;
import org.fusesource.jansi.Ansi;

public interface Expression {
    public ExpressionResult evaluate(EvaluationMode var1);

    public <T> T accept(ExpressionVisitor<T> var1);

    public static class Results {
        public static final Expression SUCCESS = new Expression(){

            @Override
            public ExpressionResult evaluate(EvaluationMode ignored) {
                return ExpressionResult.PASS;
            }

            @Override
            public <T> T accept(ExpressionVisitor<T> visitor) {
                return visitor.visitExpression(this);
            }

            public String toString() {
                return Ansi.ansi().fg(Ansi.Color.GREEN).a("SUCCESS").reset().toString();
            }
        };
        public static final Expression FAILURE = new Expression(){

            @Override
            public ExpressionResult evaluate(EvaluationMode ignored) {
                return ExpressionResult.FAIL;
            }

            @Override
            public <T> T accept(ExpressionVisitor<T> visitor) {
                return visitor.visitExpression(this);
            }

            public String toString() {
                return Ansi.ansi().fg(Ansi.Color.RED).a("FAILURE").reset().toString();
            }
        };
    }

    public static enum EvaluationMode {
        USER_CHECKS_ONLY,
        INLINE_CHECKS_ONLY,
        ALL_CHECKS;

    }
}

