/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.type;

import com.google.common.collect.ImmutableList;
import com.yahoo.elide.core.type.Field;
import com.yahoo.elide.core.type.FieldType;
import com.yahoo.elide.core.type.Method;
import com.yahoo.elide.core.type.MethodType;
import com.yahoo.elide.core.type.Package;
import com.yahoo.elide.core.type.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ClassType<T>
implements Type<T> {
    public static final List<Method> OBJ_METHODS = ImmutableList.copyOf((Collection)Arrays.stream(Object.class.getMethods()).map(ClassType::constructMethod).collect(Collectors.toList()));
    public static final ClassType<Map> MAP_TYPE = ClassType.of(Map.class);
    public static final ClassType<Collection> COLLECTION_TYPE = ClassType.of(Collection.class);
    public static final ClassType<String> STRING_TYPE = ClassType.of(String.class);
    public static final ClassType<Boolean> BOOLEAN_TYPE = ClassType.of(Boolean.class);
    public static final ClassType<Long> LONG_TYPE = ClassType.of(Long.class);
    public static final ClassType<BigDecimal> BIGDECIMAL_TYPE = ClassType.of(BigDecimal.class);
    public static final ClassType<Number> NUMBER_TYPE = ClassType.of(Number.class);
    public static final ClassType<Date> DATE_TYPE = ClassType.of(Date.class);
    public static final ClassType<Object> OBJECT_TYPE = ClassType.of(Object.class);
    public static final ClassType<Class> CLASS_TYPE = ClassType.of(Class.class);
    public static final ClassType<Integer> INTEGER_TYPE = ClassType.of(Integer.class);
    private Class<T> cls;

    public ClassType(Class<T> cls) {
        this.cls = cls;
    }

    @Override
    public String getCanonicalName() {
        return this.cls.getCanonicalName();
    }

    @Override
    public String getSimpleName() {
        return this.cls.getSimpleName();
    }

    @Override
    public String getName() {
        return this.cls.getName();
    }

    @Override
    public Type<T> getSuperclass() {
        Class<T> superClass = this.cls.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return new ClassType<T>(superClass);
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        return this.cls.getAnnotationsByType(annotationClass);
    }

    @Override
    public Field[] getFields() {
        return (Field[])Arrays.stream(this.cls.getFields()).map(ClassType::constructField).toArray(Field[]::new);
    }

    @Override
    public Field[] getDeclaredFields() {
        return (Field[])Arrays.stream(this.cls.getDeclaredFields()).map(ClassType::constructField).toArray(Field[]::new);
    }

    @Override
    public Field getDeclaredField(String name) throws NoSuchFieldException {
        return ClassType.constructField(this.cls.getDeclaredField(name));
    }

    @Override
    public Method[] getConstructors() {
        return (Method[])Arrays.stream(this.cls.getConstructors()).map(ClassType::constructMethod).toArray(Method[]::new);
    }

    @Override
    public boolean isParameterized() {
        return this.cls.getGenericSuperclass() instanceof ParameterizedType;
    }

    @Override
    public boolean hasSuperType() {
        return this.cls != null && this.cls != Object.class;
    }

    @Override
    public T newInstance() throws InstantiationException, IllegalAccessException {
        return this.cls.newInstance();
    }

    @Override
    public Package getPackage() {
        return ClassType.constructPackage(this.cls.getPackage());
    }

    @Override
    public Method[] getMethods() {
        return (Method[])Arrays.stream(this.cls.getMethods()).map(ClassType::constructMethod).toArray(Method[]::new);
    }

    @Override
    public Method[] getDeclaredMethods() {
        return (Method[])Arrays.stream(this.cls.getDeclaredMethods()).map(ClassType::constructMethod).toArray(Method[]::new);
    }

    @Override
    public boolean isAssignableFrom(Type other) {
        Optional<Class<Class>> clazz = other.getUnderlyingClass();
        return clazz.filter(this.cls::isAssignableFrom).isPresent();
    }

    @Override
    public boolean isPrimitive() {
        return this.cls.isPrimitive();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.cls.getAnnotation(annotationClass);
    }

    @Override
    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        return this.cls.getDeclaredAnnotation(annotationClass);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    public Method getMethod(String name, Type<?> ... parameterTypes) throws NoSuchMethodException {
        Class[] typeParams = (Class[])Arrays.stream(parameterTypes).map(ClassType.class::cast).map(classType -> classType == null ? null : classType.getCls()).toArray(Class[]::new);
        return ClassType.constructMethod(this.cls.getMethod(name, typeParams));
    }

    private static Field constructField(java.lang.reflect.Field field) {
        if (field == null) {
            return null;
        }
        return new FieldType(field);
    }

    private static Method constructMethod(Executable method) {
        if (method == null) {
            return null;
        }
        return new MethodType(method);
    }

    private static Package constructPackage(final java.lang.Package pkg) {
        if (pkg == null) {
            return null;
        }
        return new Package(){

            @Override
            public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
                return pkg.getDeclaredAnnotation(annotationClass);
            }

            @Override
            public String getName() {
                return pkg.getName();
            }

            @Override
            public Package getParentPackage() {
                String name = pkg.getName();
                int idx = name.lastIndexOf(46);
                return idx == -1 ? null : ClassType.constructPackage(java.lang.Package.getPackage(name.substring(0, idx)));
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassType classType = (ClassType)o;
        return Objects.equals(this.cls, classType.cls);
    }

    public int hashCode() {
        return Objects.hashCode(this.cls);
    }

    public String toString() {
        return "ClassType{cls=" + this.cls + "}";
    }

    @Override
    public boolean isEnum() {
        return this.cls.isEnum();
    }

    @Override
    public T[] getEnumConstants() {
        return this.cls.getEnumConstants();
    }

    @Override
    public Optional<Class<T>> getUnderlyingClass() {
        return Optional.of(this.getCls());
    }

    public static <T> ClassType<T> of(Class<T> cls) {
        return cls == null ? null : new ClassType<T>(cls);
    }

    public Class<T> getCls() {
        return this.cls;
    }
}

