/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.type;

import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.core.exceptions.InvalidParameterizedAttributeException;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.type.ParameterizedAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class ParameterizedModel {
    @Exclude
    protected Map<Attribute, ParameterizedAttribute> parameterizedAttributes;

    public ParameterizedModel() {
        this(new HashMap<Attribute, ParameterizedAttribute>());
    }

    public ParameterizedModel(Map<Attribute, ParameterizedAttribute> attributes) {
        this.parameterizedAttributes = attributes;
    }

    public <T> void addAttributeValue(Attribute attribute, final T value) {
        this.parameterizedAttributes.put(attribute, new ParameterizedAttribute(){

            @Override
            public <T> T invoke(Set<Argument> arguments) {
                return (T)value;
            }
        });
    }

    public <T> T invoke(Attribute attribute) {
        return this.parameterizedAttributes.entrySet().stream().filter(entry -> attribute.getAlias().equals(((Attribute)entry.getKey()).getAlias())).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new InvalidParameterizedAttributeException(attribute)).invoke(attribute.getArguments());
    }

    public <T> T fetch(String alias, T defaultValue) {
        Optional<ParameterizedAttribute> match = this.parameterizedAttributes.entrySet().stream().filter(entry -> alias.equals(((Attribute)entry.getKey()).getAlias())).findFirst().map(Map.Entry::getValue);
        if (!match.isPresent()) {
            return defaultValue;
        }
        return match.get().invoke(new HashSet<Argument>());
    }
}

