/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.utils;

import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.SecurityCheck;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultClassScanner
implements ClassScanner {
    private static final String[] CACHE_ANNOTATIONS = new String[]{Include.class.getCanonicalName(), SecurityCheck.class.getCanonicalName(), ElideTypeConverter.class.getCanonicalName(), "com.yahoo.elide.graphql.subscriptions.annotations.Subscription", "com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromTable", "com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromSubquery", "org.hibernate.annotations.Subselect", "javax.persistence.Entity", "javax.persistence.Table"};
    private final Map<String, Set<Class<?>>> startupCache;
    private static DefaultClassScanner _instance;

    public DefaultClassScanner(Map<String, Set<Class<?>>> startupCache) {
        this.startupCache = startupCache;
    }

    public DefaultClassScanner() {
        this.startupCache = new HashMap();
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableAnnotationInfo().scan();){
            for (String annotationName : CACHE_ANNOTATIONS) {
                this.startupCache.put(annotationName, scanResult.getClassesWithAnnotation(annotationName).stream().map(ClassInfo::loadClass).collect(Collectors.toSet()));
            }
        }
    }

    @Override
    public Set<Class<?>> getAnnotatedClasses(Package toScan, Class<? extends Annotation> annotation) {
        return this.getAnnotatedClasses(toScan.getName(), annotation);
    }

    @Override
    public Set<Class<?>> getAnnotatedClasses(String packageName, Class<? extends Annotation> annotation) {
        return this.startupCache.get(annotation.getCanonicalName()).stream().filter(clazz -> clazz.getPackage().getName().equals(packageName) || clazz.getPackage().getName().startsWith(packageName + ".")).collect(Collectors.toSet());
    }

    @Override
    public Set<Class<?>> getAnnotatedClasses(List<Class<? extends Annotation>> annotations, ClassScanner.FilterExpression filter) {
        HashSet result = new HashSet();
        for (Class<? extends Annotation> annotation : annotations) {
            result.addAll(this.startupCache.get(annotation.getCanonicalName()).stream().filter(filter::include).collect(Collectors.toSet()));
        }
        return result;
    }

    @Override
    public Set<Class<?>> getAnnotatedClasses(List<Class<? extends Annotation>> annotations) {
        return this.getAnnotatedClasses(annotations, (Class clazz) -> true);
    }

    @Override
    public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> ... annotations) {
        return this.getAnnotatedClasses(Arrays.asList(annotations));
    }

    @Override
    public Set<Class<?>> getAllClasses(String packageName) {
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().whitelistPackages(new String[]{packageName}).scan();){
            Set<Class<?>> set = scanResult.getAllClasses().stream().map(ClassInfo::loadClass).collect(Collectors.toSet());
            return set;
        }
    }

    public static synchronized DefaultClassScanner getInstance() {
        if (_instance == null) {
            _instance = new DefaultClassScanner();
        }
        return _instance;
    }
}

