/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.utils;

import com.google.common.collect.Sets;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Dynamic;
import com.yahoo.elide.core.type.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TypeHelper {
    private static final String UNDERSCORE = "_";
    private static final String PERIOD = ".";
    private static final Set<Class<?>> PRIMITIVE_NUMBER_TYPES = Sets.newHashSet((Object[])new Class[]{Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
    private static final Set<Class<?>> NUMBER_TYPES = Sets.newHashSet((Object[])new Class[]{Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Short.class, Integer.class, Long.class, Float.class, Double.class});

    public static boolean isPrimitiveNumberType(Type<?> type) {
        if (type instanceof Dynamic) {
            return false;
        }
        return PRIMITIVE_NUMBER_TYPES.contains(((ClassType)type).getCls());
    }

    public static boolean isNumberType(Class<?> type) {
        return NUMBER_TYPES.contains(type);
    }

    public static String extendTypeAlias(String alias, Path extension, EntityDictionary dictionary) {
        Object result = alias;
        List<Path.PathElement> elements = extension.getPathElements();
        for (int i = 0; i < elements.size() - 1; ++i) {
            Path.PathElement next = elements.get(i);
            result = dictionary.isComplexAttribute(next.getType(), next.getFieldName()) ? (String)result + PERIOD + next.getFieldName() : TypeHelper.appendAlias((String)result, elements.get(i).getFieldName());
        }
        return result;
    }

    public static String getPathAlias(Path path, EntityDictionary dictionary) {
        return TypeHelper.extendTypeAlias(TypeHelper.getTypeAlias(path.getPathElements().get(0).getType()), path, dictionary);
    }

    public static String appendAlias(String parentAlias, String fieldName) {
        return StringUtils.isEmpty((CharSequence)parentAlias) ? fieldName : (StringUtils.isEmpty((CharSequence)fieldName) ? parentAlias : parentAlias + UNDERSCORE + fieldName);
    }

    public static String getTypeAlias(Type<?> type) {
        return type.getCanonicalName().replace(PERIOD, UNDERSCORE);
    }

    public static String getFieldAlias(Path path, String fieldName, EntityDictionary dictionary) {
        return TypeHelper.getFieldAlias(TypeHelper.getPathAlias(path, dictionary), fieldName);
    }

    public static String getFieldAlias(String tableAlias, String fieldName) {
        return StringUtils.isEmpty((CharSequence)tableAlias) ? fieldName : tableAlias + PERIOD + fieldName;
    }

    public static Set<Type<?>> getClassType(Set<Class<?>> cls) {
        return cls.stream().map(ClassType::of).collect(Collectors.toSet());
    }
}

