/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.utils.coerce.converters;

import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.ClassUtils;

public class EpochToDateConverter<T extends Date>
implements Converter,
Serde<Object, T> {
    private Class<T> targetType;

    public EpochToDateConverter(Class<T> targetType) {
        this.targetType = targetType;
    }

    public <T> T convert(Class<T> cls, Object value) {
        try {
            if (ClassUtils.isAssignable(value.getClass(), String.class)) {
                return EpochToDateConverter.stringToDate(cls, (String)value);
            }
            if (ClassUtils.isAssignable(value.getClass(), Number.class, (boolean)true)) {
                return EpochToDateConverter.numberToDate(cls, (Number)value);
            }
            throw new UnsupportedOperationException(value.getClass().getSimpleName() + " is not a valid epoch");
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | ReflectiveOperationException | UnsupportedOperationException e) {
            throw new InvalidAttributeException("Unknown " + cls.getSimpleName() + " value " + value, e);
        }
    }

    @Override
    public T deserialize(Object val) {
        return (T)((Date)this.convert(this.targetType, val));
    }

    @Override
    public Object serialize(T val) {
        return ((Date)val).getTime();
    }

    private static <T> T numberToDate(Class<T> cls, Number epoch) throws ReflectiveOperationException {
        if (ClassUtils.isAssignable(cls, java.sql.Date.class)) {
            return cls.cast(new java.sql.Date(epoch.longValue()));
        }
        if (ClassUtils.isAssignable(cls, Timestamp.class)) {
            return cls.cast(new Timestamp(epoch.longValue()));
        }
        if (ClassUtils.isAssignable(cls, Time.class)) {
            return cls.cast(new Time(epoch.longValue()));
        }
        if (ClassUtils.isAssignable(cls, Date.class)) {
            return cls.cast(new Date(epoch.longValue()));
        }
        throw new UnsupportedOperationException("Cannot convert to " + cls.getSimpleName());
    }

    private static <T> T stringToDate(Class<T> cls, String epoch) throws ReflectiveOperationException {
        return EpochToDateConverter.numberToDate(cls, Long.parseLong(epoch));
    }
}

