/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.parser.state;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.generated.parsers.CoreParser;
import com.yahoo.elide.jsonapi.parser.state.BaseState;
import com.yahoo.elide.jsonapi.parser.state.CollectionTerminalState;
import com.yahoo.elide.jsonapi.parser.state.RecordTerminalState;
import com.yahoo.elide.jsonapi.parser.state.RelationshipTerminalState;
import com.yahoo.elide.jsonapi.parser.state.StateContext;
import io.reactivex.Observable;
import java.util.Optional;

public class RecordState
extends BaseState {
    private final PersistentResource resource;
    private final EntityProjection projection;

    public RecordState(PersistentResource resource, EntityProjection projection) {
        Preconditions.checkNotNull((Object)resource);
        this.resource = resource;
        this.projection = projection;
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionReadCollectionContext ctx) {
        BaseState nextState;
        String subCollection = ctx.term().getText();
        EntityDictionary dictionary = state.getRequestScope().getDictionary();
        RelationshipType type = dictionary.getRelationshipType(this.resource.getObject(), subCollection);
        Type<?> paramType = dictionary.getParameterizedType(this.resource.getObject(), subCollection);
        String entityName = dictionary.getJsonAliasFor(paramType);
        Type<?> entityClass = dictionary.getEntityClass(entityName, state.getRequestScope().getApiVersion());
        if (entityClass == null) {
            throw new IllegalArgumentException("Unknown type " + entityName);
        }
        CollectionTerminalState collectionTerminalState = new CollectionTerminalState(entityClass, Optional.of(this.resource), Optional.of(subCollection), this.projection);
        Observable<PersistentResource> collection = null;
        if (type.isToOne()) {
            collection = this.resource.getRelationCheckedFiltered(this.projection.getRelationship(subCollection).orElseThrow(IllegalStateException::new));
            PersistentResource record = PersistentResource.firstOrNullIfEmpty(collection);
            nextState = new RecordTerminalState(record, collectionTerminalState);
        } else {
            nextState = collectionTerminalState;
        }
        state.setState(nextState);
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionReadEntityContext ctx) {
        String id = ctx.entity().id().getText();
        String subCollection = ctx.entity().term().getText();
        PersistentResource nextRecord = this.resource.getRelation(this.projection.getRelationship(subCollection).orElseThrow(IllegalStateException::new), id);
        state.setState(new RecordTerminalState(nextRecord));
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionSubCollectionContext ctx) {
        String id = ctx.entity().id().getText();
        String subCollection = ctx.entity().term().getText();
        Relationship relationship = this.projection.getRelationship(subCollection).orElseThrow(IllegalStateException::new);
        state.setState(new RecordState(this.resource.getRelation(relationship, id), relationship.getProjection()));
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionRelationshipContext ctx) {
        String id = ctx.entity().id().getText();
        String subCollection = ctx.entity().term().getText();
        String relationName = ctx.relationship().term().getText();
        Relationship childRelationship = this.projection.getRelationship(subCollection).orElseThrow(IllegalStateException::new);
        PersistentResource childRecord = this.resource.getRelation(childRelationship, id);
        state.setState(new RelationshipTerminalState(childRecord, relationName, childRelationship.getProjection()));
    }
}

