/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.parser.state;

import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidCollectionException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.generated.parsers.CoreParser;
import com.yahoo.elide.jsonapi.parser.state.BaseState;
import com.yahoo.elide.jsonapi.parser.state.CollectionTerminalState;
import com.yahoo.elide.jsonapi.parser.state.RecordState;
import com.yahoo.elide.jsonapi.parser.state.RecordTerminalState;
import com.yahoo.elide.jsonapi.parser.state.RelationshipTerminalState;
import com.yahoo.elide.jsonapi.parser.state.StateContext;
import java.util.Optional;

public class StartState
extends BaseState {
    @Override
    public void handle(StateContext state, CoreParser.RootCollectionLoadEntitiesContext ctx) {
        String entityName = ctx.term().getText();
        EntityDictionary dictionary = state.getRequestScope().getDictionary();
        Type<?> entityClass = dictionary.getEntityClass(entityName, state.getRequestScope().getApiVersion());
        state.setState(new CollectionTerminalState(entityClass, Optional.empty(), Optional.empty(), state.getRequestScope().getEntityProjection()));
    }

    @Override
    public void handle(StateContext state, CoreParser.RootCollectionLoadEntityContext ctx) {
        PersistentResource<?> record = this.entityRecord(state, ctx.entity());
        state.setState(new RecordTerminalState(record));
    }

    @Override
    public void handle(StateContext state, CoreParser.RootCollectionSubCollectionContext ctx) {
        PersistentResource<?> record = this.entityRecord(state, ctx.entity());
        state.setState(new RecordState(record, state.getRequestScope().getEntityProjection()));
    }

    @Override
    public void handle(StateContext state, CoreParser.RootCollectionRelationshipContext ctx) {
        PersistentResource<?> record = this.entityRecord(state, ctx.entity());
        EntityProjection projection = state.getRequestScope().getEntityProjection();
        String relationName = ctx.relationship().term().getText();
        record.getRelationCheckedFiltered(projection.getRelationship(relationName).orElseThrow(IllegalStateException::new));
        state.setState(new RelationshipTerminalState(record, relationName, projection));
    }

    public String toString() {
        return this.getClass().getName();
    }

    private PersistentResource<?> entityRecord(StateContext state, CoreParser.EntityContext entity) {
        String id = entity.id().getText();
        String entityName = entity.term().getText();
        EntityDictionary dictionary = state.getRequestScope().getDictionary();
        Type<?> entityClass = dictionary.getEntityClass(entityName, state.getRequestScope().getApiVersion());
        if (entityClass == null || !dictionary.isRoot(entityClass)) {
            throw new InvalidCollectionException(entityName);
        }
        return PersistentResource.loadRecord(state.getRequestScope().getEntityProjection(), id, state.getRequestScope());
    }
}

