/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.ErrorMapper;
import com.yahoo.elide.core.filter.dialect.graphql.FilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.SubqueryFilterDialect;
import com.yahoo.elide.core.security.PermissionExecutor;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.links.JSONApiLinks;
import com.yahoo.elide.utils.HeaderUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ElideSettings {
    private final AuditLogger auditLogger;
    private final DataStore dataStore;
    private final EntityDictionary dictionary;
    private final JsonApiMapper mapper;
    private final ErrorMapper errorMapper;
    private final Function<RequestScope, PermissionExecutor> permissionExecutor;
    private final List<JoinFilterDialect> joinFilterDialects;
    private final List<SubqueryFilterDialect> subqueryFilterDialects;
    private final FilterDialect graphqlDialect;
    private final JSONApiLinks jsonApiLinks;
    private final HeaderUtils.HeaderProcessor headerProcessor;
    private final int defaultMaxPageSize;
    private final int defaultPageSize;
    private final int updateStatusCode;
    private final Map<Class, Serde> serdes;
    private final boolean enableJsonLinks;
    private final boolean strictQueryParams;
    private final boolean enableGraphQLFederation;
    private final String baseUrl;
    private final String jsonApiPath;
    private final String graphQLApiPath;
    private final String exportApiPath;

    public ElideSettings(AuditLogger auditLogger, DataStore dataStore, EntityDictionary dictionary, JsonApiMapper mapper, ErrorMapper errorMapper, Function<RequestScope, PermissionExecutor> permissionExecutor, List<JoinFilterDialect> joinFilterDialects, List<SubqueryFilterDialect> subqueryFilterDialects, FilterDialect graphqlDialect, JSONApiLinks jsonApiLinks, HeaderUtils.HeaderProcessor headerProcessor, int defaultMaxPageSize, int defaultPageSize, int updateStatusCode, Map<Class, Serde> serdes, boolean enableJsonLinks, boolean strictQueryParams, boolean enableGraphQLFederation, String baseUrl, String jsonApiPath, String graphQLApiPath, String exportApiPath) {
        this.auditLogger = auditLogger;
        this.dataStore = dataStore;
        this.dictionary = dictionary;
        this.mapper = mapper;
        this.errorMapper = errorMapper;
        this.permissionExecutor = permissionExecutor;
        this.joinFilterDialects = joinFilterDialects;
        this.subqueryFilterDialects = subqueryFilterDialects;
        this.graphqlDialect = graphqlDialect;
        this.jsonApiLinks = jsonApiLinks;
        this.headerProcessor = headerProcessor;
        this.defaultMaxPageSize = defaultMaxPageSize;
        this.defaultPageSize = defaultPageSize;
        this.updateStatusCode = updateStatusCode;
        this.serdes = serdes;
        this.enableJsonLinks = enableJsonLinks;
        this.strictQueryParams = strictQueryParams;
        this.enableGraphQLFederation = enableGraphQLFederation;
        this.baseUrl = baseUrl;
        this.jsonApiPath = jsonApiPath;
        this.graphQLApiPath = graphQLApiPath;
        this.exportApiPath = exportApiPath;
    }

    public AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    public JsonApiMapper getMapper() {
        return this.mapper;
    }

    public ErrorMapper getErrorMapper() {
        return this.errorMapper;
    }

    public Function<RequestScope, PermissionExecutor> getPermissionExecutor() {
        return this.permissionExecutor;
    }

    public List<JoinFilterDialect> getJoinFilterDialects() {
        return this.joinFilterDialects;
    }

    public List<SubqueryFilterDialect> getSubqueryFilterDialects() {
        return this.subqueryFilterDialects;
    }

    public FilterDialect getGraphqlDialect() {
        return this.graphqlDialect;
    }

    public JSONApiLinks getJsonApiLinks() {
        return this.jsonApiLinks;
    }

    public HeaderUtils.HeaderProcessor getHeaderProcessor() {
        return this.headerProcessor;
    }

    public int getDefaultMaxPageSize() {
        return this.defaultMaxPageSize;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public int getUpdateStatusCode() {
        return this.updateStatusCode;
    }

    public Map<Class, Serde> getSerdes() {
        return this.serdes;
    }

    public boolean isEnableJsonLinks() {
        return this.enableJsonLinks;
    }

    public boolean isStrictQueryParams() {
        return this.strictQueryParams;
    }

    public boolean isEnableGraphQLFederation() {
        return this.enableGraphQLFederation;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getJsonApiPath() {
        return this.jsonApiPath;
    }

    public String getGraphQLApiPath() {
        return this.graphQLApiPath;
    }

    public String getExportApiPath() {
        return this.exportApiPath;
    }
}

