/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.datastore.inmemory;

import com.google.common.collect.Sets;
import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.datastore.inmemory.HashMapStoreTransaction;
import com.yahoo.elide.core.datastore.test.DataStoreTestHarness;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.ClassScanner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class HashMapDataStore
implements DataStore,
DataStoreTestHarness {
    protected final Map<Type<?>, Map<String, Object>> dataStore = Collections.synchronizedMap(new HashMap());
    protected EntityDictionary dictionary;
    private final ConcurrentHashMap<Type<?>, AtomicLong> typeIds = new ConcurrentHashMap();

    public HashMapDataStore(ClassScanner scanner, Package beanPackage) {
        this(scanner, Sets.newHashSet((Object[])new Package[]{beanPackage}));
    }

    public HashMapDataStore(ClassScanner scanner, Set<Package> beanPackages) {
        for (Package beanPackage : beanPackages) {
            scanner.getAllClasses(beanPackage.getName()).stream().map(ClassType::new).filter(modelType -> EntityDictionary.getFirstAnnotation(modelType, Arrays.asList(Include.class, Exclude.class)) instanceof Include).forEach(modelType -> this.dataStore.put((Type<?>)modelType, Collections.synchronizedMap(new LinkedHashMap())));
        }
    }

    public HashMapDataStore(Collection<Class<?>> beanClasses) {
        beanClasses.stream().map(ClassType::new).filter(modelType -> EntityDictionary.getFirstAnnotation(modelType, Arrays.asList(Include.class, Exclude.class)) instanceof Include).forEach(modelType -> this.dataStore.put((Type<?>)modelType, Collections.synchronizedMap(new LinkedHashMap())));
    }

    @Override
    public void populateEntityDictionary(EntityDictionary dictionary) {
        for (Type<?> clazz : this.dataStore.keySet()) {
            dictionary.bindEntity(clazz);
        }
        this.dictionary = dictionary;
    }

    @Override
    public DataStoreTransaction beginTransaction() {
        return new HashMapStoreTransaction(this.dataStore, this.dictionary, this.typeIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data store contents ");
        for (Map.Entry<Type<?>, Map<String, Object>> dse : this.dataStore.entrySet()) {
            sb.append("\n Table ").append(dse.getKey()).append(" contents \n");
            for (Map.Entry<String, Object> e : dse.getValue().entrySet()) {
                sb.append(" Id: ").append(e.getKey()).append(" Value: ").append(e.getValue());
            }
        }
        return sb.toString();
    }

    @Override
    public DataStore getDataStore() {
        return this;
    }

    public Map<String, Object> get(Type<?> cls) {
        return this.dataStore.get(cls);
    }

    @Override
    public void cleanseTestData() {
        for (Map<String, Object> objects : this.dataStore.values()) {
            objects.clear();
        }
        this.typeIds.clear();
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    public ConcurrentHashMap<Type<?>, AtomicLong> getTypeIds() {
        return this.typeIds;
    }
}

