/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.datastore.inmemory;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreIterableBuilder;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.datastore.inmemory.FilteredIterator;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterPredicatePushdownExtractor;
import com.yahoo.elide.core.filter.expression.InMemoryExecutionVerifier;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.type.Type;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;

public class InMemoryStoreTransaction
implements DataStoreTransaction {
    private final DataStoreTransaction tx;
    private static final Comparator<Object> NULL_SAFE_COMPARE = (a, b) -> {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        throw new IllegalStateException("Trying to comparing non-comparable types!");
    };

    public InMemoryStoreTransaction(DataStoreTransaction tx) {
        this.tx = tx;
    }

    public DataStoreIterable<Object> getToManyRelation(DataStoreTransaction relationTx, Object entity, Relationship relationship, RequestScope scope) {
        DataFetcher fetcher = (filterExpression, sorting, pagination, requestScope) -> this.tx.getToManyRelation(relationTx, entity, relationship.copyOf().projection(relationship.getProjection().copyOf().filterExpression(filterExpression.orElse(null)).sorting(sorting.orElse(null)).pagination(pagination.orElse(null)).build()).build(), requestScope);
        boolean filterInMemory = scope.getNewPersistentResources().size() > 0;
        return this.fetchData(fetcher, relationship.getProjection(), filterInMemory, scope);
    }

    public Object loadObject(EntityProjection projection, Serializable id, RequestScope scope) {
        if (projection.getFilterExpression() == null) {
            return this.tx.loadObject(projection, id, scope);
        }
        return DataStoreTransaction.super.loadObject(projection, id, scope);
    }

    public DataStoreIterable<Object> loadObjects(EntityProjection projection, RequestScope scope) {
        DataFetcher fetcher = (filterExpression, sorting, pagination, requestScope) -> this.tx.loadObjects(projection.copyOf().filterExpression(filterExpression.orElse(null)).pagination(pagination.orElse(null)).sorting(sorting.orElse(null)).build(), requestScope);
        return this.fetchData(fetcher, projection, false, scope);
    }

    public void save(Object entity, RequestScope scope) {
        this.tx.save(entity, scope);
    }

    public void delete(Object entity, RequestScope scope) {
        this.tx.delete(entity, scope);
    }

    @Override
    public void preCommit(RequestScope scope) {
        this.tx.preCommit(scope);
    }

    @Override
    public <T> T createNewObject(Type<T> entityClass, RequestScope scope) {
        return this.tx.createNewObject(entityClass, scope);
    }

    @Override
    public <T, R> R getToOneRelation(DataStoreTransaction relationTx, T entity, Relationship relationship, RequestScope scope) {
        return this.tx.getToOneRelation(relationTx, entity, relationship, scope);
    }

    @Override
    public void close() throws IOException {
        this.tx.close();
    }

    @Override
    public <T, R> void updateToManyRelation(DataStoreTransaction relationTx, T entity, String relationName, Set<R> newRelationships, Set<R> deletedRelationships, RequestScope scope) {
        this.tx.updateToManyRelation(relationTx, entity, relationName, newRelationships, deletedRelationships, scope);
    }

    @Override
    public <T, R> void updateToOneRelation(DataStoreTransaction relationTx, T entity, String relationName, R relationshipValue, RequestScope scope) {
        this.tx.updateToOneRelation(relationTx, entity, relationName, relationshipValue, scope);
    }

    public Object getAttribute(Object entity, Attribute attribute, RequestScope scope) {
        return this.tx.getAttribute(entity, attribute, scope);
    }

    public void setAttribute(Object entity, Attribute attribute, RequestScope scope) {
        this.tx.setAttribute(entity, attribute, scope);
    }

    @Override
    public void flush(RequestScope scope) {
        this.tx.flush(scope);
    }

    @Override
    public void commit(RequestScope scope) {
        this.tx.commit(scope);
    }

    public void createObject(Object entity, RequestScope scope) {
        this.tx.createObject(entity, scope);
    }

    private DataStoreIterable<Object> filterLoadedData(final DataStoreIterable<Object> loadedRecords, final Optional<FilterExpression> filterExpression, final RequestScope scope) {
        if (!filterExpression.isPresent()) {
            return loadedRecords;
        }
        return new DataStoreIterable<Object>(){

            @Override
            public Iterable<Object> getWrappedIterable() {
                return loadedRecords;
            }

            @Override
            public Iterator<Object> iterator() {
                return new FilteredIterator<Object>((FilterExpression)filterExpression.get(), scope, loadedRecords.iterator());
            }

            @Override
            public boolean needsInMemoryFilter() {
                return true;
            }

            @Override
            public boolean needsInMemorySort() {
                return true;
            }

            @Override
            public boolean needsInMemoryPagination() {
                return true;
            }
        };
    }

    private DataStoreIterable<Object> fetchData(DataFetcher fetcher, EntityProjection projection, boolean filterInMemory, RequestScope scope) {
        Optional<FilterExpression> filterExpression = Optional.ofNullable(projection.getFilterExpression());
        Pair<Optional<FilterExpression>, Optional<FilterExpression>> expressionSplit = this.splitFilterExpression(scope, projection, filterInMemory);
        Optional dataStoreFilter = (Optional)expressionSplit.getLeft();
        Optional inMemoryFilter = (Optional)expressionSplit.getRight();
        Optional<Sorting> dataStoreSorting = this.getDataStoreSorting(scope, projection, filterInMemory);
        boolean sortingInMemory = dataStoreSorting.isEmpty() && projection.getSorting() != null;
        Optional<Pagination> dataStorePagination = inMemoryFilter.isPresent() || sortingInMemory ? Optional.empty() : Optional.ofNullable(projection.getPagination());
        DataStoreIterable<Object> loadedRecords = fetcher.fetch(dataStoreFilter, dataStoreSorting, dataStorePagination, scope);
        if (loadedRecords == null) {
            return new DataStoreIterableBuilder().build();
        }
        if (inMemoryFilter.isPresent() || loadedRecords.needsInMemoryFilter() && projection.getFilterExpression() != null) {
            loadedRecords = this.filterLoadedData(loadedRecords, filterExpression, scope);
        }
        return this.sortAndPaginateLoadedData(loadedRecords, sortingInMemory, projection.getSorting(), projection.getPagination(), scope);
    }

    private DataStoreIterable<Object> sortAndPaginateLoadedData(DataStoreIterable<Object> loadedRecords, boolean sortingInMemory, Sorting sorting, Pagination pagination, RequestScope scope) {
        boolean mustPaginateInMemory;
        Map<Object, Object> sortRules = sorting == null ? new HashMap() : sorting.getSortingPaths();
        boolean mustSortInMemory = !sortRules.isEmpty() && (sortingInMemory || loadedRecords.needsInMemorySort());
        boolean bl = mustPaginateInMemory = pagination != null && (mustSortInMemory || loadedRecords.needsInMemoryPagination());
        if (!mustSortInMemory && !mustPaginateInMemory) {
            return loadedRecords;
        }
        List<Object> results = StreamSupport.stream(loadedRecords.spliterator(), false).collect(Collectors.toList());
        if (!sortRules.isEmpty()) {
            results = this.sortInMemory(results, sortRules, scope);
        }
        if (pagination != null) {
            results = this.paginateInMemory(results, pagination);
        }
        return new DataStoreIterableBuilder<Object>(results).build();
    }

    private List<Object> paginateInMemory(List<Object> records, Pagination pagination) {
        int offset = pagination.getOffset();
        int limit = pagination.getLimit();
        if (offset < 0 || offset >= records.size()) {
            return Collections.emptyList();
        }
        int endIdx = offset + limit;
        if (endIdx > records.size()) {
            endIdx = records.size();
        }
        if (pagination.returnPageTotals()) {
            pagination.setPageTotals(Long.valueOf(records.size()));
        }
        return records.subList(offset, endIdx);
    }

    private List<Object> sortInMemory(List<Object> records, Map<Path, Sorting.SortOrder> sortRules, RequestScope scope) {
        Comparator noSort = (left, right) -> 0;
        Comparator comp = sortRules.entrySet().stream().map(entry -> this.getComparator((Path)entry.getKey(), (Sorting.SortOrder)((Object)((Object)entry.getValue())), scope)).reduce(noSort, (comparator1, comparator2) -> (left, right) -> {
            int comparison = comparator1.compare(left, right);
            if (comparison == 0) {
                return comparator2.compare(left, right);
            }
            return comparison;
        });
        records.sort(comp);
        return records;
    }

    private Comparator<Object> getComparator(Path path, Sorting.SortOrder order, RequestScope requestScope) {
        return (left, right) -> {
            Object leftCompare = left;
            Object rightCompare = right;
            for (Path.PathElement pathElement : path.getPathElements()) {
                leftCompare = leftCompare == null ? null : PersistentResource.getValue(leftCompare, pathElement.getFieldName(), requestScope);
                rightCompare = rightCompare == null ? null : PersistentResource.getValue(rightCompare, pathElement.getFieldName(), requestScope);
            }
            if (order == Sorting.SortOrder.asc) {
                return NULL_SAFE_COMPARE.compare(leftCompare, rightCompare);
            }
            return NULL_SAFE_COMPARE.compare(rightCompare, leftCompare);
        };
    }

    private Optional<Sorting> getDataStoreSorting(RequestScope scope, EntityProjection projection, boolean filterInMemory) {
        Sorting sorting = projection.getSorting();
        if (filterInMemory) {
            return Optional.empty();
        }
        Map<Object, Object> sortRules = sorting == null ? new HashMap() : sorting.getSortingPaths();
        boolean sortingOnComputedAttribute = false;
        for (Path path : sortRules.keySet()) {
            if (!path.isComputed(scope.getDictionary())) continue;
            Type pathType = path.getPathElements().get(0).getType();
            if (!projection.getType().equals(pathType)) continue;
            sortingOnComputedAttribute = true;
            break;
        }
        if (sortingOnComputedAttribute) {
            return Optional.empty();
        }
        return Optional.ofNullable(sorting);
    }

    private Pair<Optional<FilterExpression>, Optional<FilterExpression>> splitFilterExpression(RequestScope scope, EntityProjection projection, boolean filterInMemory) {
        Optional<FilterExpression> filterExpression;
        Optional<FilterExpression> inStoreFilterExpression = filterExpression = Optional.ofNullable(projection.getFilterExpression());
        Optional<Object> inMemoryFilterExpression = Optional.empty();
        boolean transactionNeedsInMemoryFiltering = filterInMemory;
        if (filterExpression.isPresent()) {
            inStoreFilterExpression = transactionNeedsInMemoryFiltering ? Optional.empty() : Optional.ofNullable(FilterPredicatePushdownExtractor.extractPushDownPredicate(scope.getDictionary(), filterExpression.get()));
            boolean expressionNeedsInMemoryFiltering = InMemoryExecutionVerifier.shouldExecuteInMemory(scope.getDictionary(), filterExpression.get());
            if (transactionNeedsInMemoryFiltering || expressionNeedsInMemoryFiltering) {
                inMemoryFilterExpression = filterExpression;
            }
        }
        return Pair.of(inStoreFilterExpression, inMemoryFilterExpression);
    }

    @Override
    public void cancel(RequestScope scope) {
        this.tx.cancel(scope);
    }

    @Override
    public <T> T getProperty(String propertyName) {
        return this.tx.getProperty(propertyName);
    }

    @FunctionalInterface
    private static interface DataFetcher {
        public DataStoreIterable<Object> fetch(Optional<FilterExpression> var1, Optional<Sorting> var2, Optional<Pagination> var3, RequestScope var4);
    }
}

