/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.dictionary;

import com.yahoo.elide.annotation.ComputedAttribute;
import com.yahoo.elide.annotation.ComputedRelationship;
import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.annotation.ToMany;
import com.yahoo.elide.annotation.ToOne;
import com.yahoo.elide.core.dictionary.ArgumentType;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.EntityPermissions;
import com.yahoo.elide.core.dictionary.Injector;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.exceptions.DuplicateMappingException;
import com.yahoo.elide.core.lifecycle.LifeCycleHook;
import com.yahoo.elide.core.security.RequestScope;
import com.yahoo.elide.core.type.AccessibleObject;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Field;
import com.yahoo.elide.core.type.Member;
import com.yahoo.elide.core.type.Method;
import com.yahoo.elide.core.type.Type;
import jakarta.inject.Inject;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapsId;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class EntityBinding {
    public static final List<Class<? extends Annotation>> ID_ANNOTATIONS = List.of(Id.class, EmbeddedId.class);
    private static final List<Class<? extends Annotation>> RELATIONSHIP_TYPES = Arrays.asList(ManyToMany.class, ManyToOne.class, OneToMany.class, OneToOne.class, ToOne.class, ToMany.class);
    private final boolean isElideModel;
    public final Type<?> entityClass;
    public final String jsonApiType;
    public boolean idGenerated;
    private AccessibleObject idField;
    private String idFieldName;
    private Type<?> idType;
    private AccessType accessType;
    private final boolean injected;
    private Injector injector;
    private String apiVersion;
    public final EntityPermissions entityPermissions;
    public final List<String> apiAttributes;
    public final List<String> apiRelationships;
    public final List<Type<?>> inheritedTypes;
    public final ConcurrentLinkedDeque<String> attributesDeque = new ConcurrentLinkedDeque();
    public final ConcurrentLinkedDeque<String> relationshipsDeque = new ConcurrentLinkedDeque();
    public final ConcurrentHashMap<String, RelationshipType> relationshipTypes = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, String> relationshipToInverse = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, CascadeType[]> relationshipToCascadeTypes = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, AccessibleObject> fieldsToValues = new ConcurrentHashMap();
    public final MultiValuedMap<Triple<String, LifeCycleHookBinding.Operation, LifeCycleHookBinding.TransactionPhase>, LifeCycleHook> fieldTriggers = new HashSetValuedHashMap();
    public final MultiValuedMap<Pair<LifeCycleHookBinding.Operation, LifeCycleHookBinding.TransactionPhase>, LifeCycleHook> classTriggers = new HashSetValuedHashMap();
    public final ConcurrentHashMap<String, Type<?>> fieldsToTypes = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, String> aliasesToFields = new ConcurrentHashMap();
    public final ConcurrentHashMap<Method, Boolean> requestScopeableMethods = new ConcurrentHashMap();
    public final ConcurrentHashMap<AccessibleObject, Set<ArgumentType>> attributeArguments = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, ArgumentType> entityArguments = new ConcurrentHashMap();
    public final ConcurrentHashMap<Object, Annotation> annotations = new ConcurrentHashMap();
    public static final EntityBinding EMPTY_BINDING = new EntityBinding();
    public static final Set<ArgumentType> EMPTY_ATTRIBUTES_ARGS = Collections.unmodifiableSet(new HashSet());
    private static final Annotation NO_ANNOTATION = () -> null;

    private EntityBinding() {
        this.isElideModel = false;
        this.injected = false;
        this.jsonApiType = null;
        this.apiVersion = "";
        this.apiAttributes = new ArrayList<String>();
        this.apiRelationships = new ArrayList<String>();
        this.inheritedTypes = new ArrayList();
        this.idField = null;
        this.idType = null;
        this.entityClass = null;
        this.entityPermissions = EntityPermissions.EMPTY_PERMISSIONS;
        this.idGenerated = false;
        this.injector = null;
    }

    public EntityBinding(Injector injector, Type<?> cls, String type) {
        this(injector, cls, type, "", unused -> false);
    }

    public EntityBinding(Injector injector, Type<?> cls, String type, String apiVersion, Predicate<AccessibleObject> isFieldHidden) {
        this(injector, cls, type, apiVersion, true, isFieldHidden);
    }

    public EntityBinding(Injector injector, Type<?> cls, String type, String apiVersion, boolean isElideModel, Predicate<AccessibleObject> isFieldHidden) {
        this.isElideModel = isElideModel;
        this.injector = injector;
        this.entityClass = cls;
        this.jsonApiType = type;
        this.apiVersion = apiVersion;
        this.inheritedTypes = this.getInheritedTypes(cls);
        List<AccessibleObject> fieldOrMethodList = this.getAllFields();
        this.injected = this.shouldInject();
        if (fieldOrMethodList.stream().anyMatch(EntityBinding::isIdField)) {
            this.accessType = AccessType.FIELD;
            fieldOrMethodList.addAll(this.getInstanceMembers(cls.getMethods(), method -> method.isAnnotationPresent(LifeCycleHookBinding.class) || method.isAnnotationPresent(ComputedAttribute.class) || method.isAnnotationPresent(ComputedRelationship.class)));
            fieldOrMethodList.forEach(field -> field.setAccessible(true));
        } else {
            this.accessType = AccessType.PROPERTY;
            fieldOrMethodList.clear();
            fieldOrMethodList.addAll(this.getInstanceMembers(cls.getFields()));
            fieldOrMethodList.addAll(this.getInstanceMembers(cls.getMethods()));
        }
        this.bindEntityFields(cls, type, fieldOrMethodList, isFieldHidden);
        this.bindTriggerIfPresent();
        this.apiAttributes = EntityBinding.dequeToList(this.attributesDeque);
        this.apiRelationships = EntityBinding.dequeToList(this.relationshipsDeque);
        this.entityPermissions = new EntityPermissions(cls, fieldOrMethodList);
    }

    private <T extends Member> List<T> getInstanceMembers(T[] objects) {
        return this.getInstanceMembers((Member[])objects, o -> true);
    }

    private <T extends Member> List<T> getInstanceMembers(T[] objects, Predicate<T> filteredBy) {
        return Arrays.stream(objects).filter(o -> !Modifier.isStatic(o.getModifiers())).filter(filteredBy).collect(Collectors.toList());
    }

    public List<AccessibleObject> getAllFields() {
        ArrayList<AccessibleObject> fields = new ArrayList<AccessibleObject>();
        fields.addAll(this.getInstanceMembers(this.entityClass.getDeclaredFields(), field -> !field.isSynthetic()));
        for (Type<?> type : this.inheritedTypes) {
            fields.addAll(this.getInstanceMembers(type.getDeclaredFields(), field -> !field.isSynthetic()));
        }
        return fields;
    }

    public List<AccessibleObject> getAllMethods() {
        ArrayList<AccessibleObject> methods = new ArrayList<AccessibleObject>();
        methods.addAll(this.getInstanceMembers(this.entityClass.getDeclaredMethods(), method -> !method.isSynthetic()));
        for (Type<?> type : this.inheritedTypes) {
            methods.addAll(this.getInstanceMembers(type.getDeclaredMethods(), method -> !method.isSynthetic()));
        }
        return methods;
    }

    private void bindEntityFields(Type<?> cls, String type, Collection<AccessibleObject> fieldOrMethodList, Predicate<AccessibleObject> isFieldHidden) {
        for (AccessibleObject fieldOrMethod : fieldOrMethodList) {
            this.bindTriggerIfPresent(fieldOrMethod);
            if (EntityBinding.isIdField(fieldOrMethod)) {
                this.bindEntityId(cls, type, fieldOrMethod);
                continue;
            }
            if (fieldOrMethod.isAnnotationPresent(Transient.class) && !fieldOrMethod.isAnnotationPresent(ComputedAttribute.class) && !fieldOrMethod.isAnnotationPresent(ComputedRelationship.class) || fieldOrMethod.isAnnotationPresent(Exclude.class) || fieldOrMethod instanceof Field && Modifier.isTransient(((Field)fieldOrMethod).getModifiers()) || fieldOrMethod instanceof Method && Modifier.isTransient(((Method)fieldOrMethod).getModifiers()) || fieldOrMethod instanceof Field && !fieldOrMethod.isAnnotationPresent(Column.class) && Modifier.isStatic(((Field)fieldOrMethod).getModifiers())) continue;
            this.bindAttrOrRelation(fieldOrMethod, isFieldHidden.test(fieldOrMethod));
        }
    }

    private void bindEntityId(Type<?> cls, String type, AccessibleObject fieldOrMethod) {
        String fieldName = EntityBinding.getFieldName(fieldOrMethod);
        Type<?> fieldType = EntityBinding.getFieldType(cls, fieldOrMethod);
        this.fieldsToTypes.put(fieldName, fieldType);
        this.idField = fieldOrMethod;
        this.idType = fieldType;
        this.idFieldName = fieldName;
        this.fieldsToValues.put(fieldName, fieldOrMethod);
        if (this.idField != null && !fieldOrMethod.equals(this.idField)) {
            throw new DuplicateMappingException(type + " " + cls.getName() + ":" + fieldName);
        }
        if (fieldOrMethod.isAnnotationPresent(GeneratedValue.class)) {
            this.idGenerated = true;
        }
    }

    private static List<String> dequeToList(Deque<String> deque) {
        ArrayList result = new ArrayList();
        deque.stream().forEachOrdered(result::add);
        result.sort(String.CASE_INSENSITIVE_ORDER);
        return Collections.unmodifiableList(result);
    }

    private void bindAttrOrRelation(AccessibleObject fieldOrMethod, boolean isHidden) {
        boolean isRelation = RELATIONSHIP_TYPES.stream().anyMatch(fieldOrMethod::isAnnotationPresent);
        String fieldName = EntityBinding.getFieldName(fieldOrMethod);
        Type<?> fieldType = EntityBinding.getFieldType(this.entityClass, fieldOrMethod);
        if (fieldName == null || "id".equals(fieldName) || "class".equals(fieldName) || ClassType.OBJ_METHODS.contains(fieldOrMethod)) {
            return;
        }
        if (fieldOrMethod instanceof Method) {
            Method method = (Method)fieldOrMethod;
            this.requestScopeableMethods.put(method, EntityBinding.isRequestScopeableMethod(method));
        }
        if (isRelation) {
            this.bindRelation(fieldOrMethod, fieldName, fieldType, isHidden);
        } else {
            this.bindAttr(fieldOrMethod, fieldName, fieldType, isHidden);
        }
    }

    private void bindRelation(AccessibleObject fieldOrMethod, String fieldName, Type<?> fieldType, boolean isHidden) {
        RelationshipType type;
        boolean manyToMany = fieldOrMethod.isAnnotationPresent(ManyToMany.class);
        boolean manyToOne = fieldOrMethod.isAnnotationPresent(ManyToOne.class);
        boolean oneToMany = fieldOrMethod.isAnnotationPresent(OneToMany.class);
        boolean oneToOne = fieldOrMethod.isAnnotationPresent(OneToOne.class);
        boolean toOne = fieldOrMethod.isAnnotationPresent(ToOne.class);
        boolean toMany = fieldOrMethod.isAnnotationPresent(ToMany.class);
        boolean computedRelationship = fieldOrMethod.isAnnotationPresent(ComputedRelationship.class);
        if (fieldOrMethod.isAnnotationPresent(MapsId.class)) {
            this.idGenerated = true;
        }
        String mappedBy = "";
        CascadeType[] cascadeTypes = new CascadeType[]{};
        if (oneToMany) {
            type = computedRelationship ? RelationshipType.COMPUTED_ONE_TO_MANY : RelationshipType.ONE_TO_MANY;
            mappedBy = fieldOrMethod.getAnnotation(OneToMany.class).mappedBy();
            cascadeTypes = fieldOrMethod.getAnnotation(OneToMany.class).cascade();
        } else if (oneToOne) {
            type = computedRelationship ? RelationshipType.COMPUTED_ONE_TO_ONE : RelationshipType.ONE_TO_ONE;
            mappedBy = fieldOrMethod.getAnnotation(OneToOne.class).mappedBy();
            cascadeTypes = fieldOrMethod.getAnnotation(OneToOne.class).cascade();
        } else if (manyToMany) {
            type = computedRelationship ? RelationshipType.COMPUTED_MANY_TO_MANY : RelationshipType.MANY_TO_MANY;
            mappedBy = fieldOrMethod.getAnnotation(ManyToMany.class).mappedBy();
            cascadeTypes = fieldOrMethod.getAnnotation(ManyToMany.class).cascade();
        } else if (manyToOne) {
            type = computedRelationship ? RelationshipType.COMPUTED_MANY_TO_ONE : RelationshipType.MANY_TO_ONE;
            cascadeTypes = fieldOrMethod.getAnnotation(ManyToOne.class).cascade();
        } else {
            type = toOne ? RelationshipType.COMPUTED_ONE_TO_ONE : (toMany ? RelationshipType.COMPUTED_ONE_TO_MANY : (computedRelationship ? RelationshipType.COMPUTED_NONE : RelationshipType.NONE));
        }
        this.relationshipTypes.put(fieldName, type);
        this.relationshipToInverse.put(fieldName, mappedBy);
        this.relationshipToCascadeTypes.put(fieldName, cascadeTypes);
        if (!isHidden) {
            this.relationshipsDeque.push(fieldName);
        }
        this.fieldsToValues.put(fieldName, fieldOrMethod);
        this.fieldsToTypes.put(fieldName, fieldType);
    }

    private void bindAttr(AccessibleObject fieldOrMethod, String fieldName, Type<?> fieldType, boolean isHidden) {
        if (!isHidden) {
            this.attributesDeque.push(fieldName);
        }
        this.fieldsToValues.put(fieldName, fieldOrMethod);
        this.fieldsToTypes.put(fieldName, fieldType);
    }

    public static String getFieldName(AccessibleObject fieldOrMethod) {
        boolean hasValidParameterCount;
        if (fieldOrMethod instanceof Field) {
            return ((Field)fieldOrMethod).getName();
        }
        Method method = (Method)fieldOrMethod;
        String name = method.getName();
        boolean bl = hasValidParameterCount = method.getParameterCount() == 0 || EntityBinding.isRequestScopeableMethod(method);
        if (name.startsWith("get") && hasValidParameterCount) {
            return StringUtils.uncapitalize((String)name.substring("get".length()));
        }
        if (name.startsWith("is") && hasValidParameterCount) {
            return StringUtils.uncapitalize((String)name.substring("is".length()));
        }
        return null;
    }

    public static boolean isRequestScopeableMethod(Method method) {
        return EntityBinding.isComputedMethod(method) && method.getParameterCount() == 1 && RequestScope.class.isAssignableFrom(method.getParameterTypes()[0]);
    }

    public static boolean isComputedMethod(Method method) {
        return Stream.of(method.getAnnotations()).map(Annotation::annotationType).anyMatch(c -> ComputedAttribute.class == c || ComputedRelationship.class == c);
    }

    public static Type<?> getFieldType(Type<?> parentClass, AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Field) {
            return ((Field)fieldOrMethod).getType();
        }
        return ((Method)fieldOrMethod).getReturnType();
    }

    public static Type<?> getFieldType(Type<?> parentClass, AccessibleObject fieldOrMethod, Optional<Integer> index) {
        if (fieldOrMethod instanceof Field) {
            return ((Field)fieldOrMethod).getParameterizedType(parentClass, index);
        }
        return ((Method)fieldOrMethod).getParameterizedReturnType(parentClass, index);
    }

    private void bindTriggerIfPresent(AccessibleObject fieldOrMethod) {
        LifeCycleHookBinding[] triggers;
        for (LifeCycleHookBinding trigger : triggers = (LifeCycleHookBinding[])fieldOrMethod.getAnnotationsByType(LifeCycleHookBinding.class)) {
            this.bindTrigger(trigger, EntityBinding.getFieldName(fieldOrMethod));
        }
    }

    private void bindTriggerIfPresent() {
        LifeCycleHookBinding[] triggers;
        for (LifeCycleHookBinding trigger : triggers = (LifeCycleHookBinding[])this.entityClass.getAnnotationsByType(LifeCycleHookBinding.class)) {
            this.bindTrigger(trigger);
        }
    }

    public void bindTrigger(LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, String fieldOrMethodName, LifeCycleHook hook) {
        Triple key = Triple.of((Object)fieldOrMethodName, (Object)((Object)operation), (Object)((Object)phase));
        this.fieldTriggers.put((Object)key, (Object)hook);
    }

    private void bindTrigger(LifeCycleHookBinding binding, String fieldOrMethodName) {
        LifeCycleHook hook = this.injector.instantiate(binding.hook());
        this.injector.inject(hook);
        this.bindTrigger(binding.operation(), binding.phase(), fieldOrMethodName, hook);
    }

    public void bindTrigger(LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, LifeCycleHook hook) {
        Pair key = Pair.of((Object)((Object)operation), (Object)((Object)phase));
        this.classTriggers.put((Object)key, (Object)hook);
    }

    private void bindTrigger(LifeCycleHookBinding binding) {
        if (binding.oncePerRequest()) {
            this.bindTrigger(binding, "");
            return;
        }
        LifeCycleHook hook = this.injector.instantiate(binding.hook());
        this.injector.inject(hook);
        this.bindTrigger(binding.operation(), binding.phase(), hook);
    }

    public Collection<LifeCycleHook> getTriggers(LifeCycleHookBinding.Operation op, LifeCycleHookBinding.TransactionPhase phase, String fieldName) {
        Triple key = Triple.of((Object)fieldName, (Object)((Object)op), (Object)((Object)phase));
        Collection bindings = this.fieldTriggers.get((Object)key);
        return bindings == null ? Collections.emptyList() : bindings;
    }

    public Collection<LifeCycleHook> getTriggers(LifeCycleHookBinding.Operation op, LifeCycleHookBinding.TransactionPhase phase) {
        Pair key = Pair.of((Object)((Object)op), (Object)((Object)phase));
        Collection bindings = this.classTriggers.get((Object)key);
        return bindings == null ? Collections.emptyList() : bindings;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        Annotation annotation = this.annotations.computeIfAbsent(annotationClass, cls -> Optional.ofNullable(EntityDictionary.getFirstAnnotation(this.entityClass, Collections.singletonList(annotationClass))).orElse(NO_ANNOTATION));
        return (A)(annotation == NO_ANNOTATION ? null : (Annotation)annotationClass.cast(annotation));
    }

    public <A extends Annotation> A getMethodAnnotation(Class<A> annotationClass, String method) {
        Annotation annotation = this.annotations.computeIfAbsent(Pair.of(annotationClass, (Object)method), key -> {
            try {
                return Optional.ofNullable(this.entityClass.getMethod(method, new Type[0]).getAnnotation(annotationClass)).orElse(NO_ANNOTATION);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalStateException(e);
            }
        });
        return (A)(annotation == NO_ANNOTATION ? null : (Annotation)annotationClass.cast(annotation));
    }

    private boolean shouldInject() {
        boolean hasField = this.getAllFields().stream().anyMatch(accessibleObject -> accessibleObject.isAnnotationPresent(Inject.class));
        if (hasField) {
            return true;
        }
        boolean hasMethod = this.getAllMethods().stream().anyMatch(accessibleObject -> accessibleObject.isAnnotationPresent(Inject.class));
        if (hasMethod) {
            return true;
        }
        boolean hasConstructor = Arrays.stream(this.entityClass.getConstructors()).anyMatch(ctor -> ctor.getAnnotation(Inject.class) != null);
        return hasConstructor;
    }

    private List<Type<?>> getInheritedTypes(Type<?> entityCls) {
        ArrayList results = new ArrayList();
        for (Type<?> cls = entityCls.getSuperclass(); cls != null && cls.hasSuperType(); cls = cls.getSuperclass()) {
            results.add(cls);
        }
        return results;
    }

    public void addArgumentsToAttribute(String attribute, Set<ArgumentType> arguments) {
        AccessibleObject fieldObject = this.fieldsToValues.get(attribute);
        if (fieldObject != null && arguments != null) {
            Set<ArgumentType> existingArgs = this.attributeArguments.get(fieldObject);
            if (existingArgs != null) {
                existingArgs.addAll(arguments);
            } else {
                this.attributeArguments.put(fieldObject, new HashSet<ArgumentType>(arguments));
            }
        }
    }

    public Set<ArgumentType> getAttributeArguments(String attribute) {
        AccessibleObject fieldObject = this.fieldsToValues.get(attribute);
        return fieldObject != null ? this.attributeArguments.getOrDefault(fieldObject, EMPTY_ATTRIBUTES_ARGS) : EMPTY_ATTRIBUTES_ARGS;
    }

    public void addArgumentToEntity(ArgumentType argument) {
        if (argument != null) {
            this.entityArguments.put(argument.getName(), argument);
        }
    }

    public Set<Type<?>> getAttributes() {
        return this.apiAttributes.stream().map(attributeName -> this.fieldsToTypes.get(attributeName)).collect(Collectors.toSet());
    }

    public Set<AccessibleObject> getAllFields(Predicate<AccessibleObject> filter) {
        return this.fieldsToValues.values().stream().filter(filter).collect(Collectors.toSet());
    }

    public Set<ArgumentType> getEntityArguments() {
        return new HashSet<ArgumentType>(this.entityArguments.values());
    }

    public static boolean isIdField(AccessibleObject field) {
        return field.isAnnotationPresent(Id.class) || field.isAnnotationPresent(EmbeddedId.class);
    }

    public boolean isElideModel() {
        return this.isElideModel;
    }

    public Type<?> getEntityClass() {
        return this.entityClass;
    }

    public String getJsonApiType() {
        return this.jsonApiType;
    }

    public boolean isIdGenerated() {
        return this.idGenerated;
    }

    public AccessibleObject getIdField() {
        return this.idField;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public Type<?> getIdType() {
        return this.idType;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public boolean isInjected() {
        return this.injected;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }
}

