/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.ErrorObjects;
import com.yahoo.elide.core.type.ClassType;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpStatusException
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(HttpStatusException.class);
    private static final long serialVersionUID = 1L;
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final int status;
    private final Optional<Supplier<String>> verboseMessageSupplier;

    public HttpStatusException(int status, String message) {
        this(status, message, null, null);
    }

    public HttpStatusException(int status, String message, Throwable cause, Supplier<String> verboseMessageSupplier) {
        super(message, cause, true, log.isTraceEnabled());
        this.status = status;
        this.verboseMessageSupplier = Optional.ofNullable(verboseMessageSupplier);
    }

    protected static String formatExceptionCause(Throwable e) {
        Throwable error = e.getCause() == null ? e : e.getCause();
        return error != null ? (String)StringUtils.defaultIfBlank((CharSequence)error.getMessage(), (CharSequence)error.toString()) : null;
    }

    public Pair<Integer, JsonNode> getErrorResponse() {
        return this.buildResponse(this.getMessage());
    }

    public Pair<Integer, JsonNode> getVerboseErrorResponse() {
        return this.buildResponse(this.getVerboseMessage());
    }

    private Pair<Integer, JsonNode> buildResponse(String message) {
        String errorDetail = message;
        errorDetail = Encode.forHtml((String)errorDetail);
        ErrorObjects errors = ErrorObjects.builder().addError().withDetail(errorDetail).build();
        JsonNode responseBody = (JsonNode)OBJECT_MAPPER.convertValue((Object)errors, JsonNode.class);
        return Pair.of((Object)this.getStatus(), (Object)responseBody);
    }

    public String getVerboseMessage() {
        String result = this.verboseMessageSupplier.map(Supplier::get).orElseGet(this::getMessage);
        if (result.equals(this.getMessage())) {
            return result;
        }
        return this.getMessage() + "\n" + result;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        Object message = this.getMessage();
        String className = EntityDictionary.getSimpleName(ClassType.of(this.getClass()));
        message = message == null ? className : className + ": " + (String)message;
        return message;
    }
}

