/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.expression;

import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;

public class OrFilterExpression
implements FilterExpression {
    private FilterExpression left;
    private FilterExpression right;

    public static FilterExpression fromPair(FilterExpression left, FilterExpression right) {
        if (left != null && right != null) {
            return new OrFilterExpression(left, right);
        }
        if (left == null) {
            return right;
        }
        return left;
    }

    public OrFilterExpression(FilterExpression left, FilterExpression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public <T> T accept(FilterExpressionVisitor<T> visitor) {
        return visitor.visitOrExpression(this);
    }

    public String toString() {
        return String.format("(%s OR %s)", this.left, this.right);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrFilterExpression)) {
            return false;
        }
        OrFilterExpression other = (OrFilterExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FilterExpression this$left = this.getLeft();
        FilterExpression other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        FilterExpression this$right = this.getRight();
        FilterExpression other$right = other.getRight();
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrFilterExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FilterExpression $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        FilterExpression $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }

    public FilterExpression getLeft() {
        return this.left;
    }

    public FilterExpression getRight() {
        return this.right;
    }
}

