/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.pagination;

import com.google.common.collect.ImmutableMap;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.annotation.Paginate;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PaginationImpl
implements Pagination {
    public static final String PAGE_NUMBER_KEY = "page[number]";
    public static final String PAGE_SIZE_KEY = "page[size]";
    public static final String PAGE_OFFSET_KEY = "page[offset]";
    public static final String PAGE_LIMIT_KEY = "page[limit]";
    public static final String PAGE_TOTALS_KEY = "page[totals]";
    public static final Map<String, PaginationKey> PAGE_KEYS = ImmutableMap.of((Object)"page[number]", (Object)((Object)PaginationKey.number), (Object)"page[size]", (Object)((Object)PaginationKey.size), (Object)"page[offset]", (Object)((Object)PaginationKey.offset), (Object)"page[limit]", (Object)((Object)PaginationKey.limit), (Object)"page[totals]", (Object)((Object)PaginationKey.totals));
    private Long pageTotals = 0L;
    private static final String PAGE_KEYS_CSV = PAGE_KEYS.keySet().stream().collect(Collectors.joining(", "));
    private final int offset;
    private final int limit;
    private final boolean generateTotals;
    private final boolean defaultInstance;
    private final Type<?> entityClass;

    public PaginationImpl(Class<?> entityClass, Integer clientOffset, Integer clientLimit, int systemDefaultLimit, int systemMaxLimit, Boolean generateTotals, Boolean pageByPages) {
        this(ClassType.of(entityClass), clientOffset, clientLimit, systemDefaultLimit, systemMaxLimit, generateTotals, pageByPages);
    }

    public PaginationImpl(Type<?> entityClass, Integer clientOffset, Integer clientLimit, int systemDefaultLimit, int systemMaxLimit, Boolean generateTotals, Boolean pageByPages) {
        String pageSizeLabel;
        Paginate paginate;
        this.entityClass = entityClass;
        this.defaultInstance = clientOffset == null && clientLimit == null && generateTotals == null;
        Paginate paginate2 = paginate = entityClass != null ? entityClass.getAnnotation(Paginate.class) : null;
        this.limit = clientLimit != null ? clientLimit : (paginate != null ? paginate.defaultLimit() : systemDefaultLimit);
        int maxLimit = paginate != null ? paginate.maxLimit() : systemMaxLimit;
        String string = pageSizeLabel = pageByPages != false ? "size" : "limit";
        if (this.limit > maxLimit && !this.defaultInstance) {
            throw new InvalidValueException((Object)("Pagination " + pageSizeLabel + " must be less than or equal to " + maxLimit));
        }
        if (this.limit < 1) {
            throw new InvalidValueException((Object)("Pagination " + pageSizeLabel + " must contain a positive, non-zero value."));
        }
        boolean bl = this.generateTotals = generateTotals != null && generateTotals != false && (paginate == null || paginate.countable());
        if (pageByPages.booleanValue()) {
            int pageNumber;
            int n = pageNumber = clientOffset != null ? clientOffset : 1;
            if (pageNumber < 1) {
                throw new InvalidValueException((Object)"Pagination number must be a positive, non-zero value.");
            }
            this.offset = (pageNumber - 1) * this.limit;
        } else {
            int n = this.offset = clientOffset != null ? clientOffset : 0;
            if (this.offset < 0) {
                throw new InvalidValueException((Object)"Pagination offset must contain a positive value.");
            }
        }
    }

    @Override
    public boolean returnPageTotals() {
        return this.generateTotals;
    }

    public static PaginationImpl parseQueryParams(Type<?> entityClass, MultivaluedMap<String, String> queryParams, ElideSettings elideSettings) throws InvalidValueException {
        if (queryParams.isEmpty()) {
            return PaginationImpl.getDefaultPagination(entityClass, elideSettings);
        }
        HashMap<PaginationKey, Integer> pageData = new HashMap<PaginationKey, Integer>();
        queryParams.entrySet().forEach(paramEntry -> {
            String queryParamKey = (String)paramEntry.getKey();
            if (PAGE_KEYS.containsKey(queryParamKey)) {
                PaginationKey paginationKey = PAGE_KEYS.get(queryParamKey);
                if (paginationKey.equals((Object)PaginationKey.totals)) {
                    pageData.put(paginationKey, 0);
                } else {
                    String value = (String)((List)paramEntry.getValue()).get(0);
                    try {
                        int intValue = Integer.parseInt(value, 10);
                        pageData.put(paginationKey, intValue);
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidValueException((Object)"page values must be integers");
                    }
                }
            } else if (queryParamKey.startsWith("page[")) {
                throw new InvalidValueException((Object)("Invalid Pagination Parameter. Accepted values are " + PAGE_KEYS_CSV));
            }
        });
        return PaginationImpl.getPagination(entityClass, pageData, elideSettings);
    }

    private static PaginationImpl getPagination(Type<?> entityClass, Map<PaginationKey, Integer> pageData, ElideSettings elideSettings) {
        if (PaginationImpl.hasInvalidCombination(pageData)) {
            throw new InvalidValueException((Object)"Invalid usage of pagination parameters.");
        }
        boolean pageByPages = false;
        Integer offset = pageData.getOrDefault((Object)PaginationKey.offset, null);
        Integer limit = pageData.getOrDefault((Object)PaginationKey.limit, null);
        if (pageData.containsKey((Object)PaginationKey.size) || pageData.containsKey((Object)PaginationKey.number)) {
            pageByPages = true;
            offset = pageData.getOrDefault((Object)PaginationKey.number, null);
            limit = pageData.getOrDefault((Object)PaginationKey.size, null);
        }
        return new PaginationImpl(entityClass, offset, limit, elideSettings.getDefaultPageSize(), elideSettings.getDefaultMaxPageSize(), pageData.containsKey((Object)PaginationKey.totals) ? Boolean.valueOf(true) : null, (Boolean)pageByPages);
    }

    private static boolean hasInvalidCombination(Map<PaginationKey, Integer> pageData) {
        return !(!pageData.containsKey((Object)PaginationKey.size) && !pageData.containsKey((Object)PaginationKey.number) || !pageData.containsKey((Object)PaginationKey.limit) && !pageData.containsKey((Object)PaginationKey.offset));
    }

    public static PaginationImpl getDefaultPagination(Type<?> entityClass, ElideSettings elideSettings) {
        return new PaginationImpl(entityClass, null, null, elideSettings.getDefaultPageSize(), elideSettings.getDefaultMaxPageSize(), null, (Boolean)false);
    }

    public static PaginationImpl getDefaultPagination(Type<?> entityClass) {
        return new PaginationImpl(entityClass, null, null, 500, 10000, null, (Boolean)false);
    }

    public String toString() {
        return "PaginationImpl(pageTotals=" + this.getPageTotals() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", generateTotals=" + this.generateTotals + ", defaultInstance=" + this.isDefaultInstance() + ", entityClass=" + this.getEntityClass() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaginationImpl)) {
            return false;
        }
        PaginationImpl other = (PaginationImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.generateTotals != other.generateTotals) {
            return false;
        }
        if (this.isDefaultInstance() != other.isDefaultInstance()) {
            return false;
        }
        Long this$pageTotals = this.getPageTotals();
        Long other$pageTotals = other.getPageTotals();
        if (this$pageTotals == null ? other$pageTotals != null : !((Object)this$pageTotals).equals(other$pageTotals)) {
            return false;
        }
        Type<?> this$entityClass = this.getEntityClass();
        Type<?> other$entityClass = other.getEntityClass();
        return !(this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaginationImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getLimit();
        result = result * 59 + (this.generateTotals ? 79 : 97);
        result = result * 59 + (this.isDefaultInstance() ? 79 : 97);
        Long $pageTotals = this.getPageTotals();
        result = result * 59 + ($pageTotals == null ? 43 : ((Object)$pageTotals).hashCode());
        Type<?> $entityClass = this.getEntityClass();
        result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
        return result;
    }

    @Override
    public Long getPageTotals() {
        return this.pageTotals;
    }

    @Override
    public void setPageTotals(Long pageTotals) {
        this.pageTotals = pageTotals;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean isDefaultInstance() {
        return this.defaultInstance;
    }

    public Type<?> getEntityClass() {
        return this.entityClass;
    }

    public static enum PaginationKey {
        offset,
        number,
        size,
        limit,
        totals;

    }
}

