/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.checks;

import com.yahoo.elide.annotation.FilterExpressionPath;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.filter.visitors.FilterExpressionCheckEvaluationVisitor;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.RequestScope;
import com.yahoo.elide.core.security.checks.OperationCheck;
import com.yahoo.elide.core.type.Type;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilterExpressionCheck<T>
extends OperationCheck<T> {
    private static final Logger log = LoggerFactory.getLogger(FilterExpressionCheck.class);

    public abstract FilterExpression getFilterExpression(Type<?> var1, RequestScope var2);

    @Override
    public final boolean ok(T object, RequestScope requestScope, Optional<ChangeSpec> changeSpec) {
        EntityDictionary dictionary = FilterExpressionCheck.coreScope(requestScope).getDictionary();
        Type<?> entityClass = dictionary.lookupBoundClass(EntityDictionary.getType(object));
        FilterExpression filterExpression = this.getFilterExpression(entityClass, requestScope);
        return filterExpression.accept(new FilterExpressionCheckEvaluationVisitor(object, this, requestScope));
    }

    public boolean applyPredicateToObject(T object, FilterPredicate filterPredicate, RequestScope requestScope) {
        try {
            com.yahoo.elide.core.RequestScope scope = FilterExpressionCheck.coreScope(requestScope);
            Predicate<T> fn = filterPredicate.getOperator().contextualize(filterPredicate.getPath(), filterPredicate.getValues(), scope);
            return fn.test(object);
        }
        catch (Exception e) {
            log.error("Failed to apply predicate {}", (Object)filterPredicate, (Object)e);
            return false;
        }
    }

    @Override
    public final boolean runAtCommit() {
        return false;
    }

    protected Path getFieldPath(Type<?> type, RequestScope requestScope, String method, String defaultPath) {
        EntityDictionary dictionary = FilterExpressionCheck.coreScope(requestScope).getDictionary();
        try {
            FilterExpressionPath fep = FilterExpressionCheck.getFilterExpressionPath(type, method, dictionary);
            return new Path(type, dictionary, fep == null ? defaultPath : fep.value());
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private static FilterExpressionPath getFilterExpressionPath(Type<?> type, String method, EntityDictionary dictionary) throws NoSuchMethodException {
        FilterExpressionPath path = dictionary.lookupBoundClass(type).getMethod(method, new Type[0]).getAnnotation(FilterExpressionPath.class);
        return path;
    }

    protected static com.yahoo.elide.core.RequestScope coreScope(RequestScope requestScope) {
        return (com.yahoo.elide.core.RequestScope)requestScope;
    }
}

