/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.parser.state;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.exceptions.UnknownEntityException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.document.processors.IncludedProcessor;
import com.yahoo.elide.jsonapi.document.processors.PopulateMetaProcessor;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Meta;
import com.yahoo.elide.jsonapi.models.Relationship;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.parser.state.BaseState;
import com.yahoo.elide.jsonapi.parser.state.StateContext;
import io.reactivex.Observable;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CollectionTerminalState
extends BaseState {
    private final Optional<PersistentResource> parent;
    private final Optional<String> relationName;
    private final Type<?> entityClass;
    private PersistentResource newObject;
    private final EntityProjection parentProjection;

    public CollectionTerminalState(Type<?> entityClass, Optional<PersistentResource> parent, Optional<String> relationName, EntityProjection projection) {
        this.parentProjection = projection;
        this.parent = parent;
        this.relationName = relationName;
        this.entityClass = entityClass;
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handleGet(StateContext state) {
        JsonApiDocument jsonApiDocument = new JsonApiDocument();
        RequestScope requestScope = state.getRequestScope();
        MultivaluedMap<String, String> queryParams = requestScope.getQueryParams();
        LinkedHashSet collection = (LinkedHashSet)this.getResourceCollection(requestScope).toList(LinkedHashSet::new).blockingGet();
        jsonApiDocument.setData(this.getData(collection, requestScope.getDictionary()));
        IncludedProcessor includedProcessor = new IncludedProcessor();
        includedProcessor.execute(jsonApiDocument, requestScope, collection, queryParams);
        Pagination pagination = this.parentProjection.getPagination();
        if (this.parent.isPresent()) {
            pagination = this.parentProjection.getRelationship(this.relationName.orElseThrow(IllegalStateException::new)).get().getProjection().getPagination();
        }
        if (!pagination.isDefaultInstance()) {
            HashMap<String, Number> pageMetaData = new HashMap<String, Number>();
            pageMetaData.put("number", pagination.getOffset() / pagination.getLimit() + 1);
            pageMetaData.put("limit", pagination.getLimit());
            if (pagination.returnPageTotals()) {
                Long totalRecords = pagination.getPageTotals();
                pageMetaData.put("totalPages", totalRecords / (long)pagination.getLimit() + (long)(totalRecords % (long)pagination.getLimit() > 0L ? 1 : 0));
                pageMetaData.put("totalRecords", totalRecords);
            }
            HashMap<String, Object> allMetaData = new HashMap<String, Object>();
            allMetaData.put("page", pageMetaData);
            Meta meta = new Meta(allMetaData);
            jsonApiDocument.setMeta(meta);
        }
        PopulateMetaProcessor metaProcessor = new PopulateMetaProcessor();
        metaProcessor.execute(jsonApiDocument, requestScope, collection, queryParams);
        return () -> Pair.of((Object)200, (Object)jsonApiDocument);
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handlePost(StateContext state) {
        RequestScope requestScope = state.getRequestScope();
        JsonApiMapper mapper = requestScope.getMapper();
        this.newObject = this.createObject(requestScope);
        this.parent.ifPresent(persistentResource -> persistentResource.addRelation(this.relationName.get(), this.newObject));
        return () -> {
            JsonApiDocument returnDoc = new JsonApiDocument();
            returnDoc.setData(new Data<Resource>(this.newObject.toResource()));
            PopulateMetaProcessor metaProcessor = new PopulateMetaProcessor();
            metaProcessor.execute(returnDoc, requestScope, this.newObject, requestScope.getQueryParams());
            return Pair.of((Object)201, (Object)returnDoc);
        };
    }

    private Observable<PersistentResource> getResourceCollection(RequestScope requestScope) {
        Observable<PersistentResource> collection = this.parent.isPresent() ? this.parent.get().getRelationCheckedFiltered(this.parentProjection.getRelationship(this.relationName.orElseThrow(IllegalStateException::new)).orElseThrow(IllegalStateException::new)) : PersistentResource.loadRecords(this.parentProjection, new ArrayList<String>(), requestScope);
        return collection;
    }

    private Data getData(Set<PersistentResource> collection, EntityDictionary dictionary) {
        Preconditions.checkNotNull(collection);
        List resources = collection.stream().map(PersistentResource::toResource).collect(Collectors.toList());
        if (this.parent.isPresent()) {
            Type parentClass = this.parent.get().getResourceType();
            String relationshipName = this.relationName.orElseThrow(IllegalStateException::new);
            RelationshipType type = dictionary.getRelationshipType(parentClass, relationshipName);
            return new Data(resources, type);
        }
        return new Data(resources);
    }

    private PersistentResource createObject(RequestScope requestScope) throws ForbiddenAccessException, InvalidObjectIdentifierException {
        Map<String, Relationship> relationships;
        Resource resource;
        JsonApiDocument doc = requestScope.getJsonApiDocument();
        JsonApiMapper mapper = requestScope.getMapper();
        if (doc.getData() == null) {
            throw new InvalidEntityBodyException("Invalid JSON-API document: " + doc);
        }
        Data<Resource> data = doc.getData();
        Collection<Resource> resources = data.get();
        Resource resource2 = resource = resources.size() == 1 ? (Resource)IterableUtils.first(resources) : null;
        if (resource == null) {
            try {
                throw new InvalidEntityBodyException(mapper.writeJsonApiDocument(doc));
            }
            catch (JsonProcessingException e) {
                throw new InternalServerErrorException(e);
            }
        }
        String id = resource.getId();
        Type<?> newObjectClass = requestScope.getDictionary().getEntityClass(resource.getType(), requestScope.getApiVersion());
        if (newObjectClass == null) {
            throw new UnknownEntityException("Entity " + resource.getType() + " not found");
        }
        if (!this.entityClass.isAssignableFrom(newObjectClass)) {
            throw new InvalidValueException((Object)("Cannot assign value of type: " + resource.getType() + " to type: " + this.entityClass));
        }
        PersistentResource<?> pResource = PersistentResource.createObject(this.parent.orElse(null), this.relationName.orElse(null), newObjectClass, requestScope, Optional.ofNullable(id));
        Map<String, Object> attributes = resource.getAttributes();
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String fieldName = entry.getKey();
                Object val = entry.getValue();
                pResource.updateAttribute(fieldName, val);
            }
        }
        if ((relationships = resource.getRelationships()) != null) {
            for (Map.Entry<String, Relationship> entry : relationships.entrySet()) {
                String fieldName = entry.getKey();
                Relationship relationship = entry.getValue();
                Set<PersistentResource> resourceSet = relationship == null ? null : relationship.toPersistentResources(requestScope);
                pResource.updateRelation(fieldName, resourceSet);
            }
        }
        return pResource;
    }

    public String toString() {
        return "CollectionTerminalState(parent=" + this.parent + ", relationName=" + this.relationName + ", entityClass=" + this.entityClass + ", newObject=" + this.newObject + ", parentProjection=" + this.parentProjection + ")";
    }
}

