/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.parser.state;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Relationship;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.parser.state.BaseState;
import com.yahoo.elide.jsonapi.parser.state.CollectionTerminalState;
import com.yahoo.elide.jsonapi.parser.state.StateContext;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;

public class RecordTerminalState
extends BaseState {
    private final PersistentResource record;
    private final Optional<CollectionTerminalState> collectionTerminalState;

    public RecordTerminalState(PersistentResource record) {
        this(record, null);
    }

    public RecordTerminalState(PersistentResource record, CollectionTerminalState collectionTerminalState) {
        this.record = record;
        this.collectionTerminalState = Optional.ofNullable(collectionTerminalState);
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handleGet(StateContext state) {
        ObjectMapper mapper = state.getRequestScope().getMapper().getObjectMapper();
        return () -> Pair.of((Object)200, (Object)RecordTerminalState.getResponseBody(this.record, state.getRequestScope()));
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handlePost(StateContext state) {
        return this.collectionTerminalState.orElseThrow(() -> new InvalidOperationException("Cannot POST to a record.")).handlePost(state);
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handlePatch(StateContext state) {
        JsonApiDocument jsonApiDocument = state.getJsonApiDocument();
        Data<Resource> data = jsonApiDocument.getData();
        if (data == null) {
            throw new InvalidEntityBodyException("Expected data but found null");
        }
        if (!data.isToOne()) {
            throw new InvalidEntityBodyException("Expected single element but found list");
        }
        Resource resource = data.getSingleValue();
        if (!this.record.matchesId(resource.getId())) {
            throw new InvalidEntityBodyException("Id in response body does not match requested id to update from path");
        }
        this.patch(resource, state.getRequestScope());
        return RecordTerminalState.constructPatchResponse(this.record, state);
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handleDelete(StateContext state) {
        this.record.deleteResource();
        return () -> Pair.of((Object)204, null);
    }

    private boolean patch(Resource resource, RequestScope requestScope) {
        Map<String, Relationship> relationships;
        boolean isUpdated = false;
        Map<String, Object> attributes = resource.getAttributes();
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String fieldName = entry.getKey();
                Object newVal = entry.getValue();
                isUpdated |= this.record.updateAttribute(fieldName, newVal);
            }
        }
        if ((relationships = resource.getRelationships()) != null) {
            for (Map.Entry<String, Relationship> entry : relationships.entrySet()) {
                String fieldName = entry.getKey();
                Relationship relationship = entry.getValue();
                Set<PersistentResource> resources = relationship == null ? null : relationship.toPersistentResources(requestScope);
                isUpdated |= this.record.updateRelation(fieldName, resources);
            }
        }
        return isUpdated;
    }

    public String toString() {
        return "RecordTerminalState(record=" + this.record + ", collectionTerminalState=" + this.collectionTerminalState + ")";
    }
}

