/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.resources;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.annotation.PATCH;
import com.yahoo.elide.jsonapi.resources.SecurityContextUser;
import com.yahoo.elide.utils.HeaderUtils;
import com.yahoo.elide.utils.ResourceUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

@Singleton
@Produces(value={"application/vnd.api+json"})
@Path(value="/")
public class JsonApiEndpoint {
    protected final Elide elide;
    protected final HeaderUtils.HeaderProcessor headerProcessor;

    @Inject
    public JsonApiEndpoint(@Named(value="elide") Elide elide) {
        this.elide = elide;
        this.headerProcessor = elide.getElideSettings().getHeaderProcessor();
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"application/vnd.api+json"})
    public Response post(@PathParam(value="path") String path, @Context UriInfo uriInfo, @Context HttpHeaders headers, @Context SecurityContext securityContext, String jsonapiDocument) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        String apiVersion = HeaderUtils.resolveApiVersion((Map<String, List<String>>)headers.getRequestHeaders());
        Map<String, List<String>> requestHeaders = this.headerProcessor.process((Map<String, List<String>>)headers.getRequestHeaders());
        SecurityContextUser user = new SecurityContextUser(securityContext);
        return JsonApiEndpoint.build(this.elide.post(this.getBaseUrlEndpoint(uriInfo), path, jsonapiDocument, (MultivaluedMap<String, String>)queryParams, requestHeaders, user, apiVersion, UUID.randomUUID()));
    }

    @GET
    @Path(value="{path:.*}")
    public Response get(@PathParam(value="path") String path, @Context UriInfo uriInfo, @Context HttpHeaders headers, @Context SecurityContext securityContext) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        String apiVersion = HeaderUtils.resolveApiVersion((Map<String, List<String>>)headers.getRequestHeaders());
        Map<String, List<String>> requestHeaders = this.headerProcessor.process((Map<String, List<String>>)headers.getRequestHeaders());
        SecurityContextUser user = new SecurityContextUser(securityContext);
        return JsonApiEndpoint.build(this.elide.get(this.getBaseUrlEndpoint(uriInfo), path, (MultivaluedMap<String, String>)queryParams, requestHeaders, user, apiVersion, UUID.randomUUID()));
    }

    @PATCH
    @Path(value="{path:.*}")
    @Consumes(value={"application/vnd.api+json"})
    public Response patch(@HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="accept") String accept, @PathParam(value="path") String path, @Context UriInfo uriInfo, @Context HttpHeaders headers, @Context SecurityContext securityContext, String jsonapiDocument) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        String apiVersion = HeaderUtils.resolveApiVersion((Map<String, List<String>>)headers.getRequestHeaders());
        Map<String, List<String>> requestHeaders = this.headerProcessor.process((Map<String, List<String>>)headers.getRequestHeaders());
        SecurityContextUser user = new SecurityContextUser(securityContext);
        return JsonApiEndpoint.build(this.elide.patch(this.getBaseUrlEndpoint(uriInfo), contentType, accept, path, jsonapiDocument, (MultivaluedMap<String, String>)queryParams, requestHeaders, user, apiVersion, UUID.randomUUID()));
    }

    @DELETE
    @Path(value="{path:.*}")
    @Consumes(value={"application/vnd.api+json"})
    public Response delete(@PathParam(value="path") String path, @Context UriInfo uriInfo, @Context HttpHeaders headers, @Context SecurityContext securityContext, String jsonApiDocument) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        String apiVersion = HeaderUtils.resolveApiVersion((Map<String, List<String>>)headers.getRequestHeaders());
        Map<String, List<String>> requestHeaders = this.headerProcessor.process((Map<String, List<String>>)headers.getRequestHeaders());
        SecurityContextUser user = new SecurityContextUser(securityContext);
        return JsonApiEndpoint.build(this.elide.delete(this.getBaseUrlEndpoint(uriInfo), path, jsonApiDocument, (MultivaluedMap<String, String>)queryParams, requestHeaders, user, apiVersion, UUID.randomUUID()));
    }

    private static Response build(ElideResponse response) {
        return Response.status((int)response.getResponseCode()).entity((Object)response.getBody()).build();
    }

    protected String getBaseUrlEndpoint(UriInfo uriInfo) {
        String baseUrl = this.elide.getElideSettings().getBaseUrl();
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            baseUrl = ResourceUtils.resolveBaseUrl(uriInfo);
        }
        return baseUrl;
    }
}

