/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.TransactionRegistry;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.datastore.inmemory.InMemoryDataStore;
import com.yahoo.elide.core.dictionary.Injector;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.CustomErrorException;
import com.yahoo.elide.core.exceptions.ErrorMapper;
import com.yahoo.elide.core.exceptions.ErrorObjects;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.exceptions.InvalidURLException;
import com.yahoo.elide.core.exceptions.JsonPatchExtensionException;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.jsonapi.EntityProjectionMaker;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.extensions.JsonApiPatch;
import com.yahoo.elide.jsonapi.extensions.PatchRequestScope;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.parser.BaseVisitor;
import com.yahoo.elide.jsonapi.parser.DeleteVisitor;
import com.yahoo.elide.jsonapi.parser.GetVisitor;
import com.yahoo.elide.jsonapi.parser.JsonApiParser;
import com.yahoo.elide.jsonapi.parser.PatchVisitor;
import com.yahoo.elide.jsonapi.parser.PostVisitor;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Elide {
    private static final Logger log = LoggerFactory.getLogger(Elide.class);
    public static final String JSONAPI_CONTENT_TYPE = "application/vnd.api+json";
    public static final String JSONAPI_CONTENT_TYPE_WITH_JSON_PATCH_EXTENSION = "application/vnd.api+json; ext=jsonpatch";
    private final ElideSettings elideSettings;
    private final AuditLogger auditLogger;
    private final DataStore dataStore;
    private final JsonApiMapper mapper;
    private final ErrorMapper errorMapper;
    private final TransactionRegistry transactionRegistry;
    private final ClassScanner scanner;
    private boolean initialized = false;

    public Elide(ElideSettings elideSettings) {
        this(elideSettings, new TransactionRegistry(), elideSettings.getDictionary().getScanner(), false);
    }

    public Elide(ElideSettings elideSettings, TransactionRegistry transactionRegistry) {
        this(elideSettings, transactionRegistry, elideSettings.getDictionary().getScanner(), false);
    }

    public Elide(ElideSettings elideSettings, TransactionRegistry transactionRegistry, ClassScanner scanner, boolean doScans) {
        this.elideSettings = elideSettings;
        this.scanner = scanner;
        this.auditLogger = elideSettings.getAuditLogger();
        this.dataStore = new InMemoryDataStore(elideSettings.getDataStore());
        this.mapper = elideSettings.getMapper();
        this.errorMapper = elideSettings.getErrorMapper();
        this.transactionRegistry = transactionRegistry;
        if (doScans) {
            this.doScans();
        }
    }

    public void doScans() {
        if (!this.initialized) {
            this.elideSettings.getSerdes().forEach((type, serde) -> this.registerCustomSerde((Class<?>)type, (Serde)serde, type.getSimpleName()));
            this.registerCustomSerde();
            this.elideSettings.getDictionary().scanForSecurityChecks();
            this.dataStore.populateEntityDictionary(this.elideSettings.getDictionary());
            this.initialized = true;
        }
    }

    protected void registerCustomSerde() {
        Injector injector = this.elideSettings.getDictionary().getInjector();
        Set<Class<?>> classes = this.registerCustomSerdeScan();
        for (Class<?> clazz : classes) {
            if (!Serde.class.isAssignableFrom(clazz)) {
                log.warn("Skipping Serde registration (not a Serde!): {}", clazz);
                continue;
            }
            Serde serde = (Serde)injector.instantiate(clazz);
            injector.inject(serde);
            ElideTypeConverter converter = clazz.getAnnotation(ElideTypeConverter.class);
            Class<?> baseType = converter.type();
            this.registerCustomSerde(baseType, serde, converter.name());
            for (Class<?> type : converter.subTypes()) {
                if (!baseType.isAssignableFrom(type)) {
                    throw new IllegalArgumentException("Mentioned type " + type + " not subtype of " + baseType);
                }
                this.registerCustomSerde(type, serde, converter.name());
            }
        }
    }

    protected void registerCustomSerde(Class<?> type, Serde serde, String name) {
        log.info("Registering serde for type : {}", type);
        CoerceUtil.register(type, serde);
        this.registerCustomSerdeInObjectMapper(type, serde, name);
    }

    protected void registerCustomSerdeInObjectMapper(Class<?> type, final Serde serde, String name) {
        ObjectMapper objectMapper = this.mapper.getObjectMapper();
        objectMapper.registerModule((Module)new SimpleModule(name).addSerializer(type, (JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                jsonGenerator.writeObject(serde.serialize(obj));
            }
        }));
    }

    protected Set<Class<?>> registerCustomSerdeScan() {
        return this.scanner.getAnnotatedClasses(ElideTypeConverter.class);
    }

    public ElideResponse get(String baseUrlEndPoint, String path, MultivaluedMap<String, String> queryParams, User opaqueUser, String apiVersion) {
        return this.get(baseUrlEndPoint, path, queryParams, opaqueUser, apiVersion, UUID.randomUUID());
    }

    public ElideResponse get(String baseUrlEndPoint, String path, MultivaluedMap<String, String> queryParams, User opaqueUser, String apiVersion, UUID requestId) {
        return this.get(baseUrlEndPoint, path, queryParams, Collections.emptyMap(), opaqueUser, apiVersion, requestId);
    }

    public ElideResponse get(String baseUrlEndPoint, String path, MultivaluedMap<String, String> queryParams, Map<String, List<String>> requestHeaders, User opaqueUser, String apiVersion, UUID requestId) {
        if (this.elideSettings.isStrictQueryParams()) {
            try {
                this.verifyQueryParams(queryParams);
            }
            catch (BadRequestException e) {
                return this.buildErrorResponse(e, false);
            }
        }
        return this.handleRequest(true, opaqueUser, this.dataStore::beginReadTransaction, requestId, (tx, user) -> {
            JsonApiDocument jsonApiDoc = new JsonApiDocument();
            RequestScope requestScope = new RequestScope(baseUrlEndPoint, path, apiVersion, jsonApiDoc, (DataStoreTransaction)tx, (User)user, queryParams, requestHeaders, requestId, this.elideSettings);
            requestScope.setEntityProjection(new EntityProjectionMaker(this.elideSettings.getDictionary(), requestScope).parsePath(path));
            GetVisitor visitor = new GetVisitor(requestScope);
            return this.visit(path, requestScope, visitor);
        });
    }

    public ElideResponse post(String baseUrlEndPoint, String path, String jsonApiDocument, User opaqueUser, String apiVersion) {
        return this.post(baseUrlEndPoint, path, jsonApiDocument, null, opaqueUser, apiVersion, UUID.randomUUID());
    }

    public ElideResponse post(String baseUrlEndPoint, String path, String jsonApiDocument, MultivaluedMap<String, String> queryParams, User opaqueUser, String apiVersion, UUID requestId) {
        return this.post(baseUrlEndPoint, path, jsonApiDocument, queryParams, Collections.emptyMap(), opaqueUser, apiVersion, requestId);
    }

    public ElideResponse post(String baseUrlEndPoint, String path, String jsonApiDocument, MultivaluedMap<String, String> queryParams, Map<String, List<String>> requestHeaders, User opaqueUser, String apiVersion, UUID requestId) {
        return this.handleRequest(false, opaqueUser, this.dataStore::beginTransaction, requestId, (tx, user) -> {
            JsonApiDocument jsonApiDoc = this.mapper.readJsonApiDocument(jsonApiDocument);
            RequestScope requestScope = new RequestScope(baseUrlEndPoint, path, apiVersion, jsonApiDoc, (DataStoreTransaction)tx, (User)user, queryParams, requestHeaders, requestId, this.elideSettings);
            requestScope.setEntityProjection(new EntityProjectionMaker(this.elideSettings.getDictionary(), requestScope).parsePath(path));
            PostVisitor visitor = new PostVisitor(requestScope);
            return this.visit(path, requestScope, visitor);
        });
    }

    public ElideResponse patch(String baseUrlEndPoint, String contentType, String accept, String path, String jsonApiDocument, User opaqueUser, String apiVersion) {
        return this.patch(baseUrlEndPoint, contentType, accept, path, jsonApiDocument, null, opaqueUser, apiVersion, UUID.randomUUID());
    }

    public ElideResponse patch(String baseUrlEndPoint, String contentType, String accept, String path, String jsonApiDocument, MultivaluedMap<String, String> queryParams, User opaqueUser, String apiVersion, UUID requestId) {
        return this.patch(baseUrlEndPoint, contentType, accept, path, jsonApiDocument, queryParams, null, opaqueUser, apiVersion, requestId);
    }

    public ElideResponse patch(String baseUrlEndPoint, String contentType, String accept, String path, String jsonApiDocument, MultivaluedMap<String, String> queryParams, Map<String, List<String>> requestHeaders, User opaqueUser, String apiVersion, UUID requestId) {
        Handler<DataStoreTransaction, User, HandlerResult> handler = JsonApiPatch.isPatchExtension(contentType) && JsonApiPatch.isPatchExtension(accept) ? (tx, user) -> {
            PatchRequestScope requestScope = new PatchRequestScope(baseUrlEndPoint, path, apiVersion, (DataStoreTransaction)tx, (User)user, requestId, queryParams, requestHeaders, this.elideSettings);
            try {
                Supplier responder = JsonApiPatch.processJsonPatch(this.dataStore, path, jsonApiDocument, requestScope);
                return new HandlerResult((RequestScope)requestScope, responder);
            }
            catch (RuntimeException e) {
                return new HandlerResult((RequestScope)requestScope, e);
            }
        } : (tx, user) -> {
            JsonApiDocument jsonApiDoc = this.mapper.readJsonApiDocument(jsonApiDocument);
            RequestScope requestScope = new RequestScope(baseUrlEndPoint, path, apiVersion, jsonApiDoc, (DataStoreTransaction)tx, (User)user, queryParams, requestHeaders, requestId, this.elideSettings);
            requestScope.setEntityProjection(new EntityProjectionMaker(this.elideSettings.getDictionary(), requestScope).parsePath(path));
            PatchVisitor visitor = new PatchVisitor(requestScope);
            return this.visit(path, requestScope, visitor);
        };
        return this.handleRequest(false, opaqueUser, this.dataStore::beginTransaction, requestId, handler);
    }

    public ElideResponse delete(String baseUrlEndPoint, String path, String jsonApiDocument, User opaqueUser, String apiVersion) {
        return this.delete(baseUrlEndPoint, path, jsonApiDocument, null, opaqueUser, apiVersion, UUID.randomUUID());
    }

    public ElideResponse delete(String baseUrlEndPoint, String path, String jsonApiDocument, MultivaluedMap<String, String> queryParams, User opaqueUser, String apiVersion, UUID requestId) {
        return this.delete(baseUrlEndPoint, path, jsonApiDocument, queryParams, Collections.emptyMap(), opaqueUser, apiVersion, requestId);
    }

    public ElideResponse delete(String baseUrlEndPoint, String path, String jsonApiDocument, MultivaluedMap<String, String> queryParams, Map<String, List<String>> requestHeaders, User opaqueUser, String apiVersion, UUID requestId) {
        return this.handleRequest(false, opaqueUser, this.dataStore::beginTransaction, requestId, (tx, user) -> {
            JsonApiDocument jsonApiDoc = StringUtils.isEmpty((CharSequence)jsonApiDocument) ? new JsonApiDocument() : this.mapper.readJsonApiDocument(jsonApiDocument);
            RequestScope requestScope = new RequestScope(baseUrlEndPoint, path, apiVersion, jsonApiDoc, (DataStoreTransaction)tx, (User)user, queryParams, requestHeaders, requestId, this.elideSettings);
            requestScope.setEntityProjection(new EntityProjectionMaker(this.elideSettings.getDictionary(), requestScope).parsePath(path));
            DeleteVisitor visitor = new DeleteVisitor(requestScope);
            return this.visit(path, requestScope, visitor);
        });
    }

    public HandlerResult visit(String path, RequestScope requestScope, BaseVisitor visitor) {
        try {
            Supplier responder = (Supplier)visitor.visit(JsonApiParser.parse(path));
            return new HandlerResult(requestScope, responder);
        }
        catch (RuntimeException e) {
            return new HandlerResult(requestScope, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> ElideResponse handleRequest(boolean isReadOnly, User user, Supplier<DataStoreTransaction> transaction, UUID requestId, Handler<DataStoreTransaction, User, HandlerResult> handler) {
        boolean isVerbose = false;
        try {
            ElideResponse elideResponse;
            block15: {
                DataStoreTransaction tx = transaction.get();
                try {
                    this.transactionRegistry.addRunningTransaction(requestId, tx);
                    HandlerResult result = handler.handle(tx, user);
                    RequestScope requestScope = result.getRequestScope();
                    isVerbose = requestScope.getPermissionExecutor().isVerbose();
                    Supplier responder = result.getResponder();
                    tx.preCommit(requestScope);
                    requestScope.runQueuedPreSecurityTriggers();
                    requestScope.getPermissionExecutor().executeCommitChecks();
                    requestScope.runQueuedPreFlushTriggers();
                    if (!isReadOnly) {
                        requestScope.saveOrCreateObjects();
                    }
                    tx.flush(requestScope);
                    requestScope.runQueuedPreCommitTriggers();
                    ElideResponse response = this.buildResponse(responder.get());
                    this.auditLogger.commit();
                    tx.commit(requestScope);
                    requestScope.runQueuedPostCommitTriggers();
                    if (log.isTraceEnabled()) {
                        requestScope.getPermissionExecutor().logCheckStats();
                    }
                    elideResponse = response;
                    if (tx == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (tx != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        ElideResponse elideResponse2 = this.handleNonRuntimeException(e, isVerbose);
                        return elideResponse2;
                    }
                    catch (RuntimeException e) {
                        ElideResponse elideResponse3 = this.handleRuntimeException(e, isVerbose);
                        return elideResponse3;
                    }
                }
                tx.close();
            }
            return elideResponse;
        }
        finally {
            this.transactionRegistry.removeRunningTransaction(requestId);
            this.auditLogger.clear();
        }
    }

    protected ElideResponse buildErrorResponse(HttpStatusException error, boolean isVerbose) {
        if (error instanceof InternalServerErrorException) {
            log.error("Internal Server Error", (Throwable)error);
        }
        return this.buildResponse(isVerbose ? error.getVerboseErrorResponse() : error.getErrorResponse());
    }

    private ElideResponse handleNonRuntimeException(Exception error, boolean isVerbose) {
        CustomErrorException mappedException = this.mapError(error);
        if (mappedException != null) {
            return this.buildErrorResponse(mappedException, isVerbose);
        }
        if (error instanceof JacksonException) {
            JacksonException jacksonException = (JacksonException)error;
            String message = jacksonException.getLocation() != null && jacksonException.getLocation().getSourceRef() != null ? error.getMessage() : jacksonException.getOriginalMessage();
            return this.buildErrorResponse(new BadRequestException(message), isVerbose);
        }
        if (error instanceof IOException) {
            log.error("IO Exception uncaught by Elide", (Throwable)error);
            return this.buildErrorResponse(new TransactionException(error), isVerbose);
        }
        log.error("Error or exception uncaught by Elide", (Throwable)error);
        throw new RuntimeException(error);
    }

    private ElideResponse handleRuntimeException(RuntimeException error, boolean isVerbose) {
        CustomErrorException mappedException = this.mapError(error);
        if (mappedException != null) {
            return this.buildErrorResponse(mappedException, isVerbose);
        }
        if (error instanceof WebApplicationException) {
            throw error;
        }
        if (error instanceof ForbiddenAccessException) {
            ForbiddenAccessException e = (ForbiddenAccessException)error;
            if (log.isDebugEnabled()) {
                log.debug("{}", (Object)e.getLoggedMessage());
            }
            return this.buildErrorResponse(e, isVerbose);
        }
        if (error instanceof JsonPatchExtensionException) {
            JsonPatchExtensionException e = (JsonPatchExtensionException)error;
            log.debug("JSON patch extension exception caught", (Throwable)e);
            return this.buildErrorResponse(e, isVerbose);
        }
        if (error instanceof HttpStatusException) {
            HttpStatusException e = (HttpStatusException)error;
            log.debug("Caught HTTP status exception", (Throwable)e);
            return this.buildErrorResponse(e, isVerbose);
        }
        if (error instanceof ParseCancellationException) {
            ParseCancellationException e = (ParseCancellationException)error;
            log.debug("Parse cancellation exception uncaught by Elide (i.e. invalid URL)", (Throwable)e);
            return this.buildErrorResponse(new InvalidURLException((Exception)e), isVerbose);
        }
        if (error instanceof ConstraintViolationException) {
            ConstraintViolationException e = (ConstraintViolationException)error;
            log.debug("Constraint violation exception caught", (Throwable)e);
            String message = "Constraint violation";
            ErrorObjects.ErrorObjectsBuilder errorObjectsBuilder = ErrorObjects.builder();
            for (ConstraintViolation constraintViolation : e.getConstraintViolations()) {
                errorObjectsBuilder.addError().withDetail(constraintViolation.getMessage());
                String propertyPathString = constraintViolation.getPropertyPath().toString();
                if (propertyPathString.isEmpty()) continue;
                HashMap<String, String> source = new HashMap<String, String>(1);
                source.put("property", propertyPathString);
                errorObjectsBuilder.with("source", source);
            }
            return this.buildErrorResponse(new CustomErrorException(400, message, errorObjectsBuilder.build()), isVerbose);
        }
        log.error("Error or exception uncaught by Elide", (Throwable)error);
        throw new RuntimeException(error);
    }

    public CustomErrorException mapError(Exception error) {
        if (this.errorMapper != null) {
            log.trace("Attempting to map unknown exception of type {}", error.getClass());
            CustomErrorException customizedError = this.errorMapper.map(error);
            if (customizedError != null) {
                log.debug("Successfully mapped exception from type {} to {}", error.getClass(), customizedError.getClass());
                return customizedError;
            }
            log.debug("No error mapping present for {}", error.getClass());
        }
        return null;
    }

    protected <T> ElideResponse buildResponse(Pair<Integer, T> response) {
        try {
            Object responseNode = response.getRight();
            Integer responseCode = (Integer)response.getLeft();
            String body = responseNode == null ? null : this.mapper.writeJsonApiDocument(responseNode);
            return new ElideResponse(responseCode, body);
        }
        catch (JsonProcessingException e) {
            return new ElideResponse(500, e.toString());
        }
    }

    private void verifyQueryParams(MultivaluedMap<String, String> queryParams) {
        String undefinedKeys = queryParams.keySet().stream().filter(Elide::notAValidKey).collect(Collectors.joining(", "));
        if (!undefinedKeys.isEmpty()) {
            throw new BadRequestException("Found undefined keys in request: " + undefinedKeys);
        }
    }

    private static boolean notAValidKey(String key) {
        boolean validKey = key.equals("sort") || key.startsWith("filter") || key.startsWith("fields[") && key.endsWith("]") || key.startsWith("page[") || key.equals("include");
        return !validKey;
    }

    public ElideSettings getElideSettings() {
        return this.elideSettings;
    }

    public AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public JsonApiMapper getMapper() {
        return this.mapper;
    }

    public ErrorMapper getErrorMapper() {
        return this.errorMapper;
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    public ClassScanner getScanner() {
        return this.scanner;
    }

    @FunctionalInterface
    public static interface Handler<DataStoreTransaction, User, HandlerResult> {
        public HandlerResult handle(DataStoreTransaction var1, User var2) throws IOException;
    }

    protected static class HandlerResult<T> {
        protected RequestScope requestScope;
        protected Supplier<Pair<Integer, T>> result;
        protected RuntimeException cause;

        protected HandlerResult(RequestScope requestScope, Supplier<Pair<Integer, T>> result) {
            this.requestScope = requestScope;
            this.result = result;
        }

        public HandlerResult(RequestScope requestScope, RuntimeException cause) {
            this.requestScope = requestScope;
            this.cause = cause;
        }

        public Supplier<Pair<Integer, T>> getResponder() {
            if (this.cause != null) {
                throw this.cause;
            }
            return this.result;
        }

        public RequestScope getRequestScope() {
            return this.requestScope;
        }
    }
}

