/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.audit.Slf4jLogger;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.ErrorMapper;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.graphql.FilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.DefaultFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.SubqueryFilterDialect;
import com.yahoo.elide.core.security.PermissionExecutor;
import com.yahoo.elide.core.security.executors.ActivePermissionExecutor;
import com.yahoo.elide.core.security.executors.VerbosePermissionExecutor;
import com.yahoo.elide.core.utils.coerce.converters.EpochToDateConverter;
import com.yahoo.elide.core.utils.coerce.converters.ISO8601DateSerde;
import com.yahoo.elide.core.utils.coerce.converters.InstantSerde;
import com.yahoo.elide.core.utils.coerce.converters.OffsetDateTimeSerde;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.core.utils.coerce.converters.TimeZoneSerde;
import com.yahoo.elide.core.utils.coerce.converters.URLSerde;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.links.JSONApiLinks;
import com.yahoo.elide.utils.HeaderUtils;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;

public class ElideSettingsBuilder {
    private final DataStore dataStore;
    private AuditLogger auditLogger;
    private JsonApiMapper jsonApiMapper;
    private ErrorMapper errorMapper;
    private EntityDictionary entityDictionary;
    private Function<RequestScope, PermissionExecutor> permissionExecutorFunction = ActivePermissionExecutor::new;
    private List<JoinFilterDialect> joinFilterDialects;
    private List<SubqueryFilterDialect> subqueryFilterDialects;
    private FilterDialect graphqlFilterDialect;
    private JSONApiLinks jsonApiLinks;
    private HeaderUtils.HeaderProcessor headerProcessor;
    private Map<Class, Serde> serdes;
    private int defaultMaxPageSize = 10000;
    private int defaultPageSize = 500;
    private int updateStatusCode;
    private boolean enableJsonLinks;
    private boolean enableGraphQLFederation;
    private boolean strictQueryParams = true;
    private String baseUrl = "";
    private String jsonApiPath;
    private String graphQLApiPath;
    private String exportApiPath;

    public ElideSettingsBuilder(DataStore dataStore) {
        this.dataStore = dataStore;
        this.auditLogger = new Slf4jLogger();
        this.jsonApiMapper = new JsonApiMapper();
        this.joinFilterDialects = new ArrayList<JoinFilterDialect>();
        this.subqueryFilterDialects = new ArrayList<SubqueryFilterDialect>();
        this.headerProcessor = HeaderUtils::lowercaseAndRemoveAuthHeaders;
        this.updateStatusCode = 204;
        this.serdes = new LinkedHashMap<Class, Serde>();
        this.enableJsonLinks = false;
        this.enableGraphQLFederation = false;
        this.withEpochDates();
        this.withDefaultSerdes();
    }

    public ElideSettings build() {
        if (this.joinFilterDialects.isEmpty()) {
            this.joinFilterDialects.add(new DefaultFilterDialect(this.entityDictionary));
            this.joinFilterDialects.add(RSQLFilterDialect.builder().dictionary(this.entityDictionary).build());
        }
        if (this.subqueryFilterDialects.isEmpty()) {
            this.subqueryFilterDialects.add(new DefaultFilterDialect(this.entityDictionary));
            this.subqueryFilterDialects.add(RSQLFilterDialect.builder().dictionary(this.entityDictionary).build());
        }
        if (this.graphqlFilterDialect == null) {
            this.graphqlFilterDialect = RSQLFilterDialect.builder().dictionary(this.entityDictionary).build();
        }
        if (this.entityDictionary == null) {
            throw new IllegalStateException("EntityDictionary must be set in ElideSettings.");
        }
        return new ElideSettings(this.auditLogger, this.dataStore, this.entityDictionary, this.jsonApiMapper, this.errorMapper, this.permissionExecutorFunction, this.joinFilterDialects, this.subqueryFilterDialects, this.graphqlFilterDialect, this.jsonApiLinks, this.headerProcessor, this.defaultMaxPageSize, this.defaultPageSize, this.updateStatusCode, this.serdes, this.enableJsonLinks, this.strictQueryParams, this.enableGraphQLFederation, this.baseUrl, this.jsonApiPath, this.graphQLApiPath, this.exportApiPath);
    }

    public ElideSettingsBuilder withAuditLogger(AuditLogger auditLogger) {
        this.auditLogger = auditLogger;
        return this;
    }

    public ElideSettingsBuilder withEntityDictionary(EntityDictionary entityDictionary) {
        this.entityDictionary = entityDictionary;
        return this;
    }

    public ElideSettingsBuilder withJsonApiMapper(JsonApiMapper jsonApiMapper) {
        this.jsonApiMapper = jsonApiMapper;
        return this;
    }

    public ElideSettingsBuilder withErrorMapper(ErrorMapper errorMapper) {
        this.errorMapper = errorMapper;
        return this;
    }

    public ElideSettingsBuilder withJoinFilterDialect(JoinFilterDialect dialect) {
        this.joinFilterDialects.add(dialect);
        return this;
    }

    public ElideSettingsBuilder withSubqueryFilterDialect(SubqueryFilterDialect dialect) {
        this.subqueryFilterDialects.add(dialect);
        return this;
    }

    public ElideSettingsBuilder withDefaultMaxPageSize(int maxPageSize) {
        this.defaultMaxPageSize = maxPageSize;
        return this;
    }

    public ElideSettingsBuilder withDefaultPageSize(int pageSize) {
        this.defaultPageSize = pageSize;
        return this;
    }

    public ElideSettingsBuilder withUpdate200Status() {
        this.updateStatusCode = 200;
        return this;
    }

    public ElideSettingsBuilder withUpdate204Status() {
        this.updateStatusCode = 204;
        return this;
    }

    public ElideSettingsBuilder withBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public ElideSettingsBuilder withGraphQLDialect(FilterDialect dialect) {
        this.graphqlFilterDialect = dialect;
        return this;
    }

    public ElideSettingsBuilder withVerboseErrors() {
        this.permissionExecutorFunction = VerbosePermissionExecutor::new;
        return this;
    }

    public ElideSettingsBuilder withISO8601Dates(String dateFormat, TimeZone tz) {
        this.serdes.put(java.util.Date.class, new ISO8601DateSerde(dateFormat, tz));
        this.serdes.put(Date.class, new ISO8601DateSerde(dateFormat, tz, Date.class));
        this.serdes.put(Time.class, new ISO8601DateSerde(dateFormat, tz, Time.class));
        this.serdes.put(Timestamp.class, new ISO8601DateSerde(dateFormat, tz, Timestamp.class));
        return this;
    }

    public ElideSettingsBuilder withEpochDates() {
        this.serdes.put(java.util.Date.class, new EpochToDateConverter<java.util.Date>(java.util.Date.class));
        this.serdes.put(Date.class, new EpochToDateConverter<Date>(Date.class));
        this.serdes.put(Time.class, new EpochToDateConverter<Time>(Time.class));
        this.serdes.put(Timestamp.class, new EpochToDateConverter<Timestamp>(Timestamp.class));
        return this;
    }

    public ElideSettingsBuilder withDefaultSerdes() {
        this.serdes.put(Instant.class, new InstantSerde());
        this.serdes.put(OffsetDateTime.class, new OffsetDateTimeSerde());
        this.serdes.put(TimeZone.class, new TimeZoneSerde());
        this.serdes.put(URL.class, new URLSerde());
        return this;
    }

    public ElideSettingsBuilder withJSONApiLinks(JSONApiLinks links) {
        this.enableJsonLinks = true;
        this.jsonApiLinks = links;
        return this;
    }

    public ElideSettingsBuilder withHeaderProcessor(HeaderUtils.HeaderProcessor headerProcessor) {
        this.headerProcessor = headerProcessor;
        return this;
    }

    public ElideSettingsBuilder withJsonApiPath(String jsonApiPath) {
        this.jsonApiPath = jsonApiPath;
        return this;
    }

    public ElideSettingsBuilder withGraphQLApiPath(String graphQLApiPath) {
        this.graphQLApiPath = graphQLApiPath;
        return this;
    }

    public ElideSettingsBuilder withExportApiPath(String exportApiPath) {
        this.exportApiPath = exportApiPath;
        return this;
    }

    public ElideSettingsBuilder withStrictQueryParams(boolean enabled) {
        this.strictQueryParams = enabled;
        return this;
    }

    public ElideSettingsBuilder withGraphQLFederation(boolean enabled) {
        this.enableGraphQLFederation = enabled;
        return this;
    }
}

