/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.datastore.inmemory;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.InMemoryFilterExecutor;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilteredIterator<T>
implements Iterator<T> {
    private Iterator<T> wrapped;
    private Predicate<T> predicate;
    private T next;

    public FilteredIterator(FilterExpression filterExpression, RequestScope scope, Iterator<T> wrapped) {
        this.wrapped = wrapped;
        InMemoryFilterExecutor executor = new InMemoryFilterExecutor(scope);
        this.predicate = filterExpression.accept(executor);
    }

    @Override
    public boolean hasNext() {
        try {
            this.next = this.next();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (this.next != null) {
            T result = this.next;
            this.next = null;
            return result;
        }
        while (this.next == null && this.wrapped.hasNext()) {
            try {
                this.next = this.wrapped.next();
            }
            catch (NoSuchElementException e) {
                this.next = null;
            }
            if (this.next != null && this.predicate.test(this.next)) continue;
            this.next = null;
        }
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        return this.next;
    }
}

