/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.dialect;

import com.google.common.collect.ImmutableMap;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.ArgumentType;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.dialect.CaseSensitivityStrategy;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.dialect.graphql.FilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.SubqueryFilterDialect;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.filter.predicates.InInsensitivePredicate;
import com.yahoo.elide.core.filter.predicates.InPredicate;
import com.yahoo.elide.core.filter.predicates.IsEmptyPredicate;
import com.yahoo.elide.core.filter.predicates.IsNullPredicate;
import com.yahoo.elide.core.filter.predicates.NotEmptyPredicate;
import com.yahoo.elide.core.filter.predicates.NotNullPredicate;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.jsonapi.parser.JsonApiParser;
import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.RSQLParserException;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLOperators;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;

public class RSQLFilterDialect
implements FilterDialect,
SubqueryFilterDialect,
JoinFilterDialect {
    private static final String SINGLE_PARAMETER_ONLY = "There can only be a single filter query parameter";
    private static final String INVALID_QUERY_PARAMETER = "Invalid query parameter: ";
    private static final Pattern TYPED_FILTER_PATTERN = Pattern.compile("filter\\[([^\\]]+)\\]");
    private static final Pattern FILTER_SELECTOR_PATTERN = Pattern.compile("(\\w+)(" + Argument.ARGUMENTS_PATTERN + ")*$");
    private static final ComparisonOperator INI = new ComparisonOperator("=ini=", true);
    private static final ComparisonOperator NOT_INI = new ComparisonOperator("=outi=", true);
    private static final ComparisonOperator ISNULL_OP = new ComparisonOperator("=isnull=", false);
    private static final ComparisonOperator ISEMPTY_OP = new ComparisonOperator("=isempty=", false);
    private static final ComparisonOperator HASMEMBER_OP = new ComparisonOperator("=hasmember=", false);
    private static final ComparisonOperator HASNOMEMBER_OP = new ComparisonOperator("=hasnomember=", false);
    private static final ComparisonOperator BETWEEN_OP = new ComparisonOperator("=between=", true);
    private static final ComparisonOperator NOTBETWEEN_OP = new ComparisonOperator("=notbetween=", true);
    private static final Map<ComparisonOperator, Operator> OPERATOR_MAP = ImmutableMap.builder().put((Object)RSQLOperators.LESS_THAN, (Object)Operator.LT).put((Object)RSQLOperators.GREATER_THAN, (Object)Operator.GT).put((Object)RSQLOperators.GREATER_THAN_OR_EQUAL, (Object)Operator.GE).put((Object)RSQLOperators.LESS_THAN_OR_EQUAL, (Object)Operator.LE).put((Object)HASMEMBER_OP, (Object)Operator.HASMEMBER).put((Object)HASNOMEMBER_OP, (Object)Operator.HASNOMEMBER).put((Object)BETWEEN_OP, (Object)Operator.BETWEEN).put((Object)NOTBETWEEN_OP, (Object)Operator.NOTBETWEEN).build();
    private final RSQLParser parser = new RSQLParser(RSQLFilterDialect.getDefaultOperatorsWithIsnull());
    @NonNull
    private final EntityDictionary dictionary;
    private final CaseSensitivityStrategy caseSensitivityStrategy;
    private final Boolean addDefaultArguments;

    public RSQLFilterDialect(EntityDictionary dictionary, CaseSensitivityStrategy caseSensitivityStrategy, Boolean addDefaultArguments) {
        this.dictionary = dictionary;
        this.caseSensitivityStrategy = caseSensitivityStrategy == null ? new CaseSensitivityStrategy.UseColumnCollation() : caseSensitivityStrategy;
        this.addDefaultArguments = addDefaultArguments == null ? Boolean.valueOf(true) : addDefaultArguments;
    }

    public static final Set<ComparisonOperator> getDefaultOperatorsWithIsnull() {
        Set operators = RSQLOperators.defaultOperators();
        operators.add(INI);
        operators.add(NOT_INI);
        operators.add(ISNULL_OP);
        operators.add(ISEMPTY_OP);
        operators.add(HASMEMBER_OP);
        operators.add(HASNOMEMBER_OP);
        operators.add(BETWEEN_OP);
        operators.add(NOTBETWEEN_OP);
        return operators;
    }

    @Override
    public FilterExpression parse(Type<?> entityClass, Set<Attribute> attributes, String filterText, String apiVersion) throws ParseException {
        return this.parseFilterExpression(filterText, entityClass, true, true, attributes);
    }

    @Override
    public FilterExpression parseGlobalExpression(String path, MultivaluedMap<String, String> filterParams, String apiVersion) throws ParseException {
        if (filterParams.size() != 1) {
            throw new ParseException(SINGLE_PARAMETER_ONLY);
        }
        Map.Entry entry = CollectionUtils.get(filterParams, (int)0);
        String queryParamName = (String)entry.getKey();
        if (!"filter".equals(queryParamName)) {
            throw new ParseException(INVALID_QUERY_PARAMETER + queryParamName);
        }
        List queryParamValues = (List)entry.getValue();
        if (queryParamValues.size() != 1) {
            throw new ParseException(SINGLE_PARAMETER_ONLY);
        }
        String queryParamValue = (String)queryParamValues.get(0);
        String normalizedPath = JsonApiParser.normalizePath(path);
        String[] pathComponents = normalizedPath.split("/");
        String lastPathComponent = pathComponents.length > 0 ? pathComponents[pathComponents.length - 1] : "";
        Type<?> entityType = this.dictionary.getEntityClass(lastPathComponent, apiVersion);
        if (entityType == null) {
            throw new ParseException("No such collection: " + lastPathComponent);
        }
        return this.parseFilterExpression(queryParamValue, entityType, true);
    }

    @Override
    public Map<String, FilterExpression> parseTypedExpression(String path, MultivaluedMap<String, String> filterParams, String apiVersion) throws ParseException {
        HashMap<String, FilterExpression> expressionByType = new HashMap<String, FilterExpression>();
        for (Map.Entry entry : filterParams.entrySet()) {
            String paramName = (String)entry.getKey();
            List paramValues = (List)entry.getValue();
            Matcher matcher = TYPED_FILTER_PATTERN.matcher(paramName);
            if (matcher.find()) {
                String typeName = matcher.group(1);
                if (paramValues.size() != 1) {
                    throw new ParseException("Exactly one RSQL expression must be defined for type : " + typeName);
                }
                Type<?> entityType = this.dictionary.getEntityClass(typeName, apiVersion);
                if (entityType == null) {
                    throw new ParseException(INVALID_QUERY_PARAMETER + paramName);
                }
                String expressionText = (String)paramValues.get(0);
                FilterExpression filterExpression = this.parseFilterExpression(expressionText, entityType, true);
                expressionByType.put(typeName, filterExpression);
                continue;
            }
            throw new ParseException(INVALID_QUERY_PARAMETER + paramName);
        }
        return expressionByType;
    }

    public FilterExpression parseFilterExpression(String expressionText, Type<?> entityType, boolean allowNestedToManyAssociations) throws ParseException {
        return this.parseFilterExpression(expressionText, entityType, true, allowNestedToManyAssociations);
    }

    public FilterExpression parseFilterExpression(String expressionText, Type<?> entityType, boolean coerceValues, boolean allowNestedToManyAssociations) throws ParseException {
        return this.parseFilterExpression(expressionText, entityType, coerceValues, allowNestedToManyAssociations, Collections.emptySet());
    }

    public FilterExpression parseFilterExpression(String expressionText, Type<?> entityType, boolean coerceValues, boolean allowNestedToManyAssociations, Set<Attribute> attributes) throws ParseException {
        try {
            Node ast = this.parser.parse(expressionText);
            RSQL2FilterExpressionVisitor visitor = new RSQL2FilterExpressionVisitor(allowNestedToManyAssociations, coerceValues, attributes);
            return (FilterExpression)ast.accept((RSQLVisitor)visitor, entityType);
        }
        catch (RSQLParserException e) {
            throw new ParseException(e.getMessage());
        }
    }

    public static RSQLFilterDialectBuilder builder() {
        return new RSQLFilterDialectBuilder();
    }

    public class RSQL2FilterExpressionVisitor
    implements RSQLVisitor<FilterExpression, Type> {
        private boolean allowNestedToManyAssociations = false;
        private boolean coerceValues = true;
        private Set<Attribute> attributes;

        public RSQL2FilterExpressionVisitor(boolean allowNestedToManyAssociations) {
            this(allowNestedToManyAssociations, true, Collections.emptySet());
        }

        public RSQL2FilterExpressionVisitor(boolean allowNestedToManyAssociations, boolean coerceValues, Set<Attribute> attributes) {
            this.allowNestedToManyAssociations = allowNestedToManyAssociations;
            this.coerceValues = coerceValues;
            this.attributes = attributes;
        }

        private Path buildAttribute(Type rootEntityType, String attributeName) {
            Attribute attribute = this.attributes.stream().filter(attr -> attr.getName().equals(attributeName) || attr.getAlias().equals(attributeName)).findFirst().orElse(null);
            if (attribute != null) {
                return new Path(rootEntityType, RSQLFilterDialect.this.dictionary, attribute.getName(), attribute.getAlias(), attribute.getArguments());
            }
            return this.buildPath(rootEntityType, attributeName);
        }

        private Path buildPath(Type rootEntityType, String selector) {
            String[] associationNames = selector.split("\\.");
            ArrayList<Path.PathElement> path = new ArrayList<Path.PathElement>();
            Type<?> entityType = rootEntityType;
            for (String associationName : associationNames) {
                HashSet<Argument> arguments;
                int argsIndex;
                if (!FILTER_SELECTOR_PATTERN.matcher(associationName).matches()) {
                    throw new RSQLParseException("Filter expression is not in expected format at: " + associationName);
                }
                if (associationName.equals("id")) {
                    associationName = RSQLFilterDialect.this.dictionary.getIdFieldName(entityType);
                }
                if ((argsIndex = associationName.indexOf(91)) > 0) {
                    try {
                        arguments = Argument.getArgumentsFromString(associationName.substring(argsIndex));
                    }
                    catch (UnsupportedEncodingException | IllegalArgumentException e) {
                        throw new RSQLParseException(String.format("Filter expression is not in expected format at: %s. %s", associationName, e.getMessage()));
                    }
                    associationName = associationName.substring(0, argsIndex);
                } else {
                    arguments = new HashSet();
                }
                if (RSQLFilterDialect.this.addDefaultArguments.booleanValue()) {
                    this.addDefaultArguments(arguments, RSQLFilterDialect.this.dictionary.getAttributeArguments(entityType, associationName));
                }
                String typeName = RSQLFilterDialect.this.dictionary.getJsonAliasFor(entityType);
                Type<?> fieldType = RSQLFilterDialect.this.dictionary.getParameterizedType(entityType, associationName);
                if (fieldType == null) {
                    throw new RSQLParseException(String.format("No such association %s for type %s", associationName, typeName));
                }
                path.add(new Path.PathElement(entityType, fieldType, associationName, associationName, arguments));
                entityType = fieldType;
            }
            return new Path(path);
        }

        private void addDefaultArguments(Set<Argument> clientArguments, Set<ArgumentType> availableArgTypes) {
            Set clientArgNames = clientArguments.stream().map(Argument::getName).collect(Collectors.toSet());
            availableArgTypes.stream().filter(argType -> !clientArgNames.contains(argType.getName())).filter(argType -> argType.getDefaultValue() != null).map(argType -> Argument.builder().name(argType.getName()).value(argType.getDefaultValue()).build()).forEach(clientArguments::add);
        }

        public FilterExpression visit(AndNode node, Type entityType) {
            List children = node.getChildren();
            if (children.size() < 2) {
                throw new RSQLParseException("Logical AND requires two arguments");
            }
            FilterExpression left = (FilterExpression)((Node)children.get(0)).accept((RSQLVisitor)this, (Object)entityType);
            FilterExpression right = (FilterExpression)((Node)children.get(1)).accept((RSQLVisitor)this, (Object)entityType);
            AndFilterExpression andFilterExpression = new AndFilterExpression(left, right);
            for (int idx = 2; idx < children.size(); ++idx) {
                right = (FilterExpression)((Node)children.get(idx)).accept((RSQLVisitor)this, (Object)entityType);
                andFilterExpression = new AndFilterExpression(andFilterExpression, right);
            }
            return andFilterExpression;
        }

        public FilterExpression visit(OrNode node, Type entityType) {
            List children = node.getChildren();
            if (children.size() < 2) {
                throw new RSQLParseException("Logical OR requires two arguments");
            }
            FilterExpression left = (FilterExpression)((Node)children.get(0)).accept((RSQLVisitor)this, (Object)entityType);
            FilterExpression right = (FilterExpression)((Node)children.get(1)).accept((RSQLVisitor)this, (Object)entityType);
            OrFilterExpression orFilterExpression = new OrFilterExpression(left, right);
            for (int idx = 2; idx < children.size(); ++idx) {
                right = (FilterExpression)((Node)children.get(idx)).accept((RSQLVisitor)this, (Object)entityType);
                orFilterExpression = new OrFilterExpression(orFilterExpression, right);
            }
            return orFilterExpression;
        }

        public FilterExpression visit(ComparisonNode node, Type entityType) {
            ComparisonOperator op = node.getOperator();
            String relationship = node.getSelector();
            List arguments = node.getArguments();
            Path path = relationship.contains(".") || relationship.contains("[") ? this.buildPath(entityType, relationship) : this.buildAttribute(entityType, relationship);
            if (op.equals((Object)ISEMPTY_OP)) {
                if (FilterPredicate.toManyInPathExceptLastPathElement(RSQLFilterDialect.this.dictionary, path)) {
                    throw new RSQLParseException(String.format("Invalid association %s. toMany association has to be the target collection.", relationship));
                }
                return this.buildIsEmptyOperator(path, arguments);
            }
            if (op.equals((Object)HASMEMBER_OP) || op.equals((Object)HASNOMEMBER_OP)) {
                if (FilterPredicate.toManyInPath(RSQLFilterDialect.this.dictionary, path)) {
                    if (FilterPredicate.isLastPathElementAssignableFrom(RSQLFilterDialect.this.dictionary, path, ClassType.COLLECTION_TYPE)) {
                        throw new RSQLParseException("Invalid Path: Last Path Element cannot be a collection type");
                    }
                } else if (!FilterPredicate.isLastPathElementAssignableFrom(RSQLFilterDialect.this.dictionary, path, ClassType.COLLECTION_TYPE)) {
                    throw new RSQLParseException("Invalid Path: Last Path Element has to be a collection type");
                }
            }
            if (FilterPredicate.toManyInPath(RSQLFilterDialect.this.dictionary, path) && !this.allowNestedToManyAssociations) {
                throw new RSQLParseException(String.format("Invalid association %s", relationship));
            }
            if (op.equals((Object)ISNULL_OP)) {
                return this.buildIsNullOperator(path, arguments);
            }
            Type relationshipType = path.lastElement().map(Path.PathElement::getFieldType).orElseThrow(() -> new IllegalStateException("Path must not be empty"));
            List<Object> values = arguments.stream().map(argument -> TypeHelper.isPrimitiveNumberType(relationshipType) || ClassType.NUMBER_TYPE.isAssignableFrom(relationshipType) ? argument.replace("*", "") : argument).map(argument -> {
                try {
                    return CoerceUtil.coerce(argument, relationshipType);
                }
                catch (InvalidValueException e) {
                    if (this.coerceValues) {
                        throw e;
                    }
                    return argument;
                }
            }).collect(Collectors.toList());
            if (op.equals((Object)RSQLOperators.EQUAL) || op.equals((Object)RSQLOperators.IN)) {
                return this.equalityExpression((String)arguments.get(0), path, values, true);
            }
            if (op.equals((Object)INI)) {
                return this.equalityExpression((String)arguments.get(0), path, values, false);
            }
            if (op.equals((Object)RSQLOperators.NOT_EQUAL) || op.equals((Object)RSQLOperators.NOT_IN)) {
                return new NotFilterExpression(this.equalityExpression((String)arguments.get(0), path, values, true));
            }
            if (op.equals((Object)NOT_INI)) {
                return new NotFilterExpression(this.equalityExpression((String)arguments.get(0), path, values, false));
            }
            if (OPERATOR_MAP.containsKey(op)) {
                return new FilterPredicate(path, OPERATOR_MAP.get(op), values);
            }
            throw new RSQLParseException(String.format("Invalid Operator %s", op.getSymbol()));
        }

        private FilterExpression equalityExpression(String argument, Path path, List<Object> values, boolean caseSensitive) {
            boolean startsWith = argument.startsWith("*");
            boolean endsWith = argument.endsWith("*");
            if (startsWith && endsWith && argument.length() > 2) {
                String value = argument.substring(1, argument.length() - 1);
                Operator op = caseSensitive ? RSQLFilterDialect.this.caseSensitivityStrategy.mapOperator(Operator.INFIX) : Operator.INFIX_CASE_INSENSITIVE;
                return new FilterPredicate(path, op, Collections.singletonList(value));
            }
            if (startsWith && argument.length() > 1) {
                String value = argument.substring(1, argument.length());
                Operator op = caseSensitive ? RSQLFilterDialect.this.caseSensitivityStrategy.mapOperator(Operator.POSTFIX) : Operator.POSTFIX_CASE_INSENSITIVE;
                return new FilterPredicate(path, op, Collections.singletonList(value));
            }
            if (endsWith && argument.length() > 1) {
                String value = argument.substring(0, argument.length() - 1);
                Operator op = caseSensitive ? RSQLFilterDialect.this.caseSensitivityStrategy.mapOperator(Operator.PREFIX) : Operator.PREFIX_CASE_INSENSITIVE;
                return new FilterPredicate(path, op, Collections.singletonList(value));
            }
            boolean isStringLike = path.lastElement().filter(e -> e.getFieldType().isAssignableFrom(ClassType.STRING_TYPE)).isPresent();
            if (isStringLike) {
                Operator op = caseSensitive ? RSQLFilterDialect.this.caseSensitivityStrategy.mapOperator(Operator.IN) : Operator.IN_INSENSITIVE;
                return new FilterPredicate(path, op, values);
            }
            return caseSensitive ? new InPredicate(path, values) : new InInsensitivePredicate(path, values);
        }

        private FilterExpression buildIsNullOperator(Path path, List<String> arguments) {
            String arg = arguments.get(0);
            try {
                boolean wantsNull = CoerceUtil.coerce((Object)arg, Boolean.TYPE);
                if (wantsNull) {
                    return new IsNullPredicate(path);
                }
                return new NotNullPredicate(path);
            }
            catch (InvalidValueException ignored) {
                throw new RSQLParseException(String.format("Invalid value for operator =isnull= '%s'", arg));
            }
        }

        private FilterExpression buildIsEmptyOperator(Path path, List<String> arguments) {
            String arg = arguments.get(0);
            try {
                boolean wantsEmpty = CoerceUtil.coerce((Object)arg, Boolean.TYPE);
                if (wantsEmpty) {
                    return new IsEmptyPredicate(path);
                }
                return new NotEmptyPredicate(path);
            }
            catch (InvalidValueException ignored) {
                throw new RSQLParseException(String.format("Invalid value for operator =isempty= '%s'", arg));
            }
        }
    }

    public static class RSQLFilterDialectBuilder {
        private EntityDictionary dictionary;
        private CaseSensitivityStrategy caseSensitivityStrategy;
        private Boolean addDefaultArguments;

        RSQLFilterDialectBuilder() {
        }

        public RSQLFilterDialectBuilder dictionary(EntityDictionary dictionary) {
            this.dictionary = dictionary;
            return this;
        }

        public RSQLFilterDialectBuilder caseSensitivityStrategy(CaseSensitivityStrategy caseSensitivityStrategy) {
            this.caseSensitivityStrategy = caseSensitivityStrategy;
            return this;
        }

        public RSQLFilterDialectBuilder addDefaultArguments(Boolean addDefaultArguments) {
            this.addDefaultArguments = addDefaultArguments;
            return this;
        }

        public RSQLFilterDialect build() {
            return new RSQLFilterDialect(this.dictionary, this.caseSensitivityStrategy, this.addDefaultArguments);
        }

        public String toString() {
            return "RSQLFilterDialect.RSQLFilterDialectBuilder(dictionary=" + this.dictionary + ", caseSensitivityStrategy=" + this.caseSensitivityStrategy + ", addDefaultArguments=" + this.addDefaultArguments + ")";
        }
    }

    public static class RSQLParseException
    extends RSQLParserException {
        private String message;

        RSQLParseException(String message) {
            super(null);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

