/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.graal;

import com.yahoo.elide.core.utils.ClassScannerCache;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class ElideFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ClassScannerCache.getInstance().values().stream().forEach(set -> set.stream().forEach(xva$0 -> this.register((Class<?>)xva$0)));
    }

    void register(Class<?> ... classes) {
        Arrays.stream(classes).forEach(clazz -> {
            System.out.println("Elide registering class " + clazz + " for reflection");
            RuntimeReflection.register((Class[])new Class[]{clazz});
            for (Field field : clazz.getFields()) {
                RuntimeReflection.register((Field[])new Field[]{field});
            }
            for (AccessibleObject accessibleObject : clazz.getMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{accessibleObject});
            }
            for (AccessibleObject accessibleObject : clazz.getConstructors()) {
                RuntimeReflection.register((Executable[])new Executable[]{accessibleObject});
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                RuntimeReflection.register((Field[])new Field[]{accessibleObject});
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{accessibleObject});
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredConstructors()) {
                RuntimeReflection.register((Executable[])new Executable[]{accessibleObject});
            }
        });
    }
}

