/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.permissions.expressions;

import com.yahoo.elide.core.security.permissions.ExpressionResult;
import com.yahoo.elide.core.security.permissions.expressions.Expression;
import com.yahoo.elide.core.security.permissions.expressions.ExpressionVisitor;
import org.fusesource.jansi.Ansi;

public class BooleanExpression
implements Expression {
    private boolean value;

    public BooleanExpression(boolean value) {
        this.value = value;
    }

    @Override
    public ExpressionResult evaluate(Expression.EvaluationMode mode) {
        if (this.value) {
            return ExpressionResult.PASS;
        }
        return ExpressionResult.FAIL;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitBooleanExpression(this);
    }

    public String toString() {
        Ansi.Color color = this.value ? Ansi.Color.GREEN : Ansi.Color.RED;
        String label = this.value ? "SUCCESS" : "FAILURE";
        return Ansi.ansi().fg(color).a(label).reset().toString();
    }
}

