/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.permissions.expressions;

import com.yahoo.elide.core.security.permissions.ExpressionResult;
import com.yahoo.elide.core.security.permissions.PermissionCondition;
import com.yahoo.elide.core.security.permissions.expressions.Expression;
import com.yahoo.elide.core.security.permissions.expressions.ExpressionVisitor;
import java.util.Optional;

public class SpecificFieldExpression
implements Expression {
    private final Expression entityExpression;
    private final Optional<Expression> fieldExpression;
    private final PermissionCondition condition;

    public SpecificFieldExpression(PermissionCondition condition, Expression entityExpression, Expression fieldExpression) {
        this.condition = condition;
        this.entityExpression = entityExpression;
        this.fieldExpression = Optional.ofNullable(fieldExpression);
    }

    @Override
    public ExpressionResult evaluate(Expression.EvaluationMode mode) {
        if (!this.fieldExpression.isPresent()) {
            return this.entityExpression == null ? ExpressionResult.PASS : this.entityExpression.evaluate(mode);
        }
        return this.fieldExpression.get().evaluate(mode);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitSpecificFieldExpression(this);
    }

    public String toString() {
        return this.fieldExpression.map(fe -> String.format("%s FOR EXPRESSION [FIELD(%s)]", this.condition, fe)).orElseGet(() -> {
            if (this.entityExpression == null) {
                return String.format("%s FOR EXPRESSION []", this.condition);
            }
            return String.format("%s FOR EXPRESSION [ENTITY(%s)]", this.condition, this.entityExpression);
        });
    }

    public PermissionCondition getCondition() {
        return this.condition;
    }
}

