/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.utils;

import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.ClassScannerCache;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultClassScanner
implements ClassScanner {
    private final Map<String, Set<Class<?>>> startupCache;
    private static DefaultClassScanner _instance;

    public DefaultClassScanner(Map<String, Set<Class<?>>> startupCache) {
        this.startupCache = startupCache;
    }

    public DefaultClassScanner() {
        this.startupCache = ClassScannerCache.getInstance();
    }

    @Override
    public Set<Class<?>> getAnnotatedClasses(Package toScan, Class<? extends Annotation> annotation) {
        return this.getAnnotatedClasses(toScan.getName(), annotation);
    }

    @Override
    public Set<Class<?>> getAnnotatedClasses(String packageName, Class<? extends Annotation> annotation) {
        return this.startupCache.get(annotation.getCanonicalName()).stream().filter(clazz -> clazz.getPackage().getName().equals(packageName) || clazz.getPackage().getName().startsWith(packageName + ".")).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<Class<?>> getAnnotatedClasses(List<Class<? extends Annotation>> annotations, ClassScanner.FilterExpression filter) {
        LinkedHashSet result = new LinkedHashSet();
        for (Class<? extends Annotation> annotation : annotations) {
            result.addAll(this.startupCache.get(annotation.getCanonicalName()).stream().filter(filter::include).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        return result;
    }

    @Override
    public Set<Class<?>> getAnnotatedClasses(List<Class<? extends Annotation>> annotations) {
        return this.getAnnotatedClasses(annotations, (Class clazz) -> true);
    }

    @Override
    public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> ... annotations) {
        return this.getAnnotatedClasses(Arrays.asList(annotations));
    }

    @Override
    public Set<Class<?>> getAllClasses(String packageName) {
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().acceptPackages(new String[]{packageName}).scan();){
            Set set = scanResult.getAllClasses().stream().map(ClassInfo::loadClass).collect(Collectors.toCollection(LinkedHashSet::new));
            return set;
        }
    }

    public static synchronized DefaultClassScanner getInstance() {
        if (_instance == null) {
            _instance = new DefaultClassScanner();
        }
        return _instance;
    }
}

