/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.utils.coerce.converters;

import com.yahoo.elide.core.utils.coerce.converters.Serde;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class InstantSerde
implements Serde<String, Instant> {
    @Override
    public Instant deserialize(String value) {
        try {
            return Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(value));
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public String serialize(Instant value) {
        return DateTimeFormatter.ISO_INSTANT.format(value);
    }
}

