/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.document.processors;

import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.jsonapi.document.processors.DocumentProcessor;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Meta;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class PopulateMetaProcessor
implements DocumentProcessor {
    @Override
    public void execute(JsonApiDocument jsonApiDocument, RequestScope scope, PersistentResource persistentResource, MultivaluedMap<String, String> queryParams) {
        this.addDocumentMeta(jsonApiDocument, scope);
    }

    private void addDocumentMeta(JsonApiDocument document, RequestScope scope) {
        Set<String> fields = scope.getMetadataFields();
        if (fields.size() == 0) {
            return;
        }
        Meta meta = document.getMeta();
        if (meta == null) {
            meta = new Meta(new HashMap<String, Object>());
        }
        for (String field : fields) {
            meta.getMetaMap().put(field, scope.getMetadataField(field).get());
        }
        document.setMeta(meta);
    }

    @Override
    public void execute(JsonApiDocument jsonApiDocument, RequestScope scope, LinkedHashSet<PersistentResource> resources, MultivaluedMap<String, String> queryParams) {
        this.addDocumentMeta(jsonApiDocument, scope);
    }
}

