/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.extensions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.JsonPatchExtensionException;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.extensions.PatchRequestScope;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Patch;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.parser.DeleteVisitor;
import com.yahoo.elide.jsonapi.parser.JsonApiParser;
import com.yahoo.elide.jsonapi.parser.PatchVisitor;
import com.yahoo.elide.jsonapi.parser.PostVisitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.encoder.Encode;

public class JsonApiPatch {
    private final List<PatchAction> actions;
    private final String rootUri;
    private static final ObjectNode ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION;
    private static final ObjectNode ERR_NODE_OPERATION_NOT_RUN;

    public static Supplier<Pair<Integer, JsonNode>> processJsonPatch(DataStore dataStore, String uri, String patchDoc, PatchRequestScope requestScope) {
        List<Patch> actions;
        try {
            actions = requestScope.getMapper().readJsonApiPatchExtDoc(patchDoc);
        }
        catch (IOException e) {
            throw new InvalidEntityBodyException(patchDoc);
        }
        JsonApiPatch processor = new JsonApiPatch(dataStore, actions, uri, requestScope);
        return processor.processActions(requestScope);
    }

    private JsonApiPatch(DataStore dataStore, List<Patch> actions, String rootUri, RequestScope requestScope) {
        this.actions = actions.stream().map(PatchAction::new).collect(Collectors.toList());
        this.rootUri = rootUri;
    }

    private Supplier<Pair<Integer, JsonNode>> processActions(PatchRequestScope requestScope) {
        try {
            List<Supplier<Pair<Integer, JsonApiDocument>>> results = this.handleActions(requestScope);
            this.postProcessRelationships(requestScope);
            return () -> {
                try {
                    return Pair.of((Object)200, (Object)JsonApiPatch.mergeResponse(results, requestScope.getMapper()));
                }
                catch (HttpStatusException e) {
                    this.throwErrorResponse();
                    return null;
                }
            };
        }
        catch (HttpStatusException e) {
            this.throwErrorResponse();
            return () -> null;
        }
    }

    private List<Supplier<Pair<Integer, JsonApiDocument>>> handleActions(PatchRequestScope requestScope) {
        return this.actions.stream().map(action -> {
            try {
                String path = action.patch.getPath();
                if (path == null) {
                    throw new InvalidEntityBodyException("Patch extension requires all objects to have an assigned path");
                }
                CharSequence[] combined = (String[])ArrayUtils.addAll((Object[])this.rootUri.split("/"), (Object[])action.patch.getPath().split("/"));
                String fullPath = String.join((CharSequence)"/", combined).replace("/-", "");
                Patch.Operation operation = action.patch.getOperation();
                if (operation == null) {
                    throw new InvalidEntityBodyException("Patch extension operation cannot be null.");
                }
                return switch (operation) {
                    case Patch.Operation.ADD -> this.handleAddOp(fullPath, action.patch.getValue(), requestScope, (PatchAction)action);
                    case Patch.Operation.REPLACE -> this.handleReplaceOp(fullPath, action.patch.getValue(), requestScope, (PatchAction)action);
                    case Patch.Operation.REMOVE -> this.handleRemoveOp(fullPath, action.patch.getValue(), requestScope);
                    default -> throw new InvalidEntityBodyException("Could not parse patch extension operation:" + action.patch.getOperation());
                };
            }
            catch (HttpStatusException e) {
                action.cause = e;
                throw e;
            }
        }).collect(Collectors.toList());
    }

    private Supplier<Pair<Integer, JsonApiDocument>> handleAddOp(String path, JsonNode patchValue, PatchRequestScope requestScope, PatchAction action) {
        try {
            JsonApiDocument value = requestScope.getMapper().readJsonApiPatchExtValue(patchValue);
            Data<Resource> data = value.getData();
            if (data == null || data.get() == null) {
                throw new InvalidEntityBodyException("Expected an entity body but received none.");
            }
            Collection<Resource> resources = data.get();
            if (!path.contains("relationships")) {
                String id = JsonApiPatch.getSingleResource(resources).getId();
                if (StringUtils.isEmpty((CharSequence)id)) {
                    throw new InvalidEntityBodyException("Patch extension requires all objects to have an assigned ID (temporary or permanent) when assigning relationships.");
                }
                String fullPath = path + "/" + id;
                JsonApiPatch.getSingleResource(resources).setRelationships(null);
                action.doc = requestScope.getMapper().readJsonApiPatchExtValue(patchValue);
                action.path = fullPath;
                action.isPostProcessing = true;
            }
            PostVisitor visitor = new PostVisitor(new PatchRequestScope(path, value, requestScope));
            return (Supplier)visitor.visit(JsonApiParser.parse(path));
        }
        catch (HttpStatusException e) {
            action.cause = e;
            throw e;
        }
        catch (IOException e) {
            throw new InvalidEntityBodyException("Could not parse patch extension value: " + patchValue);
        }
    }

    private Supplier<Pair<Integer, JsonApiDocument>> handleReplaceOp(String path, JsonNode patchVal, PatchRequestScope requestScope, PatchAction action) {
        try {
            JsonApiDocument value = requestScope.getMapper().readJsonApiPatchExtValue(patchVal);
            if (!path.contains("relationships")) {
                Data<Resource> data = value.getData();
                Collection<Resource> resources = data.get();
                JsonApiPatch.getSingleResource(resources).setRelationships(null);
                action.doc = requestScope.getMapper().readJsonApiPatchExtValue(patchVal);
                action.path = path;
                action.isPostProcessing = true;
            }
            PatchVisitor visitor = new PatchVisitor(new PatchRequestScope(path, value, requestScope));
            return (Supplier)visitor.visit(JsonApiParser.parse(path));
        }
        catch (IOException e) {
            throw new InvalidEntityBodyException("Could not parse patch extension value: " + patchVal);
        }
    }

    private Supplier<Pair<Integer, JsonApiDocument>> handleRemoveOp(String path, JsonNode patchValue, PatchRequestScope requestScope) {
        try {
            Object fullPath;
            JsonApiDocument value = requestScope.getMapper().readJsonApiPatchExtValue(patchValue);
            if (path.contains("relationships")) {
                fullPath = path;
            } else {
                Data<Resource> data = value.getData();
                if (data == null || data.get() == null) {
                    fullPath = path;
                } else {
                    Collection<Resource> resources = data.get();
                    String id = JsonApiPatch.getSingleResource(resources).getId();
                    fullPath = path + "/" + id;
                }
            }
            DeleteVisitor visitor = new DeleteVisitor(new PatchRequestScope(path, value, requestScope));
            return (Supplier)visitor.visit(JsonApiParser.parse((String)fullPath));
        }
        catch (IOException e) {
            throw new InvalidEntityBodyException("Could not parse patch extension value: " + patchValue);
        }
    }

    private void postProcessRelationships(PatchRequestScope requestScope) {
        this.actions.forEach(action -> action.postProcess(requestScope));
    }

    private void throwErrorResponse() {
        ArrayNode errorContainer = this.getErrorContainer();
        boolean failed = false;
        for (PatchAction action : this.actions) {
            failed = this.processAction(errorContainer, failed, action);
        }
        JsonPatchExtensionException failure = new JsonPatchExtensionException(400, (JsonNode)errorContainer);
        for (PatchAction action : this.actions) {
            if (action.cause == null) continue;
            failure.addSuppressed(action.cause);
        }
        throw failure;
    }

    private ArrayNode getErrorContainer() {
        return JsonNodeFactory.instance.arrayNode();
    }

    private boolean processAction(ArrayNode errorList, boolean failed, PatchAction action) {
        ObjectNode container = JsonNodeFactory.instance.objectNode();
        ArrayNode errors = JsonNodeFactory.instance.arrayNode();
        container.set("errors", (JsonNode)errors);
        errorList.add((JsonNode)container);
        if (action.cause != null) {
            errors.add(JsonApiPatch.toErrorNode(action.cause.getMessage(), action.cause.getStatus()));
            failed = true;
        } else if (!failed) {
            errors.add((JsonNode)ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION);
        } else {
            errors.add((JsonNode)ERR_NODE_OPERATION_NOT_RUN);
        }
        return failed;
    }

    private static void clearAllExceptRelationships(JsonApiDocument doc) {
        Data<Resource> data = doc.getData();
        if (data == null || data.get() == null) {
            return;
        }
        data.get().forEach(JsonApiPatch::clearAllExceptRelationships);
    }

    private static void clearAllExceptRelationships(Resource resource) {
        resource.setAttributes(null);
        resource.setLinks(null);
        resource.setMeta(null);
    }

    private static JsonNode toErrorNode(String detail, Integer status) {
        ObjectNode formattedError = JsonNodeFactory.instance.objectNode();
        formattedError.set("detail", (JsonNode)JsonNodeFactory.instance.textNode(Encode.forHtml((String)detail)));
        if (status != null) {
            formattedError.set("status", (JsonNode)JsonNodeFactory.instance.textNode(status.toString()));
        }
        return formattedError;
    }

    private static JsonNode mergeResponse(List<Supplier<Pair<Integer, JsonApiDocument>>> results, JsonApiMapper mapper) {
        ArrayNode list = JsonNodeFactory.instance.arrayNode();
        for (Supplier<Pair<Integer, JsonApiDocument>> result : results) {
            JsonApiDocument document = (JsonApiDocument)result.get().getRight();
            JsonNode node = document == null ? JsonNodeFactory.instance.objectNode().set("data", null) : mapper.toJsonObject(document);
            list.add(node);
        }
        return list;
    }

    public static boolean isPatchExtension(String header) {
        if (header == null) {
            return false;
        }
        return Arrays.stream(header.split(";")).map(key -> key.split("=")).filter(value -> ((String[])value).length == 2).anyMatch(value -> value[0].trim().equals("ext") && value[1].trim().equals("jsonpatch"));
    }

    private static Resource getSingleResource(Collection<Resource> resources) {
        if (resources == null || resources.size() != 1) {
            throw new InvalidEntityBodyException("Expected single resource.");
        }
        return (Resource)IterableUtils.first(resources);
    }

    static {
        ERR_NODE_OPERATION_NOT_RUN = JsonNodeFactory.instance.objectNode();
        ERR_NODE_OPERATION_NOT_RUN.set("detail", (JsonNode)JsonNodeFactory.instance.textNode("Operation not executed. Terminated by earlier failure."));
        ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION = JsonNodeFactory.instance.objectNode();
        ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION.set("detail", (JsonNode)JsonNodeFactory.instance.textNode("Subsequent operation failed."));
    }

    private static class PatchAction {
        public final Patch patch;
        public HttpStatusException cause;
        public boolean isPostProcessing;
        public JsonApiDocument doc;
        public String path;

        public PatchAction(Patch patch) {
            this.patch = patch;
            this.cause = null;
        }

        public void postProcess(PatchRequestScope requestScope) {
            if (this.isPostProcessing) {
                try {
                    JsonApiPatch.clearAllExceptRelationships(this.doc);
                    PatchVisitor visitor = new PatchVisitor(new PatchRequestScope(this.path, this.doc, requestScope));
                    visitor.visit(JsonApiParser.parse(this.path));
                }
                catch (HttpStatusException e) {
                    this.cause = e;
                    throw e;
                }
            }
        }
    }
}

